package org.apache.pulsar.websocket;

import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.websocket.stats.StatsBuckets;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;

public interface ProducerHandlerInterface {
    Producer<byte[]> getProducer();

    long getAndResetNumMsgsSent();

    long getAndResetNumBytesSent();

    long getAndResetNumMsgsFailed();

    StatsBuckets getPublishLatencyStatsUSec();

    RemoteEndpoint getRemote();

    long getMsgPublishedCounter();
}
