package org.apache.pulsar.websocket;

import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.SubscriptionMode;
import org.apache.pulsar.client.api.SubscriptionType;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;

public interface ConsumerHandlerInterface {
    Consumer<byte[]> getConsumer();

    long getAndResetNumMsgsAcked();

    long getAndResetNumBytesDelivered();

    long getMsgDeliveredCounter();

    String getSubscription();

    SubscriptionType getSubscriptionType();

    SubscriptionMode getSubscriptionMode();

    RemoteEndpoint getRemote();
}
