/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.websocket;

import io.jsonwebtoken.JwtException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.websocket.JwtAccessModeException;
import org.apache.pulsar.websocket.JwtClaimsHelper;

public class RelNotifToken {
    private static final Set<String> binaryNamespaces = new HashSet<String>(Arrays.asList("mqtt"));
    private final TopicName topicName;
    private final String subscriptionName;
    private final boolean isReadOnly;
    private final boolean isWriteOnly;
    private boolean isBinaryProtocolOnly;
    private final boolean sharedSubscription;
    private final boolean isVolatile;

    public RelNotifToken(String tokenString, String keyFile) {
        Map<String, Object> claims = JwtClaimsHelper.getJwtClaims(tokenString, keyFile);
        try {
            String[] topic = ((String)claims.get("topic")).split("/");
            this.subscriptionName = (String)claims.get("sub");
            this.isReadOnly = "true".equals(claims.get("readOnly"));
            this.isWriteOnly = "true".equals(claims.get("writeOnly"));
            this.sharedSubscription = "true".equals(claims.get("shared"));
            this.isVolatile = "true".equals(claims.get("volatile"));
            this.isBinaryProtocolOnly = "true".equals(claims.get("binaryOnly"));
            this.topicName = TopicName.get((String)(this.isVolatile ? "non-persistent" : "persistent"), (NamespaceName)NamespaceName.get((String)topic[0], (String)topic[1]), (String)topic[2]);
        }
        catch (Exception e) {
            throw new JwtException("Invalid claims in token");
        }
    }

    public static boolean isBinaryNamespace(String namespace) {
        return binaryNamespaces.contains(namespace);
    }

    public void verifyCanRead() {
        if (this.isWriteOnly) {
            throw new JwtAccessModeException("Write only token");
        }
    }

    public void verifyCanWrite() {
        if (this.isReadOnly) {
            throw new JwtAccessModeException("Read only token");
        }
    }

    public void verifyWebSocketAllowed() {
        if (this.isBinaryProtocolOnly) {
            throw new JwtAccessModeException("Binary protocol only token");
        }
    }

    public TopicName getTopicName() {
        return this.topicName;
    }

    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    public Optional<SubscriptionType> getSubscriptionType() {
        if (this.sharedSubscription) {
            return Optional.of(SubscriptionType.Key_Shared);
        }
        return Optional.empty();
    }

    public boolean isVolatile() {
        return this.isVolatile;
    }

    public Optional<String> getAckTimeoutMillis(Map<String, String> queryParams) {
        return Optional.empty();
    }

    public Optional<Integer> getReceiverQueueSize(Map<String, String> queryParams) {
        return Optional.empty();
    }

    public Optional<Integer> getBatchingMaxMessages(Map<String, String> queryParams) {
        return Optional.empty();
    }

    public Optional<Integer> getMaxPendingMessages(Map<String, String> queryParams) {
        return Optional.empty();
    }
}

