/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.websocket;

import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.Jwts;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.Map;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtClaimsHelper {
    private static final Logger log = LoggerFactory.getLogger(JwtClaimsHelper.class);
    private static PublicKey publicKey = null;
    private static String publicKeySignature;

    public static Map<String, Object> getJwtClaims(String jws, String keyFile) {
        try {
            return JwtClaimsHelper.getJwtClaims(jws, JwtClaimsHelper.getPublicKey(keyFile));
        }
        catch (JwtException | IOException | InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException exn) {
            throw new JwtException(String.format("Exception when verifying claims of Notifications 2.0 token ending %s (public key SHA256 signature: %s): %s", JwtClaimsHelper.tokenEnd(jws), publicKeySignature, exn.getMessage()), exn);
        }
    }

    private static String tokenEnd(String token) {
        return token.length() < 10 ? token : token.substring(token.length() - 10);
    }

    private static Map<String, Object> getJwtClaims(String jws, PublicKey publicKey) {
        log.info("Parsing Notifications 2.0 token ending {} (public key SHA256 signature: {})", (Object)JwtClaimsHelper.tokenEnd(jws), (Object)publicKeySignature);
        Jws jwt = Jwts.parserBuilder().setSigningKey((Key)publicKey).build().parseClaimsJws(jws);
        return (Map)jwt.getBody();
    }

    private static synchronized PublicKey getPublicKey(String keyFile) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException {
        if (publicKey == null) {
            byte[] keyFileBytes = Files.readAllBytes(Paths.get(keyFile, new String[0]));
            String keyString = new String(keyFileBytes, StandardCharsets.US_ASCII);
            String strippedKeyString = keyString.trim().replace("-----BEGIN PUBLIC KEY-----\n", "").replace("\n-----END PUBLIC KEY-----", "");
            X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(Base64.getMimeDecoder().decode(strippedKeyString));
            KeyFactory pkf2 = KeyFactory.getInstance("RSA");
            publicKey = pkf2.generatePublic(publicKeySpec);
            publicKeySignature = Hex.toHexString((byte[])MessageDigest.getInstance("SHA-256").digest(keyFileBytes));
            log.info("Notifications 2.0 public key loaded: SHA256 signature: {}", (Object)publicKeySignature);
        }
        return publicKey;
    }
}

