/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.websocket.stats;

import java.util.HashSet;
import java.util.Set;
import org.apache.pulsar.client.api.SubscriptionMode;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.websocket.ConsumerHandlerInterface;
import org.apache.pulsar.websocket.ProducerHandlerInterface;
import org.apache.pulsar.websocket.ReaderHandler;

public class ProxyTopicStat {
    public final Set<ProducerStats> producerStats = new HashSet<ProducerStats>();
    public final Set<ConsumerStats> consumerStats = new HashSet<ConsumerStats>();

    public static class ConsumerStats {
        public String remoteConnection;
        public String subscriptionName;
        public SubscriptionType subscriptionType;
        public SubscriptionMode subscriptionMode;
        public long numberOfMsgDelivered;

        public ConsumerStats() {
        }

        public ConsumerStats(ConsumerHandlerInterface handler) {
            this.subscriptionName = handler.getSubscription();
            this.subscriptionType = handler.getSubscriptionType();
            this.subscriptionMode = handler.getSubscriptionMode();
            this.remoteConnection = handler.getRemote().getInetSocketAddress().toString();
            this.numberOfMsgDelivered = handler.getMsgDeliveredCounter();
        }

        public ConsumerStats(ReaderHandler handler) {
            this.subscriptionName = handler.getSubscription();
            this.subscriptionType = handler.getSubscriptionType();
            this.remoteConnection = handler.getRemote().getInetSocketAddress().toString();
            this.numberOfMsgDelivered = handler.getMsgDeliveredCounter();
        }
    }

    public static class ProducerStats {
        public String remoteConnection;
        public long numberOfMsgPublished;

        public ProducerStats() {
        }

        public ProducerStats(ProducerHandlerInterface handler) {
            this.remoteConnection = handler.getRemote().getInetSocketAddress().toString();
            this.numberOfMsgPublished = handler.getMsgPublishedCounter();
        }
    }
}

