/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.proxy.extensions;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.common.nar.NarClassLoader;
import org.apache.pulsar.common.nar.NarClassLoaderBuilder;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.proxy.extensions.ExtensionsDefinitions;
import org.apache.pulsar.proxy.extensions.ProxyExtension;
import org.apache.pulsar.proxy.extensions.ProxyExtensionDefinition;
import org.apache.pulsar.proxy.extensions.ProxyExtensionMetadata;
import org.apache.pulsar.proxy.extensions.ProxyExtensionWithClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ProxyExtensionsUtils {
    private static final Logger log = LoggerFactory.getLogger(ProxyExtensionsUtils.class);
    static final String PROXY_EXTENSION_DEFINITION_FILE = "pulsar-proxy-extension.yml";

    public static ProxyExtensionDefinition getProxyExtensionDefinition(String narPath, String narExtractionDirectory) throws IOException {
        try (NarClassLoader ncl = NarClassLoaderBuilder.builder().narFile(new File(narPath)).extractionDirectory(narExtractionDirectory).build();){
            ProxyExtensionDefinition proxyExtensionDefinition = ProxyExtensionsUtils.getProxyExtensionDefinition(ncl);
            return proxyExtensionDefinition;
        }
    }

    private static ProxyExtensionDefinition getProxyExtensionDefinition(NarClassLoader ncl) throws IOException {
        String configStr = ncl.getServiceDefinition(PROXY_EXTENSION_DEFINITION_FILE);
        return (ProxyExtensionDefinition)ObjectMapperFactory.getYamlMapper().reader().readValue(configStr, ProxyExtensionDefinition.class);
    }

    public static ExtensionsDefinitions searchForExtensions(String extensionsDirectory, String narExtractionDirectory) throws IOException {
        Path path = Paths.get(extensionsDirectory, new String[0]).toAbsolutePath();
        log.info("Searching for extensions in {}", (Object)path);
        ExtensionsDefinitions extensions = new ExtensionsDefinitions();
        if (!path.toFile().exists()) {
            log.warn("extension directory not found");
            return extensions;
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(path, "*.nar");){
            for (Path archive : stream) {
                try {
                    ProxyExtensionDefinition phDef = ProxyExtensionsUtils.getProxyExtensionDefinition(archive.toString(), narExtractionDirectory);
                    log.info("Found extension from {} : {}", (Object)archive, (Object)phDef);
                    Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)phDef.getName()));
                    Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)phDef.getExtensionClass()));
                    ProxyExtensionMetadata metadata = new ProxyExtensionMetadata();
                    metadata.setDefinition(phDef);
                    metadata.setArchivePath(archive);
                    extensions.extensions().put(phDef.getName(), metadata);
                }
                catch (Throwable t) {
                    log.warn("Failed to load connector from {}. It is OK however if you want to use this extension, please make sure you put the correct extension NAR package in the extensions directory.", (Object)archive, (Object)t);
                }
            }
        }
        return extensions;
    }

    static ProxyExtensionWithClassLoader load(ProxyExtensionMetadata metadata, String narExtractionDirectory) throws IOException {
        File narFile = metadata.getArchivePath().toAbsolutePath().toFile();
        NarClassLoader ncl = NarClassLoaderBuilder.builder().narFile(narFile).parentClassLoader(ProxyExtension.class.getClassLoader()).extractionDirectory(narExtractionDirectory).build();
        ProxyExtensionDefinition phDef = ProxyExtensionsUtils.getProxyExtensionDefinition(ncl);
        if (StringUtils.isBlank((CharSequence)phDef.getExtensionClass())) {
            throw new IOException("extension `" + phDef.getName() + "` does NOT provide a protocol handler implementation");
        }
        try {
            Class extensionClass = ncl.loadClass(phDef.getExtensionClass());
            Object extension = extensionClass.newInstance();
            if (!(extension instanceof ProxyExtension)) {
                throw new IOException("Class " + phDef.getExtensionClass() + " does not implement extension interface");
            }
            ProxyExtension ph = (ProxyExtension)extension;
            return new ProxyExtensionWithClassLoader(ph, ncl);
        }
        catch (Throwable t) {
            ProxyExtensionsUtils.rethrowIOException(t);
            return null;
        }
    }

    private static void rethrowIOException(Throwable cause) throws IOException {
        if (cause instanceof IOException) {
            throw (IOException)cause;
        }
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)cause;
        }
        if (cause instanceof Error) {
            throw (Error)cause;
        }
        throw new IOException(cause.getMessage(), cause);
    }

    private ProxyExtensionsUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

