/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.model.user;

import com.cumulocity.model.DateTimeConverter;
import com.cumulocity.model.Document;
import com.cumulocity.model.ID;
import com.cumulocity.model.Link;
import com.cumulocity.model.acl.ACLPermission;
import com.cumulocity.model.acl.DevicePermission;
import com.cumulocity.model.application.Application;
import com.cumulocity.model.application.ApplicationReference;
import com.cumulocity.model.audit.AuditLogSource;
import com.cumulocity.model.audit.annotation.IncludeFieldInAuditLog;
import com.cumulocity.model.device.NewDeviceAssignment;
import com.cumulocity.model.idtype.GId;
import com.cumulocity.model.persistence.PrePersist;
import com.cumulocity.model.user.AuthenticationSession;
import com.cumulocity.model.user.AuthenticationToken;
import com.cumulocity.model.user.AuthenticationTokenData;
import com.cumulocity.model.user.Authorities;
import com.cumulocity.model.user.Authority;
import com.cumulocity.model.user.DefaultAuthority;
import com.cumulocity.model.user.DefaultGroup;
import com.cumulocity.model.user.Group;
import com.cumulocity.model.user.InventoryAssignment;
import com.cumulocity.model.user.PasswordEncryption;
import com.cumulocity.model.user.PasswordStrength;
import com.cumulocity.model.user.RequiredAuthType;
import com.cumulocity.model.user.TokenHolder;
import com.cumulocity.model.user.UserLastPassword;
import com.cumulocity.model.user.UserOrigin;
import com.cumulocity.model.user.command.UserEmailAware;
import com.cumulocity.model.user.core.HasDevicePermissions;
import com.cumulocity.model.util.DateTimeUtils;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeComparator;
import org.joda.time.ReadableInstant;
import org.svenson.JSONProperty;
import org.svenson.JSONTypeHint;
import org.svenson.converter.JSONConverter;

@IncludeFieldInAuditLog(value={"roles", "groups", "devicePermissions", "applications", "shouldResetPassword", "enabled", "firstname", "lastname", "phone", "email", "twoFactorAuthenticationEnabled", "owner", "delegatedBy", "displayName", "passwordChangeFailCount", "passwordChangeLockedTill"})
public class User
extends Document<GId>
implements HasDevicePermissions<GId>,
UserEmailAware,
AuditLogSource {
    public static final String GROUPS = "groups";
    public static final String ROLES = "roles";
    public static final String OWNER = "owner";
    public static final String DELEGATED_BY = "delegatedBy";
    public static final String TFA_TOTP_ENCRYPTED_SECRET = "tfaTotpEncryptedSecret";
    public static final String TWO_FACTOR_AUTHENTICATION_ENABLED = "twoFactorAuthenticationEnabled";
    public static final String TFA_ENFORCED = "tfaEnforced";
    private static final long serialVersionUID = -3459815457227046252L;
    private String tfaStrategy;
    private Boolean tfaEnforced;
    private String tfaTotpEncryptedSecret;
    private String password;
    private Boolean shouldResetPassword;
    private DateTime lastPasswordChange;
    private DateTime lastTFARequest;
    private Boolean enabled;
    private String firstname;
    private String lastname;
    private String phone;
    private String email;
    private PasswordStrength passwordStrength;
    private PasswordEncryption passwordEncryption;
    private UserOrigin origin;
    private List<Authority> roles = new ArrayList<Authority>();
    @Link
    private List<Group> groups = new ArrayList<Group>();
    private List<DevicePermission> devicePermissions = new ArrayList<DevicePermission>();
    private List<AuthenticationToken> authenticationTokens = new ArrayList<AuthenticationToken>();
    @Link
    private List<Application> applications = new ArrayList<Application>();
    private List<InventoryAssignment> inventoryAssignments = new ArrayList<InventoryAssignment>();
    private Boolean twoFactorAuthenticationEnabled;
    private List<UserLastPassword> lastPasswords = new ArrayList<UserLastPassword>();
    private List<NewDeviceAssignment> newDeviceAssignments = new ArrayList<NewDeviceAssignment>();
    private String owner;
    private String delegatedBy;
    private Boolean newsletter;
    private Integer subusersCount;
    private String displayName;
    private String salt;
    @Deprecated
    private Set<TokenHolder> oauthTokens = new HashSet<TokenHolder>();
    private Integer passwordChangeFailCount;
    private DateTime passwordChangeLockedTill;
    private String requiredAuthType;
    private Map<String, AuthenticationSession> authenticationSessions = new HashMap<String, AuthenticationSession>();
    private Map<String, AuthenticationTokenData> authenticationTokensData = new HashMap<String, AuthenticationTokenData>();
    private String tokenSubject;

    private User(Map<String, Object> fragments, String username, String password, Boolean shouldResetPassword, DateTime lastPasswordChange, DateTime lastTFARequest, Boolean enabled, String firstname, String lastname, String phone, String email, PasswordStrength passwordStrength, PasswordEncryption passwordEncryption, UserOrigin origin, List<Authority> authorities, List<DefaultAuthority> defaultAuthorities, List<Group> groups, List<DevicePermission> devicePermissions, List<AuthenticationToken> authenticationTokens, List<Application> applications, List<InventoryAssignment> inventoryAssignments, Boolean twoFactorAuthenticationEnabled, List<UserLastPassword> lastPasswords, String owner, String delegatedBy, Boolean newsletter, String displayName, String tfaTotpEncryptedSecret, String tfaStrategy, Boolean tfaEnforced, Integer passwordChangeFailCount, DateTime passwordChangeLockedTill, RequiredAuthType requiredAuthType, String salt, Set<TokenHolder> oauthTokens, Map<String, AuthenticationSession> authenticationSessions, Map<String, AuthenticationTokenData> authenticationTokensData, String tokenSubject) {
        super((ID)GId.asGId((String)username), fragments);
        this.password = password;
        this.shouldResetPassword = (Boolean)MoreObjects.firstNonNull((Object)shouldResetPassword, (Object)Boolean.FALSE);
        this.lastPasswordChange = lastPasswordChange;
        this.lastTFARequest = lastTFARequest;
        this.enabled = (Boolean)MoreObjects.firstNonNull((Object)enabled, (Object)Boolean.TRUE);
        this.firstname = firstname;
        this.lastname = lastname;
        this.phone = phone;
        this.email = email;
        this.passwordStrength = passwordStrength;
        this.passwordEncryption = (PasswordEncryption)((Object)MoreObjects.firstNonNull((Object)((Object)passwordEncryption), (Object)((Object)PasswordEncryption.SHA)));
        this.origin = (UserOrigin)((Object)MoreObjects.firstNonNull((Object)((Object)origin), (Object)((Object)UserOrigin.BASIC)));
        this.roles = this.roles == null ? new ArrayList() : Lists.newArrayList((Iterable)Iterables.concat((Iterable)((Iterable)MoreObjects.firstNonNull(authorities, new ArrayList())), (Iterable)((Iterable)MoreObjects.firstNonNull((Object)Lists.newArrayList((Iterable)FluentIterable.from(defaultAuthorities).transform(DefaultAuthority.toAuthority())), new ArrayList()))));
        this.groups = groups == null ? new ArrayList<Group>() : new ArrayList<Group>(groups);
        this.devicePermissions = devicePermissions == null ? new ArrayList<DevicePermission>() : new ArrayList<DevicePermission>(devicePermissions);
        this.authenticationTokens = authenticationTokens == null ? new ArrayList<AuthenticationToken>() : new ArrayList<AuthenticationToken>(authenticationTokens);
        this.applications = applications == null ? new ArrayList<Application>() : new ArrayList<Application>(applications);
        this.inventoryAssignments = inventoryAssignments == null ? new ArrayList<InventoryAssignment>() : new ArrayList<InventoryAssignment>(inventoryAssignments);
        this.twoFactorAuthenticationEnabled = twoFactorAuthenticationEnabled;
        this.lastPasswords = lastPasswords == null ? new ArrayList<UserLastPassword>() : new ArrayList<UserLastPassword>(lastPasswords);
        this.owner = owner;
        this.delegatedBy = delegatedBy;
        this.newsletter = newsletter;
        this.displayName = displayName;
        this.tfaTotpEncryptedSecret = tfaTotpEncryptedSecret;
        this.tfaStrategy = tfaStrategy;
        this.tfaEnforced = tfaEnforced;
        this.passwordChangeFailCount = passwordChangeFailCount;
        this.passwordChangeLockedTill = passwordChangeLockedTill;
        this.requiredAuthType = RequiredAuthType.toString(requiredAuthType);
        this.salt = salt;
        Set<TokenHolder> set = this.oauthTokens = oauthTokens == null ? new HashSet<TokenHolder>() : new HashSet<TokenHolder>(oauthTokens);
        if (authenticationTokensData == null) {
            this.authenticationTokensData = new HashMap<String, AuthenticationTokenData>();
        } else {
            this.setAuthenticationTokensData(new HashMap<String, AuthenticationTokenData>(authenticationTokensData));
        }
        if (authenticationSessions == null) {
            this.authenticationSessions = new HashMap<String, AuthenticationSession>();
        } else {
            this.setAuthenticationSessions(new HashMap<String, AuthenticationSession>(authenticationSessions));
        }
        this.tokenSubject = tokenSubject;
    }

    public static User of(String username, String password, boolean enabled) {
        return User.user().username(username).password(password).enabled(enabled).build();
    }

    public User(User user) {
        this(user.getAttrs(), user.getUsername(), user.getPassword(), user.getShouldResetPassword(), user.getLastPasswordChange(), user.getLastTFARequest(), user.getEnabled(), user.getFirstname(), user.getLastname(), user.getPhone(), user.getEmail(), user.getPasswordStrength(), user.getPasswordEncryption(), user.getOrigin(), user.getRoles(), new ArrayList<DefaultAuthority>(0), user.getGroups(), user.getDevicePermissions(), user.getAuthenticationTokens(), user.getApplications(), user.getInventoryAssignments(), user.getTwoFactorAuthenticationEnabled(), user.getLastPasswords(), user.getOwner(), user.getDelegatedBy(), user.getNewsletter(), user.getDisplayName(), user.getTfaTotpEncryptedSecret(), user.getTfaStrategy(), user.getTfaEnforced(), user.getPasswordChangeFailCount(), user.getPasswordChangeLockedTill(), RequiredAuthType.fromString(user.getRequiredAuthType()), user.getSalt(), user.getOauthTokens(), user.getAuthenticationSessions(), user.getAuthenticationTokensData(), user.getTokenSubject());
    }

    @Override
    public String getUsername() {
        return this.getId() == null ? null : ((GId)this.getId()).getValue();
    }

    public void setUsername(String username) {
        this.setId((ID)(username == null ? null : GId.asGId((String)username)));
    }

    public boolean hasRole(Authority role) {
        return Authorities.containsAuthority(this.getRoles(), role);
    }

    public boolean addRole(Authority role) {
        if (this.hasRole(role)) {
            return false;
        }
        return this.roles.add(role);
    }

    public boolean removeRole(Authority role) {
        if (!this.hasRole(role)) {
            return false;
        }
        return this.roles.remove((Object)role);
    }

    public void clearRoles() {
        this.roles.clear();
    }

    public boolean hasGroup(final Group group) {
        if (group == null) {
            return false;
        }
        return FluentIterable.from(this.getGroups()).anyMatch((com.google.common.base.Predicate)new com.google.common.base.Predicate<Group>(){

            public boolean apply(Group input) {
                return ((GId)group.getId()).equals((Object)input.getId());
            }
        });
    }

    public boolean addGroup(Group group) {
        if (this.hasGroup(group)) {
            return false;
        }
        return this.groups.add(group);
    }

    public boolean removeGroup(Group group) {
        if (!this.hasGroup(group)) {
            return false;
        }
        return this.groups.remove(group);
    }

    public void clearGroups() {
        this.groups.clear();
    }

    public boolean hasDevicePermission(DevicePermission devicePermission) {
        return this.getDevicePermissions().contains(devicePermission);
    }

    public boolean addApplication(Application application) {
        if (this.hasApplication(application)) {
            return false;
        }
        return this.applications.add(application);
    }

    public boolean hasApplication(Application application) {
        return this.applications.contains(application);
    }

    public void clearApplications() {
        this.applications.clear();
    }

    public void setLastPasswordChange(DateTime lastPasswordChange) {
        DateTimeUtils.checkChronologyUTC((DateTime)lastPasswordChange);
        this.lastPasswordChange = lastPasswordChange;
    }

    @PrePersist
    public void updateLastPasswordChangeDate() {
        if (this.lastPasswordChange == null) {
            this.lastPasswordChange = DateTimeUtils.nowUTC();
        }
    }

    @Override
    public boolean addDevicePermission(DevicePermission devicePermission) {
        if (this.hasDevicePermission(devicePermission)) {
            return false;
        }
        return this.devicePermissions.add(devicePermission);
    }

    @JSONProperty(ignore=true)
    public boolean hasTwoFactorAuthenticationEnabled() {
        return this.getTwoFactorAuthenticationEnabled() != null && this.getTwoFactorAuthenticationEnabled() != false;
    }

    @JSONProperty(ignore=true)
    public boolean hasTfaEnforced() {
        return this.getTfaEnforced() != null && this.getTfaEnforced() != false;
    }

    public boolean addLastPassword(UserLastPassword password) {
        if (this.containsLastPassword(password)) {
            return false;
        }
        return this.lastPasswords.add(password);
    }

    public boolean removeLastPassword(UserLastPassword lastPassword) {
        if (!this.containsLastPassword(lastPassword)) {
            return false;
        }
        return this.lastPasswords.remove(lastPassword);
    }

    public boolean containsLastPassword(UserLastPassword password) {
        return password != null && this.containsLastPassword(password.getPassword());
    }

    public boolean containsLastPassword(String password) {
        return this.lastPasswords.contains(UserLastPassword.lastPassword().password(password).build());
    }

    public boolean addNewDeviceAssignment(NewDeviceAssignment assignment) {
        return !this.containsNewDeviceAssignment(assignment) && this.newDeviceAssignments.add(assignment);
    }

    public boolean removeNewDeviceAssignment(NewDeviceAssignment assignment) {
        return this.newDeviceAssignments.contains(assignment) && this.newDeviceAssignments.remove(assignment);
    }

    public boolean containsNewDeviceAssignment(NewDeviceAssignment assignment) {
        return this.newDeviceAssignments.contains(assignment);
    }

    @JSONProperty(ignore=true)
    public Object getLogSource() {
        return this.getUsername();
    }

    public void stripLastPasswordsToNNewest(Integer n) {
        List newUserLastPasswords;
        this.lastPasswords = newUserLastPasswords = Ordering.from((Comparator)new Comparator<UserLastPassword>(){

            @Override
            public int compare(UserLastPassword o1, UserLastPassword o2) {
                return o1.getUsedFrom().compareTo((ReadableInstant)o2.getUsedFrom());
            }
        }).greatestOf(this.lastPasswords, n.intValue());
    }

    @JSONProperty(ignore=true)
    public Set<Authority> getAllRoles() {
        HashSet<Authority> allRoles = new HashSet<Authority>();
        allRoles.addAll(this.roles);
        for (Group group : this.groups) {
            allRoles.addAll(group.getRoles());
        }
        return Collections.unmodifiableSet(allRoles);
    }

    @JSONProperty(ignore=true)
    public boolean isDeviceUser() {
        for (Group group : this.groups) {
            if (!DefaultGroup.DEVICE_GROUP.getName().equalsIgnoreCase(group.getName())) continue;
            return true;
        }
        return false;
    }

    @JSONProperty(ignore=true)
    public boolean isSystemUser() {
        return Iterables.any(this.getAllRoles(), (com.google.common.base.Predicate)new com.google.common.base.Predicate<Authority>(){

            public boolean apply(@Nullable Authority authority) {
                return DefaultAuthority.SYSTEM.getAuthority().equals(authority.getAuthority());
            }
        });
    }

    @JSONProperty(ignoreIfNull=true)
    public void setRequiredAuthType(String requiredAuthType) {
        RequiredAuthType enumValue = RequiredAuthType.fromString(requiredAuthType);
        this.requiredAuthType = enumValue.toString();
    }

    @JSONProperty(ignore=true)
    public boolean isCertificateAuthRequired() {
        return RequiredAuthType.CERTIFICATES == RequiredAuthType.fromString(this.getRequiredAuthType());
    }

    @JSONProperty(ignore=true)
    public boolean isSingleSignOnUser() {
        return UserOrigin.OAUTH2.equals((Object)this.origin);
    }

    @JSONProperty(ignore=true)
    public boolean isBasicUser() {
        return UserOrigin.BASIC.equals((Object)this.origin);
    }

    public boolean assignNewInventory(InventoryAssignment inventoryAssignment) {
        if (inventoryAssignment != null && this.hasInventoryAssigned(inventoryAssignment)) {
            return false;
        }
        return this.inventoryAssignments.add(inventoryAssignment);
    }

    public boolean hasInventoryAssigned(InventoryAssignment inventoryAssignment) {
        return FluentIterable.from(this.inventoryAssignments).anyMatch(InventoryAssignment.byId(inventoryAssignment));
    }

    public List<InventoryAssignment> findInventoryAssignmentsByManagedObject(@NonNull GId id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return FluentIterable.from(this.inventoryAssignments).filter(InventoryAssignment.byManagedObject(id)).toList();
    }

    public com.google.common.base.Optional<InventoryAssignment> findInventoryAssignmentById(@NonNull GId id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return FluentIterable.from(this.inventoryAssignments).firstMatch(InventoryAssignment.byId(id));
    }

    public void updateInventoryAssignment(InventoryAssignment inventoryAssignment) {
        this.removeInventoryAssignment(inventoryAssignment);
        this.assignNewInventory(inventoryAssignment);
    }

    public boolean removeInventoryAssignment(InventoryAssignment inventoryAssignment) {
        com.google.common.base.Optional inventoryAssignmentOptional = FluentIterable.from(this.inventoryAssignments).firstMatch(InventoryAssignment.byId(inventoryAssignment));
        Preconditions.checkArgument((boolean)inventoryAssignmentOptional.isPresent(), (Object)"Inventory assignment with id '%s' does not exist in user '%s'");
        return this.inventoryAssignments.remove(inventoryAssignmentOptional.get());
    }

    public boolean hasInventoryAssignedForManagedObject(InventoryAssignment inventoryAssignment) {
        return FluentIterable.from(this.inventoryAssignments).anyMatch(InventoryAssignment.byManagedObject(inventoryAssignment));
    }

    @Override
    public boolean removeDevicePermission(DevicePermission permission) {
        com.google.common.base.Optional devicePermission = FluentIterable.from(this.getDevicePermissions()).firstMatch(ACLPermission.ACLPermissions.byManagedObjectAndExpression(permission));
        if (devicePermission.isPresent()) {
            return this.devicePermissions.remove(permission);
        }
        return false;
    }

    public boolean removeApplication(Application application) {
        com.google.common.base.Optional applicationOptional = FluentIterable.from(this.getApplications()).firstMatch(Application.byId((GId)((GId)application.getId())));
        if (applicationOptional.isPresent()) {
            return this.applications.remove(application);
        }
        return false;
    }

    public boolean passwordChangeFailLimitReached(int limit) {
        return this.passwordChangeFailCount != null && this.passwordChangeFailCount >= limit;
    }

    public boolean passwordChangeLocked() {
        return this.passwordChangeLockedTill != null && this.passwordChangeLockedTill.isAfterNow();
    }

    @JSONProperty(ignore=true)
    public Map<String, Object> getFragments() {
        return this.getAttrs();
    }

    public void setFragments(Map<String, Object> fragments) {
        if (fragments == null) {
            for (String propertyName : this.propertyNames()) {
                this.removeProperty(propertyName);
            }
        } else {
            for (Map.Entry<String, Object> entry : fragments.entrySet()) {
                this.setProperty(entry.getKey(), entry.getValue());
            }
        }
    }

    public void setShouldResetPassword(Boolean shouldResetPassword) {
        this.shouldResetPassword = (Boolean)MoreObjects.firstNonNull((Object)shouldResetPassword, (Object)Boolean.FALSE);
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = (Boolean)MoreObjects.firstNonNull((Object)enabled, (Object)Boolean.TRUE);
    }

    public void setPasswordEncryption(PasswordEncryption passwordEncryption) {
        this.passwordEncryption = (PasswordEncryption)((Object)MoreObjects.firstNonNull((Object)((Object)passwordEncryption), (Object)((Object)PasswordEncryption.SHA)));
    }

    public void setOrigin(UserOrigin origin) {
        this.origin = (UserOrigin)((Object)MoreObjects.firstNonNull((Object)((Object)origin), (Object)((Object)UserOrigin.BASIC)));
    }

    public void setRoles(List<Authority> roles) {
        this.roles = roles == null ? new ArrayList() : roles;
    }

    public void setGroups(List<Group> groups) {
        this.groups = groups == null ? new ArrayList() : groups;
    }

    public void setDevicePermissions(List<DevicePermission> devicePermissions) {
        this.devicePermissions = devicePermissions == null ? new ArrayList() : devicePermissions;
    }

    public void setAuthenticationTokens(List<AuthenticationToken> authenticationTokens) {
        this.authenticationTokens = authenticationTokens == null ? new ArrayList() : authenticationTokens;
    }

    public void setApplications(List<Application> applications) {
        this.applications = applications == null ? new ArrayList() : applications;
    }

    public void setInventoryAssignments(List<InventoryAssignment> inventoryAssignments) {
        this.inventoryAssignments = inventoryAssignments == null ? new ArrayList() : inventoryAssignments;
    }

    public void setLastPasswords(List<UserLastPassword> lastPasswords) {
        this.lastPasswords = lastPasswords == null ? new ArrayList() : lastPasswords;
    }

    public boolean addOauthToken(TokenHolder token) {
        return this.oauthTokens.add(token);
    }

    public void setAuthenticationTokensData(Map<String, AuthenticationTokenData> authenticationTokensData) {
        if (authenticationTokensData == null) {
            this.authenticationTokensData = new HashMap<String, AuthenticationTokenData>();
        } else {
            authenticationTokensData.forEach((tokenId, value) -> value.setTokenId((String)tokenId));
            this.authenticationTokensData = authenticationTokensData;
        }
    }

    public void setAuthenticationSessions(Map<String, AuthenticationSession> authenticationSessions) {
        if (authenticationSessions == null) {
            this.authenticationSessions = new HashMap<String, AuthenticationSession>();
        } else {
            authenticationSessions.forEach((sessionId, value) -> value.setSessionId((String)sessionId));
            this.authenticationSessions = authenticationSessions;
        }
    }

    public AuthenticationTokenData addAuthenticationTokenData(AuthenticationTokenData token) {
        if (token.getTokenId() == null) {
            throw new IllegalArgumentException("Token id cannot be null.");
        }
        return this.authenticationTokensData.put(token.getTokenId(), token);
    }

    public AuthenticationSession addAuthenticationSession(AuthenticationSession session) {
        if (session.getSessionId() == null) {
            throw new IllegalArgumentException("Session id cannot be null.");
        }
        return this.authenticationSessions.put(session.getSessionId(), session);
    }

    public boolean removeAuthenticationTokensData(Predicate<AuthenticationTokenData> predicate) {
        return this.authenticationTokensData.entrySet().removeIf(entry -> predicate.test((AuthenticationTokenData)((Object)((Object)entry.getValue()))));
    }

    public AuthenticationSession removeAuthenticationSession(String sessionId) {
        return this.authenticationSessions.remove(sessionId);
    }

    public boolean removeOauthTokensWithMatchingRefreshToken(TokenHolder tokenHolderToRemove) {
        if (tokenHolderToRemove == null) {
            return false;
        }
        this.oauthTokens.removeIf(tokenHolder -> tokenHolder.getRefreshToken().equals(tokenHolderToRemove.getRefreshToken()));
        return true;
    }

    public boolean removeOauthTokenWithMatchingAccessToken(TokenHolder token) {
        if (!this.hasOauthToken(token)) {
            return false;
        }
        TokenHolder tokenToRemove = (TokenHolder)FluentIterable.from(this.getOauthTokens()).firstMatch(TokenHolder.byAccessToken(token.getAccessToken())).get();
        return this.oauthTokens.remove(tokenToRemove);
    }

    public boolean hasOauthToken(TokenHolder token) {
        if (token == null) {
            return false;
        }
        return FluentIterable.from(this.getOauthTokens()).anyMatch(TokenHolder.byAccessToken(token.getAccessToken()));
    }

    @JSONProperty(ignore=true)
    public String resolvePasswordSalt() {
        if (!Strings.isNullOrEmpty((String)this.getSalt())) {
            return this.getSalt();
        }
        return this.getUsername();
    }

    @JSONProperty(ignore=true)
    public Optional<AuthenticationSession> findAssociatedAuthenticationSession(String tokenId) {
        Optional<AuthenticationTokenData> tokenDataOptional = this.findAuthenticationTokenData(tokenId);
        return tokenDataOptional.map(tokenData -> this.authenticationSessions.get(tokenData.getSessionId()));
    }

    @JSONProperty(ignore=true)
    public Optional<AuthenticationTokenData> findAuthenticationTokenData(String tokenId) {
        return Optional.ofNullable(this.authenticationTokensData.get(tokenId));
    }

    @JSONProperty(ignore=true)
    public Optional<AuthenticationTokenData> findLastGeneratedTokenForSession(String sessionId) {
        DateTimeComparator dateTimeComparator = DateTimeComparator.getTimeOnlyInstance();
        return this.authenticationTokensData.values().stream().filter(token -> token.getSessionId().equals(sessionId)).max(Comparator.comparing(AuthenticationTokenData::getIssuedAt));
    }

    @JSONProperty(ignore=true)
    public List<AuthenticationSession> findSessionsToCleanup() {
        Set<String> validSessionIds = this.findSessionsThatCannotBeRemoved();
        return this.filterInvalidSessions(validSessionIds);
    }

    @JSONProperty(ignore=true)
    private Set<String> findSessionsThatCannotBeRemoved() {
        HashSet<String> validSessionIds = new HashSet<String>();
        for (AuthenticationTokenData tokenData : this.authenticationTokensData.values()) {
            if (!this.isSessionActive(tokenData)) continue;
            String sessionIdThatIsValid = tokenData.getSessionId();
            validSessionIds.add(sessionIdThatIsValid);
        }
        return validSessionIds;
    }

    @JSONProperty(ignore=true)
    private boolean isSessionActive(AuthenticationTokenData tokenData) {
        Optional<AuthenticationSession> sessionOptional = this.findAssociatedAuthenticationSession(tokenData.getTokenId());
        return sessionOptional.isPresent() && !sessionOptional.get().isSessionExpired() && !tokenData.isTokenTerminated();
    }

    @JSONProperty(ignore=true)
    private List<AuthenticationSession> filterInvalidSessions(Set<String> validSessionIds) {
        return this.authenticationSessions.values().stream().filter(session -> !validSessionIds.contains(session.getSessionId())).collect(Collectors.toList());
    }

    public List<TokenHolder> findTokenHoldersToCleanup(Function<TokenHolder, String> encodedTokenToIdMapper) {
        List tokenIdsToRemove = this.findAuthenticationTokenDataToCleanup().stream().map(AuthenticationTokenData::getTokenId).collect(Collectors.toList());
        return this.oauthTokens.stream().filter(tokenHolder -> {
            String tokenIdFromEncodedAccessToken = (String)encodedTokenToIdMapper.apply((TokenHolder)tokenHolder);
            if (tokenIdFromEncodedAccessToken != null) {
                return tokenIdsToRemove.contains(tokenIdFromEncodedAccessToken);
            }
            return false;
        }).collect(Collectors.toList());
    }

    @JSONProperty(ignore=true)
    public List<AuthenticationTokenData> findAuthenticationTokenDataToCleanup() {
        return this.authenticationTokensData.values().stream().filter(tokenData -> tokenData.getRefreshToken() == null && (tokenData.isTokenTerminated() || this.isSessionExpiredForToken((AuthenticationTokenData)((Object)tokenData)) || this.tokenHasNotExistingSession((AuthenticationTokenData)((Object)tokenData)))).collect(Collectors.toList());
    }

    private boolean isSessionExpiredForToken(AuthenticationTokenData tokenData) {
        return tokenData.isSessionToken() && this.authenticationSessions.containsKey(tokenData.getSessionId()) && this.authenticationSessions.get(tokenData.getSessionId()).isSessionExpired();
    }

    private boolean tokenHasNotExistingSession(AuthenticationTokenData tokenData) {
        return tokenData.getSessionId() != null && !this.authenticationSessions.containsKey(tokenData.getSessionId());
    }

    public static UserBuilder user() {
        return new UserBuilder();
    }

    @JSONProperty(ignore=true)
    public Optional<AuthenticationSession> findAuthenticationSessionById(String sessionId) {
        return Optional.ofNullable(this.authenticationSessions.get(sessionId));
    }

    @JSONProperty(ignore=true)
    public ListMultimap<String, AuthenticationTokenData> findSessionsIdsWithAssociatedTokens() {
        ArrayListMultimap sessionsAndAssociatedTokens = ArrayListMultimap.create();
        this.authenticationTokensData.values().stream().filter(token -> StringUtils.isNotBlank((CharSequence)token.getSessionId())).forEach(arg_0 -> User.lambda$findSessionsIdsWithAssociatedTokens$10((ListMultimap)sessionsAndAssociatedTokens, arg_0));
        return sessionsAndAssociatedTokens;
    }

    public void setTfaStrategy(String tfaStrategy) {
        this.tfaStrategy = tfaStrategy;
    }

    public void setTfaEnforced(Boolean tfaEnforced) {
        this.tfaEnforced = tfaEnforced;
    }

    public void setTfaTotpEncryptedSecret(String tfaTotpEncryptedSecret) {
        this.tfaTotpEncryptedSecret = tfaTotpEncryptedSecret;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setLastTFARequest(DateTime lastTFARequest) {
        this.lastTFARequest = lastTFARequest;
    }

    public void setFirstname(String firstname) {
        this.firstname = firstname;
    }

    public void setLastname(String lastname) {
        this.lastname = lastname;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setPasswordStrength(PasswordStrength passwordStrength) {
        this.passwordStrength = passwordStrength;
    }

    public void setTwoFactorAuthenticationEnabled(Boolean twoFactorAuthenticationEnabled) {
        this.twoFactorAuthenticationEnabled = twoFactorAuthenticationEnabled;
    }

    public void setNewDeviceAssignments(List<NewDeviceAssignment> newDeviceAssignments) {
        this.newDeviceAssignments = newDeviceAssignments;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void setDelegatedBy(String delegatedBy) {
        this.delegatedBy = delegatedBy;
    }

    public void setNewsletter(Boolean newsletter) {
        this.newsletter = newsletter;
    }

    public void setSubusersCount(Integer subusersCount) {
        this.subusersCount = subusersCount;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setSalt(String salt) {
        this.salt = salt;
    }

    @Deprecated
    public void setOauthTokens(Set<TokenHolder> oauthTokens) {
        this.oauthTokens = oauthTokens;
    }

    public void setPasswordChangeFailCount(Integer passwordChangeFailCount) {
        this.passwordChangeFailCount = passwordChangeFailCount;
    }

    public void setPasswordChangeLockedTill(DateTime passwordChangeLockedTill) {
        this.passwordChangeLockedTill = passwordChangeLockedTill;
    }

    public void setTokenSubject(String tokenSubject) {
        this.tokenSubject = tokenSubject;
    }

    public User withTfaStrategy(String tfaStrategy) {
        return this.tfaStrategy == tfaStrategy ? this : new User(tfaStrategy, this.tfaEnforced, this.tfaTotpEncryptedSecret, this.password, this.shouldResetPassword, this.lastPasswordChange, this.lastTFARequest, this.enabled, this.firstname, this.lastname, this.phone, this.email, this.passwordStrength, this.passwordEncryption, this.origin, this.roles, this.groups, this.devicePermissions, this.authenticationTokens, this.applications, this.inventoryAssignments, this.twoFactorAuthenticationEnabled, this.lastPasswords, this.newDeviceAssignments, this.owner, this.delegatedBy, this.newsletter, this.subusersCount, this.displayName, this.salt, this.oauthTokens, this.passwordChangeFailCount, this.passwordChangeLockedTill, this.requiredAuthType, this.authenticationSessions, this.authenticationTokensData, this.tokenSubject);
    }

    public User withTfaEnforced(Boolean tfaEnforced) {
        return this.tfaEnforced == tfaEnforced ? this : new User(this.tfaStrategy, tfaEnforced, this.tfaTotpEncryptedSecret, this.password, this.shouldResetPassword, this.lastPasswordChange, this.lastTFARequest, this.enabled, this.firstname, this.lastname, this.phone, this.email, this.passwordStrength, this.passwordEncryption, this.origin, this.roles, this.groups, this.devicePermissions, this.authenticationTokens, this.applications, this.inventoryAssignments, this.twoFactorAuthenticationEnabled, this.lastPasswords, this.newDeviceAssignments, this.owner, this.delegatedBy, this.newsletter, this.subusersCount, this.displayName, this.salt, this.oauthTokens, this.passwordChangeFailCount, this.passwordChangeLockedTill, this.requiredAuthType, this.authenticationSessions, this.authenticationTokensData, this.tokenSubject);
    }

    public User withTfaTotpEncryptedSecret(String tfaTotpEncryptedSecret) {
        return this.tfaTotpEncryptedSecret == tfaTotpEncryptedSecret ? this : new User(this.tfaStrategy, this.tfaEnforced, tfaTotpEncryptedSecret, this.password, this.shouldResetPassword, this.lastPasswordChange, this.lastTFARequest, this.enabled, this.firstname, this.lastname, this.phone, this.email, this.passwordStrength, this.passwordEncryption, this.origin, this.roles, this.groups, this.devicePermissions, this.authenticationTokens, this.applications, this.inventoryAssignments, this.twoFactorAuthenticationEnabled, this.lastPasswords, this.newDeviceAssignments, this.owner, this.delegatedBy, this.newsletter, this.subusersCount, this.displayName, this.salt, this.oauthTokens, this.passwordChangeFailCount, this.passwordChangeLockedTill, this.requiredAuthType, this.authenticationSessions, this.authenticationTokensData, this.tokenSubject);
    }

    public User withPassword(String password) {
        return this.password == password ? this : new User(this.tfaStrategy, this.tfaEnforced, this.tfaTotpEncryptedSecret, password, this.shouldResetPassword, this.lastPasswordChange, this.lastTFARequest, this.enabled, this.firstname, this.lastname, this.phone, this.email, this.passwordStrength, this.passwordEncryption, this.origin, this.roles, this.groups, this.devicePermissions, this.authenticationTokens, this.applications, this.inventoryAssignments, this.twoFactorAuthenticationEnabled, this.lastPasswords, this.newDeviceAssignments, this.owner, this.delegatedBy, this.newsletter, this.subusersCount, this.displayName, this.salt, this.oauthTokens, this.passwordChangeFailCount, this.passwordChangeLockedTill, this.requiredAuthType, this.authenticationSessions, this.authenticationTokensData, this.tokenSubject);
    }

    public User withShouldResetPassword(Boolean shouldResetPassword) {
        return this.shouldResetPassword == shouldResetPassword ? this : new User(this.tfaStrategy, this.tfaEnforced, this.tfaTotpEncryptedSecret, this.password, shouldResetPassword, this.lastPasswordChange, this.lastTFARequest, this.enabled, this.firstname, this.lastname, this.phone, this.email, this.passwordStrength, this.passwordEncryption, this.origin, this.roles, this.groups, this.devicePermissions, this.authenticationTokens, this.applications, this.inventoryAssignments, this.twoFactorAuthenticationEnabled, this.lastPasswords, this.newDeviceAssignments, this.owner, this.delegatedBy, this.newsletter, this.subusersCount, this.displayName, this.salt, this.oauthTokens, this.passwordChangeFailCount, this.passwordChangeLockedTill, this.requiredAuthType, this.authenticationSessions, this.authenticationTokensData, this.tokenSubject);
    }

    public User withLastPasswordChange(DateTime lastPasswordChange) {
        return this.lastPasswordChange == lastPasswordChange ? this : new User(this.tfaStrategy, this.tfaEnforced, this.tfaTotpEncryptedSecret, this.password, this.shouldResetPassword, lastPasswordChange, this.lastTFARequest, this.enabled, this.firstname, this.lastname, this.phone, this.email, this.passwordStrength, this.passwordEncryption, this.origin, this.roles, this.groups, this.devicePermissions, this.authenticationTokens, this.applications, this.inventoryAssignments, this.twoFactorAuthenticationEnabled, this.lastPasswords, this.newDeviceAssignments, this.owner, this.delegatedBy, this.newsletter, this.subusersCount, this.displayName, this.salt, this.oauthTokens, this.passwordChangeFailCount, this.passwordChangeLockedTill, this.requiredAuthType, this.authenticationSessions, this.authenticationTokensData, this.tokenSubject);
    }

    public User withLastTFARequest(DateTime lastTFARequest) {
        return this.lastTFARequest == lastTFARequest ? this : new User(this.tfaStrategy, this.tfaEnforced, this.tfaTotpEncryptedSecret, this.password, this.shouldResetPassword, this.lastPasswordChange, lastTFARequest, this.enabled, this.firstname, this.lastname, this.phone, this.email, this.passwordStrength, this.passwordEncryption, this.origin, this.roles, this.groups, this.devicePermissions, this.authenticationTokens, this.applications, this.inventoryAssignments, this.twoFactorAuthenticationEnabled, this.lastPasswords, this.newDeviceAssignments, this.owner, this.delegatedBy, this.newsletter, this.subusersCount, this.displayName, this.salt, this.oauthTokens, this.passwordChangeFailCount, this.passwordChangeLockedTill, this.requiredAuthType, this.authenticationSessions, this.authenticationTokensData, this.tokenSubject);
    }

    public User withEnabled(Boolean enabled) {
        return this.enabled == enabled ? this : new User(this.tfaStrategy, this.tfaEnforced, this.tfaTotpEncryptedSecret, this.password, this.shouldResetPassword, this.lastPasswordChange, this.lastTFARequest, enabled, this.firstname, this.lastname, this.phone, this.email, this.passwordStrength, this.passwordEncryption, this.origin, this.roles, this.groups, this.devicePermissions, this.authenticationTokens, this.applications, this.inventoryAssignments, this.twoFactorAuthenticationEnabled, this.lastPasswords, this.newDeviceAssignments, this.owner, this.delegatedBy, this.newsletter, this.subusersCount, this.displayName, this.salt, this.oauthTokens, this.passwordChangeFailCount, this.passwordChangeLockedTill, this.requiredAuthType, this.authenticationSessions, this.authenticationTokensData, this.tokenSubject);
    }

    public User withFirstname(String firstname) {
        return this.firstname == firstname ? this : new User(this.tfaStrategy, this.tfaEnforced, this.tfaTotpEncryptedSecret, this.password, this.shouldResetPassword, this.lastPasswordChange, this.lastTFARequest, this.enabled, firstname, this.lastname, this.phone, this.email, this.passwordStrength, this.passwordEncryption, this.origin, this.roles, this.groups, this.devicePermissions, this.authenticationTokens, this.applications, this.inventoryAssignments, this.twoFactorAuthenticationEnabled, this.lastPasswords, this.newDeviceAssignments, this.owner, this.delegatedBy, this.newsletter, this.subusersCount, this.displayName, this.salt, this.oauthTokens, this.passwordChangeFailCount, this.passwordChangeLockedTill, this.requiredAuthType, this.authenticationSessions, this.authenticationTokensData, this.tokenSubject);
    }

    public User withLastname(String lastname) {
        return this.lastname == lastname ? this : new User(this.tfaStrategy, this.tfaEnforced, this.tfaTotpEncryptedSecret, this.password, this.shouldResetPassword, this.lastPasswordChange, this.lastTFARequest, this.enabled, this.firstname, lastname, this.phone, this.email, this.passwordStrength, this.passwordEncryption, this.origin, this.roles, this.groups, this.devicePermissions, this.authenticationTokens, this.applications, this.inventoryAssignments, this.twoFactorAuthenticationEnabled, this.lastPasswords, this.newDeviceAssignments, this.owner, this.delegatedBy, this.newsletter, this.subusersCount, this.displayName, this.salt, this.oauthTokens, this.passwordChangeFailCount, this.passwordChangeLockedTill, this.requiredAuthType, this.authenticationSessions, this.authenticationTokensData, this.tokenSubject);
    }

    public User withPhone(String phone) {
        return this.phone == phone ? this : new User(this.tfaStrategy, this.tfaEnforced, this.tfaTotpEncryptedSecret, this.password, this.shouldResetPassword, this.lastPasswordChange, this.lastTFARequest, this.enabled, this.firstname, this.lastname, phone, this.email, this.passwordStrength, this.passwordEncryption, this.origin, this.roles, this.groups, this.devicePermissions, this.authenticationTokens, this.applications, this.inventoryAssignments, this.twoFactorAuthenticationEnabled, this.lastPasswords, this.newDeviceAssignments, this.owner, this.delegatedBy, this.newsletter, this.subusersCount, this.displayName, this.salt, this.oauthTokens, this.passwordChangeFailCount, this.passwordChangeLockedTill, this.requiredAuthType, this.authenticationSessions, this.authenticationTokensData, this.tokenSubject);
    }

    public User withEmail(String email) {
        return this.email == email ? this : new User(this.tfaStrategy, this.tfaEnforced, this.tfaTotpEncryptedSecret, this.password, this.shouldResetPassword, this.lastPasswordChange, this.lastTFARequest, this.enabled, this.firstname, this.lastname, this.phone, email, this.passwordStrength, this.passwordEncryption, this.origin, this.roles, this.groups, this.devicePermissions, this.authenticationTokens, this.applications, this.inventoryAssignments, this.twoFactorAuthenticationEnabled, this.lastPasswords, this.newDeviceAssignments, this.owner, this.delegatedBy, this.newsletter, this.subusersCount, this.displayName, this.salt, this.oauthTokens, this.passwordChangeFailCount, this.passwordChangeLockedTill, this.requiredAuthType, this.authenticationSessions, this.authenticationTokensData, this.tokenSubject);
    }

    public User withPasswordStrength(PasswordStrength passwordStrength) {
        return this.passwordStrength == passwordStrength ? this : new User(this.tfaStrategy, this.tfaEnforced, this.tfaTotpEncryptedSecret, this.password, this.shouldResetPassword, this.lastPasswordChange, this.lastTFARequest, this.enabled, this.firstname, this.lastname, this.phone, this.email, passwordStrength, this.passwordEncryption, this.origin, this.roles, this.groups, this.devicePermissions, this.authenticationTokens, this.applications, this.inventoryAssignments, this.twoFactorAuthenticationEnabled, this.lastPasswords, this.newDeviceAssignments, this.owner, this.delegatedBy, this.newsletter, this.subusersCount, this.displayName, this.salt, this.oauthTokens, this.passwordChangeFailCount, this.passwordChangeLockedTill, this.requiredAuthType, this.authenticationSessions, this.authenticationTokensData, this.tokenSubject);
    }

    public User withPasswordEncryption(PasswordEncryption passwordEncryption) {
        return this.passwordEncryption == passwordEncryption ? this : new User(this.tfaStrategy, this.tfaEnforced, this.tfaTotpEncryptedSecret, this.password, this.shouldResetPassword, this.lastPasswordChange, this.lastTFARequest, this.enabled, this.firstname, this.lastname, this.phone, this.email, this.passwordStrength, passwordEncryption, this.origin, this.roles, this.groups, this.devicePermissions, this.authenticationTokens, this.applications, this.inventoryAssignments, this.twoFactorAuthenticationEnabled, this.lastPasswords, this.newDeviceAssignments, this.owner, this.delegatedBy, this.newsletter, this.subusersCount, this.displayName, this.salt, this.oauthTokens, this.passwordChangeFailCount, this.passwordChangeLockedTill, this.requiredAuthType, this.authenticationSessions, this.authenticationTokensData, this.tokenSubject);
    }

    public User withOrigin(UserOrigin origin) {
        return this.origin == origin ? this : new User(this.tfaStrategy, this.tfaEnforced, this.tfaTotpEncryptedSecret, this.password, this.shouldResetPassword, this.lastPasswordChange, this.lastTFARequest, this.enabled, this.firstname, this.lastname, this.phone, this.email, this.passwordStrength, this.passwordEncryption, origin, this.roles, this.groups, this.devicePermissions, this.authenticationTokens, this.applications, this.inventoryAssignments, this.twoFactorAuthenticationEnabled, this.lastPasswords, this.newDeviceAssignments, this.owner, this.delegatedBy, this.newsletter, this.subusersCount, this.displayName, this.salt, this.oauthTokens, this.passwordChangeFailCount, this.passwordChangeLockedTill, this.requiredAuthType, this.authenticationSessions, this.authenticationTokensData, this.tokenSubject);
    }

    public User withRoles(List<Authority> roles) {
        return this.roles == roles ? this : new User(this.tfaStrategy, this.tfaEnforced, this.tfaTotpEncryptedSecret, this.password, this.shouldResetPassword, this.lastPasswordChange, this.lastTFARequest, this.enabled, this.firstname, this.lastname, this.phone, this.email, this.passwordStrength, this.passwordEncryption, this.origin, roles, this.groups, this.devicePermissions, this.authenticationTokens, this.applications, this.inventoryAssignments, this.twoFactorAuthenticationEnabled, this.lastPasswords, this.newDeviceAssignments, this.owner, this.delegatedBy, this.newsletter, this.subusersCount, this.displayName, this.salt, this.oauthTokens, this.passwordChangeFailCount, this.passwordChangeLockedTill, this.requiredAuthType, this.authenticationSessions, this.authenticationTokensData, this.tokenSubject);
    }

    public User withGroups(List<Group> groups) {
        return this.groups == groups ? this : new User(this.tfaStrategy, this.tfaEnforced, this.tfaTotpEncryptedSecret, this.password, this.shouldResetPassword, this.lastPasswordChange, this.lastTFARequest, this.enabled, this.firstname, this.lastname, this.phone, this.email, this.passwordStrength, this.passwordEncryption, this.origin, this.roles, groups, this.devicePermissions, this.authenticationTokens, this.applications, this.inventoryAssignments, this.twoFactorAuthenticationEnabled, this.lastPasswords, this.newDeviceAssignments, this.owner, this.delegatedBy, this.newsletter, this.subusersCount, this.displayName, this.salt, this.oauthTokens, this.passwordChangeFailCount, this.passwordChangeLockedTill, this.requiredAuthType, this.authenticationSessions, this.authenticationTokensData, this.tokenSubject);
    }

    public User withDevicePermissions(List<DevicePermission> devicePermissions) {
        return this.devicePermissions == devicePermissions ? this : new User(this.tfaStrategy, this.tfaEnforced, this.tfaTotpEncryptedSecret, this.password, this.shouldResetPassword, this.lastPasswordChange, this.lastTFARequest, this.enabled, this.firstname, this.lastname, this.phone, this.email, this.passwordStrength, this.passwordEncryption, this.origin, this.roles, this.groups, devicePermissions, this.authenticationTokens, this.applications, this.inventoryAssignments, this.twoFactorAuthenticationEnabled, this.lastPasswords, this.newDeviceAssignments, this.owner, this.delegatedBy, this.newsletter, this.subusersCount, this.displayName, this.salt, this.oauthTokens, this.passwordChangeFailCount, this.passwordChangeLockedTill, this.requiredAuthType, this.authenticationSessions, this.authenticationTokensData, this.tokenSubject);
    }

    public User withAuthenticationTokens(List<AuthenticationToken> authenticationTokens) {
        return this.authenticationTokens == authenticationTokens ? this : new User(this.tfaStrategy, this.tfaEnforced, this.tfaTotpEncryptedSecret, this.password, this.shouldResetPassword, this.lastPasswordChange, this.lastTFARequest, this.enabled, this.firstname, this.lastname, this.phone, this.email, this.passwordStrength, this.passwordEncryption, this.origin, this.roles, this.groups, this.devicePermissions, authenticationTokens, this.applications, this.inventoryAssignments, this.twoFactorAuthenticationEnabled, this.lastPasswords, this.newDeviceAssignments, this.owner, this.delegatedBy, this.newsletter, this.subusersCount, this.displayName, this.salt, this.oauthTokens, this.passwordChangeFailCount, this.passwordChangeLockedTill, this.requiredAuthType, this.authenticationSessions, this.authenticationTokensData, this.tokenSubject);
    }

    public User withApplications(List<Application> applications) {
        return this.applications == applications ? this : new User(this.tfaStrategy, this.tfaEnforced, this.tfaTotpEncryptedSecret, this.password, this.shouldResetPassword, this.lastPasswordChange, this.lastTFARequest, this.enabled, this.firstname, this.lastname, this.phone, this.email, this.passwordStrength, this.passwordEncryption, this.origin, this.roles, this.groups, this.devicePermissions, this.authenticationTokens, applications, this.inventoryAssignments, this.twoFactorAuthenticationEnabled, this.lastPasswords, this.newDeviceAssignments, this.owner, this.delegatedBy, this.newsletter, this.subusersCount, this.displayName, this.salt, this.oauthTokens, this.passwordChangeFailCount, this.passwordChangeLockedTill, this.requiredAuthType, this.authenticationSessions, this.authenticationTokensData, this.tokenSubject);
    }

    public User withInventoryAssignments(List<InventoryAssignment> inventoryAssignments) {
        return this.inventoryAssignments == inventoryAssignments ? this : new User(this.tfaStrategy, this.tfaEnforced, this.tfaTotpEncryptedSecret, this.password, this.shouldResetPassword, this.lastPasswordChange, this.lastTFARequest, this.enabled, this.firstname, this.lastname, this.phone, this.email, this.passwordStrength, this.passwordEncryption, this.origin, this.roles, this.groups, this.devicePermissions, this.authenticationTokens, this.applications, inventoryAssignments, this.twoFactorAuthenticationEnabled, this.lastPasswords, this.newDeviceAssignments, this.owner, this.delegatedBy, this.newsletter, this.subusersCount, this.displayName, this.salt, this.oauthTokens, this.passwordChangeFailCount, this.passwordChangeLockedTill, this.requiredAuthType, this.authenticationSessions, this.authenticationTokensData, this.tokenSubject);
    }

    public User withTwoFactorAuthenticationEnabled(Boolean twoFactorAuthenticationEnabled) {
        return this.twoFactorAuthenticationEnabled == twoFactorAuthenticationEnabled ? this : new User(this.tfaStrategy, this.tfaEnforced, this.tfaTotpEncryptedSecret, this.password, this.shouldResetPassword, this.lastPasswordChange, this.lastTFARequest, this.enabled, this.firstname, this.lastname, this.phone, this.email, this.passwordStrength, this.passwordEncryption, this.origin, this.roles, this.groups, this.devicePermissions, this.authenticationTokens, this.applications, this.inventoryAssignments, twoFactorAuthenticationEnabled, this.lastPasswords, this.newDeviceAssignments, this.owner, this.delegatedBy, this.newsletter, this.subusersCount, this.displayName, this.salt, this.oauthTokens, this.passwordChangeFailCount, this.passwordChangeLockedTill, this.requiredAuthType, this.authenticationSessions, this.authenticationTokensData, this.tokenSubject);
    }

    public User withLastPasswords(List<UserLastPassword> lastPasswords) {
        return this.lastPasswords == lastPasswords ? this : new User(this.tfaStrategy, this.tfaEnforced, this.tfaTotpEncryptedSecret, this.password, this.shouldResetPassword, this.lastPasswordChange, this.lastTFARequest, this.enabled, this.firstname, this.lastname, this.phone, this.email, this.passwordStrength, this.passwordEncryption, this.origin, this.roles, this.groups, this.devicePermissions, this.authenticationTokens, this.applications, this.inventoryAssignments, this.twoFactorAuthenticationEnabled, lastPasswords, this.newDeviceAssignments, this.owner, this.delegatedBy, this.newsletter, this.subusersCount, this.displayName, this.salt, this.oauthTokens, this.passwordChangeFailCount, this.passwordChangeLockedTill, this.requiredAuthType, this.authenticationSessions, this.authenticationTokensData, this.tokenSubject);
    }

    public User withNewDeviceAssignments(List<NewDeviceAssignment> newDeviceAssignments) {
        return this.newDeviceAssignments == newDeviceAssignments ? this : new User(this.tfaStrategy, this.tfaEnforced, this.tfaTotpEncryptedSecret, this.password, this.shouldResetPassword, this.lastPasswordChange, this.lastTFARequest, this.enabled, this.firstname, this.lastname, this.phone, this.email, this.passwordStrength, this.passwordEncryption, this.origin, this.roles, this.groups, this.devicePermissions, this.authenticationTokens, this.applications, this.inventoryAssignments, this.twoFactorAuthenticationEnabled, this.lastPasswords, newDeviceAssignments, this.owner, this.delegatedBy, this.newsletter, this.subusersCount, this.displayName, this.salt, this.oauthTokens, this.passwordChangeFailCount, this.passwordChangeLockedTill, this.requiredAuthType, this.authenticationSessions, this.authenticationTokensData, this.tokenSubject);
    }

    public User withOwner(String owner) {
        return this.owner == owner ? this : new User(this.tfaStrategy, this.tfaEnforced, this.tfaTotpEncryptedSecret, this.password, this.shouldResetPassword, this.lastPasswordChange, this.lastTFARequest, this.enabled, this.firstname, this.lastname, this.phone, this.email, this.passwordStrength, this.passwordEncryption, this.origin, this.roles, this.groups, this.devicePermissions, this.authenticationTokens, this.applications, this.inventoryAssignments, this.twoFactorAuthenticationEnabled, this.lastPasswords, this.newDeviceAssignments, owner, this.delegatedBy, this.newsletter, this.subusersCount, this.displayName, this.salt, this.oauthTokens, this.passwordChangeFailCount, this.passwordChangeLockedTill, this.requiredAuthType, this.authenticationSessions, this.authenticationTokensData, this.tokenSubject);
    }

    public User withDelegatedBy(String delegatedBy) {
        return this.delegatedBy == delegatedBy ? this : new User(this.tfaStrategy, this.tfaEnforced, this.tfaTotpEncryptedSecret, this.password, this.shouldResetPassword, this.lastPasswordChange, this.lastTFARequest, this.enabled, this.firstname, this.lastname, this.phone, this.email, this.passwordStrength, this.passwordEncryption, this.origin, this.roles, this.groups, this.devicePermissions, this.authenticationTokens, this.applications, this.inventoryAssignments, this.twoFactorAuthenticationEnabled, this.lastPasswords, this.newDeviceAssignments, this.owner, delegatedBy, this.newsletter, this.subusersCount, this.displayName, this.salt, this.oauthTokens, this.passwordChangeFailCount, this.passwordChangeLockedTill, this.requiredAuthType, this.authenticationSessions, this.authenticationTokensData, this.tokenSubject);
    }

    public User withNewsletter(Boolean newsletter) {
        return this.newsletter == newsletter ? this : new User(this.tfaStrategy, this.tfaEnforced, this.tfaTotpEncryptedSecret, this.password, this.shouldResetPassword, this.lastPasswordChange, this.lastTFARequest, this.enabled, this.firstname, this.lastname, this.phone, this.email, this.passwordStrength, this.passwordEncryption, this.origin, this.roles, this.groups, this.devicePermissions, this.authenticationTokens, this.applications, this.inventoryAssignments, this.twoFactorAuthenticationEnabled, this.lastPasswords, this.newDeviceAssignments, this.owner, this.delegatedBy, newsletter, this.subusersCount, this.displayName, this.salt, this.oauthTokens, this.passwordChangeFailCount, this.passwordChangeLockedTill, this.requiredAuthType, this.authenticationSessions, this.authenticationTokensData, this.tokenSubject);
    }

    public User withSubusersCount(Integer subusersCount) {
        return this.subusersCount == subusersCount ? this : new User(this.tfaStrategy, this.tfaEnforced, this.tfaTotpEncryptedSecret, this.password, this.shouldResetPassword, this.lastPasswordChange, this.lastTFARequest, this.enabled, this.firstname, this.lastname, this.phone, this.email, this.passwordStrength, this.passwordEncryption, this.origin, this.roles, this.groups, this.devicePermissions, this.authenticationTokens, this.applications, this.inventoryAssignments, this.twoFactorAuthenticationEnabled, this.lastPasswords, this.newDeviceAssignments, this.owner, this.delegatedBy, this.newsletter, subusersCount, this.displayName, this.salt, this.oauthTokens, this.passwordChangeFailCount, this.passwordChangeLockedTill, this.requiredAuthType, this.authenticationSessions, this.authenticationTokensData, this.tokenSubject);
    }

    public User withDisplayName(String displayName) {
        return this.displayName == displayName ? this : new User(this.tfaStrategy, this.tfaEnforced, this.tfaTotpEncryptedSecret, this.password, this.shouldResetPassword, this.lastPasswordChange, this.lastTFARequest, this.enabled, this.firstname, this.lastname, this.phone, this.email, this.passwordStrength, this.passwordEncryption, this.origin, this.roles, this.groups, this.devicePermissions, this.authenticationTokens, this.applications, this.inventoryAssignments, this.twoFactorAuthenticationEnabled, this.lastPasswords, this.newDeviceAssignments, this.owner, this.delegatedBy, this.newsletter, this.subusersCount, displayName, this.salt, this.oauthTokens, this.passwordChangeFailCount, this.passwordChangeLockedTill, this.requiredAuthType, this.authenticationSessions, this.authenticationTokensData, this.tokenSubject);
    }

    public User withSalt(String salt) {
        return this.salt == salt ? this : new User(this.tfaStrategy, this.tfaEnforced, this.tfaTotpEncryptedSecret, this.password, this.shouldResetPassword, this.lastPasswordChange, this.lastTFARequest, this.enabled, this.firstname, this.lastname, this.phone, this.email, this.passwordStrength, this.passwordEncryption, this.origin, this.roles, this.groups, this.devicePermissions, this.authenticationTokens, this.applications, this.inventoryAssignments, this.twoFactorAuthenticationEnabled, this.lastPasswords, this.newDeviceAssignments, this.owner, this.delegatedBy, this.newsletter, this.subusersCount, this.displayName, salt, this.oauthTokens, this.passwordChangeFailCount, this.passwordChangeLockedTill, this.requiredAuthType, this.authenticationSessions, this.authenticationTokensData, this.tokenSubject);
    }

    @Deprecated
    public User withOauthTokens(Set<TokenHolder> oauthTokens) {
        return this.oauthTokens == oauthTokens ? this : new User(this.tfaStrategy, this.tfaEnforced, this.tfaTotpEncryptedSecret, this.password, this.shouldResetPassword, this.lastPasswordChange, this.lastTFARequest, this.enabled, this.firstname, this.lastname, this.phone, this.email, this.passwordStrength, this.passwordEncryption, this.origin, this.roles, this.groups, this.devicePermissions, this.authenticationTokens, this.applications, this.inventoryAssignments, this.twoFactorAuthenticationEnabled, this.lastPasswords, this.newDeviceAssignments, this.owner, this.delegatedBy, this.newsletter, this.subusersCount, this.displayName, this.salt, oauthTokens, this.passwordChangeFailCount, this.passwordChangeLockedTill, this.requiredAuthType, this.authenticationSessions, this.authenticationTokensData, this.tokenSubject);
    }

    public User withPasswordChangeFailCount(Integer passwordChangeFailCount) {
        return this.passwordChangeFailCount == passwordChangeFailCount ? this : new User(this.tfaStrategy, this.tfaEnforced, this.tfaTotpEncryptedSecret, this.password, this.shouldResetPassword, this.lastPasswordChange, this.lastTFARequest, this.enabled, this.firstname, this.lastname, this.phone, this.email, this.passwordStrength, this.passwordEncryption, this.origin, this.roles, this.groups, this.devicePermissions, this.authenticationTokens, this.applications, this.inventoryAssignments, this.twoFactorAuthenticationEnabled, this.lastPasswords, this.newDeviceAssignments, this.owner, this.delegatedBy, this.newsletter, this.subusersCount, this.displayName, this.salt, this.oauthTokens, passwordChangeFailCount, this.passwordChangeLockedTill, this.requiredAuthType, this.authenticationSessions, this.authenticationTokensData, this.tokenSubject);
    }

    public User withPasswordChangeLockedTill(DateTime passwordChangeLockedTill) {
        return this.passwordChangeLockedTill == passwordChangeLockedTill ? this : new User(this.tfaStrategy, this.tfaEnforced, this.tfaTotpEncryptedSecret, this.password, this.shouldResetPassword, this.lastPasswordChange, this.lastTFARequest, this.enabled, this.firstname, this.lastname, this.phone, this.email, this.passwordStrength, this.passwordEncryption, this.origin, this.roles, this.groups, this.devicePermissions, this.authenticationTokens, this.applications, this.inventoryAssignments, this.twoFactorAuthenticationEnabled, this.lastPasswords, this.newDeviceAssignments, this.owner, this.delegatedBy, this.newsletter, this.subusersCount, this.displayName, this.salt, this.oauthTokens, this.passwordChangeFailCount, passwordChangeLockedTill, this.requiredAuthType, this.authenticationSessions, this.authenticationTokensData, this.tokenSubject);
    }

    public User withRequiredAuthType(String requiredAuthType) {
        return this.requiredAuthType == requiredAuthType ? this : new User(this.tfaStrategy, this.tfaEnforced, this.tfaTotpEncryptedSecret, this.password, this.shouldResetPassword, this.lastPasswordChange, this.lastTFARequest, this.enabled, this.firstname, this.lastname, this.phone, this.email, this.passwordStrength, this.passwordEncryption, this.origin, this.roles, this.groups, this.devicePermissions, this.authenticationTokens, this.applications, this.inventoryAssignments, this.twoFactorAuthenticationEnabled, this.lastPasswords, this.newDeviceAssignments, this.owner, this.delegatedBy, this.newsletter, this.subusersCount, this.displayName, this.salt, this.oauthTokens, this.passwordChangeFailCount, this.passwordChangeLockedTill, requiredAuthType, this.authenticationSessions, this.authenticationTokensData, this.tokenSubject);
    }

    public User withAuthenticationSessions(Map<String, AuthenticationSession> authenticationSessions) {
        return this.authenticationSessions == authenticationSessions ? this : new User(this.tfaStrategy, this.tfaEnforced, this.tfaTotpEncryptedSecret, this.password, this.shouldResetPassword, this.lastPasswordChange, this.lastTFARequest, this.enabled, this.firstname, this.lastname, this.phone, this.email, this.passwordStrength, this.passwordEncryption, this.origin, this.roles, this.groups, this.devicePermissions, this.authenticationTokens, this.applications, this.inventoryAssignments, this.twoFactorAuthenticationEnabled, this.lastPasswords, this.newDeviceAssignments, this.owner, this.delegatedBy, this.newsletter, this.subusersCount, this.displayName, this.salt, this.oauthTokens, this.passwordChangeFailCount, this.passwordChangeLockedTill, this.requiredAuthType, authenticationSessions, this.authenticationTokensData, this.tokenSubject);
    }

    public User withAuthenticationTokensData(Map<String, AuthenticationTokenData> authenticationTokensData) {
        return this.authenticationTokensData == authenticationTokensData ? this : new User(this.tfaStrategy, this.tfaEnforced, this.tfaTotpEncryptedSecret, this.password, this.shouldResetPassword, this.lastPasswordChange, this.lastTFARequest, this.enabled, this.firstname, this.lastname, this.phone, this.email, this.passwordStrength, this.passwordEncryption, this.origin, this.roles, this.groups, this.devicePermissions, this.authenticationTokens, this.applications, this.inventoryAssignments, this.twoFactorAuthenticationEnabled, this.lastPasswords, this.newDeviceAssignments, this.owner, this.delegatedBy, this.newsletter, this.subusersCount, this.displayName, this.salt, this.oauthTokens, this.passwordChangeFailCount, this.passwordChangeLockedTill, this.requiredAuthType, this.authenticationSessions, authenticationTokensData, this.tokenSubject);
    }

    public User withTokenSubject(String tokenSubject) {
        return this.tokenSubject == tokenSubject ? this : new User(this.tfaStrategy, this.tfaEnforced, this.tfaTotpEncryptedSecret, this.password, this.shouldResetPassword, this.lastPasswordChange, this.lastTFARequest, this.enabled, this.firstname, this.lastname, this.phone, this.email, this.passwordStrength, this.passwordEncryption, this.origin, this.roles, this.groups, this.devicePermissions, this.authenticationTokens, this.applications, this.inventoryAssignments, this.twoFactorAuthenticationEnabled, this.lastPasswords, this.newDeviceAssignments, this.owner, this.delegatedBy, this.newsletter, this.subusersCount, this.displayName, this.salt, this.oauthTokens, this.passwordChangeFailCount, this.passwordChangeLockedTill, this.requiredAuthType, this.authenticationSessions, this.authenticationTokensData, tokenSubject);
    }

    public User() {
    }

    public User(String tfaStrategy, Boolean tfaEnforced, String tfaTotpEncryptedSecret, String password, Boolean shouldResetPassword, DateTime lastPasswordChange, DateTime lastTFARequest, Boolean enabled, String firstname, String lastname, String phone, String email, PasswordStrength passwordStrength, PasswordEncryption passwordEncryption, UserOrigin origin, List<Authority> roles, List<Group> groups, List<DevicePermission> devicePermissions, List<AuthenticationToken> authenticationTokens, List<Application> applications, List<InventoryAssignment> inventoryAssignments, Boolean twoFactorAuthenticationEnabled, List<UserLastPassword> lastPasswords, List<NewDeviceAssignment> newDeviceAssignments, String owner, String delegatedBy, Boolean newsletter, Integer subusersCount, String displayName, String salt, Set<TokenHolder> oauthTokens, Integer passwordChangeFailCount, DateTime passwordChangeLockedTill, String requiredAuthType, Map<String, AuthenticationSession> authenticationSessions, Map<String, AuthenticationTokenData> authenticationTokensData, String tokenSubject) {
        this.tfaStrategy = tfaStrategy;
        this.tfaEnforced = tfaEnforced;
        this.tfaTotpEncryptedSecret = tfaTotpEncryptedSecret;
        this.password = password;
        this.shouldResetPassword = shouldResetPassword;
        this.lastPasswordChange = lastPasswordChange;
        this.lastTFARequest = lastTFARequest;
        this.enabled = enabled;
        this.firstname = firstname;
        this.lastname = lastname;
        this.phone = phone;
        this.email = email;
        this.passwordStrength = passwordStrength;
        this.passwordEncryption = passwordEncryption;
        this.origin = origin;
        this.roles = roles;
        this.groups = groups;
        this.devicePermissions = devicePermissions;
        this.authenticationTokens = authenticationTokens;
        this.applications = applications;
        this.inventoryAssignments = inventoryAssignments;
        this.twoFactorAuthenticationEnabled = twoFactorAuthenticationEnabled;
        this.lastPasswords = lastPasswords;
        this.newDeviceAssignments = newDeviceAssignments;
        this.owner = owner;
        this.delegatedBy = delegatedBy;
        this.newsletter = newsletter;
        this.subusersCount = subusersCount;
        this.displayName = displayName;
        this.salt = salt;
        this.oauthTokens = oauthTokens;
        this.passwordChangeFailCount = passwordChangeFailCount;
        this.passwordChangeLockedTill = passwordChangeLockedTill;
        this.requiredAuthType = requiredAuthType;
        this.authenticationSessions = authenticationSessions;
        this.authenticationTokensData = authenticationTokensData;
        this.tokenSubject = tokenSubject;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof User)) {
            return false;
        }
        User other = (User)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(Object other) {
        return other instanceof User;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    public String toString() {
        return "User(tfaStrategy=" + this.getTfaStrategy() + ", tfaEnforced=" + this.getTfaEnforced() + ", tfaTotpEncryptedSecret=" + this.getTfaTotpEncryptedSecret() + ", password=" + this.getPassword() + ", shouldResetPassword=" + this.getShouldResetPassword() + ", lastPasswordChange=" + this.getLastPasswordChange() + ", lastTFARequest=" + this.getLastTFARequest() + ", enabled=" + this.getEnabled() + ", firstname=" + this.getFirstname() + ", lastname=" + this.getLastname() + ", phone=" + this.getPhone() + ", email=" + this.getEmail() + ", passwordStrength=" + (Object)((Object)this.getPasswordStrength()) + ", passwordEncryption=" + (Object)((Object)this.getPasswordEncryption()) + ", origin=" + (Object)((Object)this.getOrigin()) + ", roles=" + this.getRoles() + ", groups=" + this.getGroups() + ", devicePermissions=" + this.getDevicePermissions() + ", authenticationTokens=" + this.getAuthenticationTokens() + ", applications=" + this.getApplications() + ", inventoryAssignments=" + this.getInventoryAssignments() + ", twoFactorAuthenticationEnabled=" + this.getTwoFactorAuthenticationEnabled() + ", lastPasswords=" + this.getLastPasswords() + ", newDeviceAssignments=" + this.getNewDeviceAssignments() + ", owner=" + this.getOwner() + ", delegatedBy=" + this.getDelegatedBy() + ", newsletter=" + this.getNewsletter() + ", subusersCount=" + this.getSubusersCount() + ", displayName=" + this.getDisplayName() + ", salt=" + this.getSalt() + ", oauthTokens=" + this.getOauthTokens() + ", passwordChangeFailCount=" + this.getPasswordChangeFailCount() + ", passwordChangeLockedTill=" + this.getPasswordChangeLockedTill() + ", requiredAuthType=" + this.getRequiredAuthType() + ", authenticationSessions=" + this.getAuthenticationSessions() + ", authenticationTokensData=" + this.getAuthenticationTokensData() + ", tokenSubject=" + this.getTokenSubject() + ")";
    }

    @JSONProperty(ignoreIfNull=true)
    public String getTfaStrategy() {
        return this.tfaStrategy;
    }

    @JSONProperty(ignoreIfNull=true)
    public Boolean getTfaEnforced() {
        return this.tfaEnforced;
    }

    @JSONProperty(ignoreIfNull=true)
    public String getTfaTotpEncryptedSecret() {
        return this.tfaTotpEncryptedSecret;
    }

    @JSONProperty(ignoreIfNull=true)
    public String getPassword() {
        return this.password;
    }

    @JSONProperty(ignoreIfNull=true)
    public Boolean getShouldResetPassword() {
        return this.shouldResetPassword;
    }

    @JSONConverter(type=DateTimeConverter.class)
    @JSONProperty(ignoreIfNull=true)
    public DateTime getLastPasswordChange() {
        return this.lastPasswordChange;
    }

    @JSONConverter(type=DateTimeConverter.class)
    @JSONProperty(ignoreIfNull=true)
    public DateTime getLastTFARequest() {
        return this.lastTFARequest;
    }

    @JSONProperty(ignoreIfNull=true)
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JSONProperty(ignoreIfNull=true)
    public String getFirstname() {
        return this.firstname;
    }

    @JSONProperty(ignoreIfNull=true)
    public String getLastname() {
        return this.lastname;
    }

    @JSONProperty(ignoreIfNull=true)
    public String getPhone() {
        return this.phone;
    }

    @Override
    @JSONProperty(ignoreIfNull=true)
    public String getEmail() {
        return this.email;
    }

    @JSONProperty(ignoreIfNull=true)
    public PasswordStrength getPasswordStrength() {
        return this.passwordStrength;
    }

    @JSONProperty(ignoreIfNull=true)
    public PasswordEncryption getPasswordEncryption() {
        return this.passwordEncryption;
    }

    @JSONProperty(ignoreIfNull=true)
    public UserOrigin getOrigin() {
        return this.origin;
    }

    @JSONProperty(ignoreIfNull=true)
    @JSONTypeHint(value=Authority.class)
    public List<Authority> getRoles() {
        return this.roles;
    }

    @JSONProperty(ignoreIfNull=true)
    @JSONTypeHint(value=Group.class)
    public List<Group> getGroups() {
        return this.groups;
    }

    @Override
    @JSONProperty(ignoreIfNull=true)
    @JSONTypeHint(value=DevicePermission.class)
    public List<DevicePermission> getDevicePermissions() {
        return this.devicePermissions;
    }

    @JSONProperty(ignoreIfNull=true)
    @JSONTypeHint(value=AuthenticationToken.class)
    public List<AuthenticationToken> getAuthenticationTokens() {
        return this.authenticationTokens;
    }

    @JSONProperty(ignoreIfNull=true)
    @JSONTypeHint(value=ApplicationReference.class)
    public List<Application> getApplications() {
        return this.applications;
    }

    @JSONProperty(ignoreIfNull=true)
    @JSONTypeHint(value=InventoryAssignment.class)
    public List<InventoryAssignment> getInventoryAssignments() {
        return this.inventoryAssignments;
    }

    @JSONProperty(ignoreIfNull=true)
    public Boolean getTwoFactorAuthenticationEnabled() {
        return this.twoFactorAuthenticationEnabled;
    }

    @JSONProperty(ignoreIfNull=true)
    @JSONTypeHint(value=UserLastPassword.class)
    public List<UserLastPassword> getLastPasswords() {
        return this.lastPasswords;
    }

    @JSONProperty(ignoreIfNull=true)
    @JSONTypeHint(value=NewDeviceAssignment.class)
    public List<NewDeviceAssignment> getNewDeviceAssignments() {
        return this.newDeviceAssignments;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getDelegatedBy() {
        return this.delegatedBy;
    }

    @Override
    @JSONProperty(ignoreIfNull=true)
    public Boolean getNewsletter() {
        return this.newsletter;
    }

    @JSONProperty(ignore=true)
    public Integer getSubusersCount() {
        return this.subusersCount;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    @JSONProperty(ignoreIfNull=true)
    public String getSalt() {
        return this.salt;
    }

    @Deprecated
    @JSONProperty(ignoreIfNull=true)
    @JSONTypeHint(value=TokenHolder.class)
    public Set<TokenHolder> getOauthTokens() {
        return this.oauthTokens;
    }

    @JSONProperty(ignoreIfNull=true)
    public Integer getPasswordChangeFailCount() {
        return this.passwordChangeFailCount;
    }

    @JSONConverter(type=DateTimeConverter.class)
    @JSONProperty(ignoreIfNull=true)
    public DateTime getPasswordChangeLockedTill() {
        return this.passwordChangeLockedTill;
    }

    @JSONProperty(ignoreIfNull=true)
    public String getRequiredAuthType() {
        return this.requiredAuthType;
    }

    @JSONProperty(ignoreIfNull=true)
    @JSONTypeHint(value=AuthenticationSession.class)
    public Map<String, AuthenticationSession> getAuthenticationSessions() {
        return this.authenticationSessions;
    }

    @JSONProperty(ignoreIfNull=true)
    @JSONTypeHint(value=AuthenticationTokenData.class)
    public Map<String, AuthenticationTokenData> getAuthenticationTokensData() {
        return this.authenticationTokensData;
    }

    @JSONProperty(ignoreIfNull=true)
    public String getTokenSubject() {
        return this.tokenSubject;
    }

    private static /* synthetic */ void lambda$findSessionsIdsWithAssociatedTokens$10(ListMultimap sessionsAndAssociatedTokens, AuthenticationTokenData token) {
        sessionsAndAssociatedTokens.put((Object)token.getSessionId(), (Object)token);
    }

    public static class UserBuilder {
        private ArrayList<Map.Entry<String, Object>> fragments;
        private String username;
        private String password;
        private Boolean shouldResetPassword;
        private DateTime lastPasswordChange;
        private DateTime lastTFARequest;
        private Boolean enabled;
        private String firstname;
        private String lastname;
        private String phone;
        private String email;
        private PasswordStrength passwordStrength;
        private PasswordEncryption passwordEncryption;
        private UserOrigin origin;
        private ArrayList<Authority> authorities;
        private ArrayList<DefaultAuthority> defaultAuthorities;
        private ArrayList<Group> groups;
        private ArrayList<DevicePermission> devicePermissions;
        private ArrayList<AuthenticationToken> authenticationTokens;
        private ArrayList<Application> applications;
        private ArrayList<InventoryAssignment> inventoryAssignments;
        private Boolean twoFactorAuthenticationEnabled;
        private ArrayList<UserLastPassword> lastPasswords;
        private String owner;
        private String delegatedBy;
        private Boolean newsletter;
        private String displayName;
        private String tfaTotpEncryptedSecret;
        private String tfaStrategy;
        private Boolean tfaEnforced;
        private Integer passwordChangeFailCount;
        private DateTime passwordChangeLockedTill;
        private String requiredAuthType;
        private String salt;
        private Set<TokenHolder> oauthTokens;
        private Map<String, AuthenticationSession> authenticationSessions;
        private Map<String, AuthenticationTokenData> authenticationTokensData;
        private String tokenSubject;

        UserBuilder() {
        }

        public UserBuilder requiredAuthType(RequiredAuthType requiredAuthType) {
            this.requiredAuthType = RequiredAuthType.toString(requiredAuthType);
            return this;
        }

        public UserBuilder oauthTokens(Set<TokenHolder> oauthTokens) {
            this.oauthTokens = oauthTokens;
            return this;
        }

        public UserBuilder tfaStrategy(String tfaStrategy) {
            this.tfaStrategy = tfaStrategy;
            return this;
        }

        public UserBuilder tfaTotpEncryptedSecret(String tfaTotpEncryptedSecret) {
            this.tfaTotpEncryptedSecret = tfaTotpEncryptedSecret;
            return this;
        }

        public UserBuilder fragment(String fragmentKey, Object fragmentValue) {
            if (this.fragments == null) {
                this.fragments = new ArrayList();
            }
            this.fragments.add(new AbstractMap.SimpleEntry<String, Object>(fragmentKey, fragmentValue));
            return this;
        }

        public UserBuilder fragments(Map<String, Object> fragments) {
            if (this.fragments == null) {
                this.fragments = new ArrayList();
            }
            if (fragments != null) {
                this.fragments.addAll(fragments.entrySet());
            }
            return this;
        }

        public UserBuilder clearFragments() {
            if (this.fragments != null) {
                this.fragments.clear();
            }
            return this;
        }

        public UserBuilder username(String username) {
            this.username = username;
            return this;
        }

        public UserBuilder password(String password) {
            this.password = password;
            return this;
        }

        public UserBuilder shouldResetPassword(Boolean shouldResetPassword) {
            this.shouldResetPassword = shouldResetPassword;
            return this;
        }

        public UserBuilder lastPasswordChange(DateTime lastPasswordChange) {
            this.lastPasswordChange = lastPasswordChange;
            return this;
        }

        public UserBuilder lastTFARequest(DateTime lastTFARequest) {
            this.lastTFARequest = lastTFARequest;
            return this;
        }

        public UserBuilder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public UserBuilder firstname(String firstname) {
            this.firstname = firstname;
            return this;
        }

        public UserBuilder lastname(String lastname) {
            this.lastname = lastname;
            return this;
        }

        public UserBuilder phone(String phone) {
            this.phone = phone;
            return this;
        }

        public UserBuilder email(String email) {
            this.email = email;
            return this;
        }

        public UserBuilder passwordStrength(PasswordStrength passwordStrength) {
            this.passwordStrength = passwordStrength;
            return this;
        }

        public UserBuilder passwordEncryption(PasswordEncryption passwordEncryption) {
            this.passwordEncryption = passwordEncryption;
            return this;
        }

        public UserBuilder origin(UserOrigin origin) {
            this.origin = origin;
            return this;
        }

        public UserBuilder authority(Authority authority) {
            if (this.authorities == null) {
                this.authorities = new ArrayList();
            }
            this.authorities.add(authority);
            return this;
        }

        public UserBuilder authorities(Collection<? extends Authority> authorities) {
            if (this.authorities == null) {
                this.authorities = new ArrayList();
            }
            this.authorities.addAll(authorities);
            return this;
        }

        public UserBuilder clearAuthorities() {
            if (this.authorities != null) {
                this.authorities.clear();
            }
            return this;
        }

        public UserBuilder defaultAuthority(DefaultAuthority defaultAuthority) {
            if (this.defaultAuthorities == null) {
                this.defaultAuthorities = new ArrayList();
            }
            this.defaultAuthorities.add(defaultAuthority);
            return this;
        }

        public UserBuilder defaultAuthorities(Collection<? extends DefaultAuthority> defaultAuthorities) {
            if (this.defaultAuthorities == null) {
                this.defaultAuthorities = new ArrayList();
            }
            this.defaultAuthorities.addAll(defaultAuthorities);
            return this;
        }

        public UserBuilder clearDefaultAuthorities() {
            if (this.defaultAuthorities != null) {
                this.defaultAuthorities.clear();
            }
            return this;
        }

        public UserBuilder group(Group group) {
            if (this.groups == null) {
                this.groups = new ArrayList();
            }
            this.groups.add(group);
            return this;
        }

        public UserBuilder groups(Collection<? extends Group> groups) {
            if (this.groups == null) {
                this.groups = new ArrayList();
            }
            this.groups.addAll(groups);
            return this;
        }

        public UserBuilder clearGroups() {
            if (this.groups != null) {
                this.groups.clear();
            }
            return this;
        }

        public UserBuilder devicePermission(DevicePermission devicePermission) {
            if (this.devicePermissions == null) {
                this.devicePermissions = new ArrayList();
            }
            this.devicePermissions.add(devicePermission);
            return this;
        }

        public UserBuilder devicePermissions(Collection<? extends DevicePermission> devicePermissions) {
            if (this.devicePermissions == null) {
                this.devicePermissions = new ArrayList();
            }
            this.devicePermissions.addAll(devicePermissions);
            return this;
        }

        public UserBuilder clearDevicePermissions() {
            if (this.devicePermissions != null) {
                this.devicePermissions.clear();
            }
            return this;
        }

        public UserBuilder authenticationToken(AuthenticationToken authenticationToken) {
            if (this.authenticationTokens == null) {
                this.authenticationTokens = new ArrayList();
            }
            this.authenticationTokens.add(authenticationToken);
            return this;
        }

        public UserBuilder authenticationTokens(Collection<? extends AuthenticationToken> authenticationTokens) {
            if (this.authenticationTokens == null) {
                this.authenticationTokens = new ArrayList();
            }
            this.authenticationTokens.addAll(authenticationTokens);
            return this;
        }

        public UserBuilder clearAuthenticationTokens() {
            if (this.authenticationTokens != null) {
                this.authenticationTokens.clear();
            }
            return this;
        }

        public UserBuilder application(Application application) {
            if (this.applications == null) {
                this.applications = new ArrayList();
            }
            this.applications.add(application);
            return this;
        }

        public UserBuilder applications(Collection<? extends Application> applications) {
            if (this.applications == null) {
                this.applications = new ArrayList();
            }
            this.applications.addAll(applications);
            return this;
        }

        public UserBuilder clearApplications() {
            if (this.applications != null) {
                this.applications.clear();
            }
            return this;
        }

        public UserBuilder inventoryAssignment(InventoryAssignment inventoryAssignment) {
            if (this.inventoryAssignments == null) {
                this.inventoryAssignments = new ArrayList();
            }
            this.inventoryAssignments.add(inventoryAssignment);
            return this;
        }

        public UserBuilder inventoryAssignments(Collection<? extends InventoryAssignment> inventoryAssignments) {
            if (this.inventoryAssignments == null) {
                this.inventoryAssignments = new ArrayList();
            }
            this.inventoryAssignments.addAll(inventoryAssignments);
            return this;
        }

        public UserBuilder clearInventoryAssignments() {
            if (this.inventoryAssignments != null) {
                this.inventoryAssignments.clear();
            }
            return this;
        }

        public UserBuilder twoFactorAuthenticationEnabled(Boolean twoFactorAuthenticationEnabled) {
            this.twoFactorAuthenticationEnabled = twoFactorAuthenticationEnabled;
            return this;
        }

        public UserBuilder tfaEnforced(Boolean tfaEnforced) {
            this.tfaEnforced = tfaEnforced;
            return this;
        }

        public UserBuilder lastPassword(UserLastPassword lastPassword) {
            if (this.lastPasswords == null) {
                this.lastPasswords = new ArrayList();
            }
            this.lastPasswords.add(lastPassword);
            return this;
        }

        public UserBuilder lastPasswords(Collection<? extends UserLastPassword> lastPasswords) {
            if (this.lastPasswords == null) {
                this.lastPasswords = new ArrayList();
            }
            this.lastPasswords.addAll(lastPasswords);
            return this;
        }

        public UserBuilder clearLastPasswords() {
            if (this.lastPasswords != null) {
                this.lastPasswords.clear();
            }
            return this;
        }

        public UserBuilder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public UserBuilder delegatedBy(String delegatedBy) {
            this.delegatedBy = delegatedBy;
            return this;
        }

        public UserBuilder newsletter(Boolean newsletter) {
            this.newsletter = newsletter;
            return this;
        }

        public UserBuilder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public UserBuilder salt(String salt) {
            this.salt = salt;
            return this;
        }

        public UserBuilder passwordChangeFailCount(Integer passwordChangeFailCount) {
            this.passwordChangeFailCount = passwordChangeFailCount;
            return this;
        }

        public UserBuilder passwordChangeLockedTill(DateTime passwordChangeFailCount) {
            this.passwordChangeLockedTill = passwordChangeFailCount;
            return this;
        }

        public UserBuilder authenticationSessions(Map<String, AuthenticationSession> authenticationSessions) {
            this.authenticationSessions = authenticationSessions;
            return this;
        }

        public UserBuilder authenticationTokensData(Map<String, AuthenticationTokenData> authenticationTokensData) {
            this.authenticationTokensData = authenticationTokensData;
            return this;
        }

        public UserBuilder tokenSubject(String tokenSubject) {
            this.tokenSubject = tokenSubject;
            return this;
        }

        public User build() {
            HashMap<String, Object> fragments;
            if (this.fragments == null) {
                fragments = new HashMap<String, Object>();
            } else {
                fragments = new LinkedHashMap();
                for (Map.Entry<String, Object> entry : this.fragments) {
                    fragments.put(entry.getKey(), entry.getValue());
                }
            }
            ArrayList authorities = this.authorities == null ? new ArrayList() : new ArrayList<Authority>(this.authorities);
            ArrayList defaultAuthorities = this.defaultAuthorities == null ? new ArrayList() : new ArrayList<DefaultAuthority>(this.defaultAuthorities);
            ArrayList groups = this.groups == null ? new ArrayList() : new ArrayList<Group>(this.groups);
            ArrayList devicePermissions = this.devicePermissions == null ? new ArrayList() : new ArrayList<DevicePermission>(this.devicePermissions);
            ArrayList authenticationTokens = this.authenticationTokens == null ? new ArrayList() : new ArrayList<AuthenticationToken>(this.authenticationTokens);
            ArrayList applications = this.applications == null ? new ArrayList() : new ArrayList<Application>(this.applications);
            ArrayList inventoryAssignments = this.inventoryAssignments == null ? new ArrayList() : new ArrayList<InventoryAssignment>(this.inventoryAssignments);
            ArrayList lastPasswords = this.lastPasswords == null ? new ArrayList() : new ArrayList<UserLastPassword>(this.lastPasswords);
            return new User(fragments, this.username, this.password, this.shouldResetPassword, this.lastPasswordChange, this.lastTFARequest, this.enabled, this.firstname, this.lastname, this.phone, this.email, this.passwordStrength, this.passwordEncryption, this.origin, authorities, defaultAuthorities, groups, devicePermissions, authenticationTokens, applications, inventoryAssignments, this.twoFactorAuthenticationEnabled, lastPasswords, this.owner, this.delegatedBy, this.newsletter, this.displayName, this.tfaTotpEncryptedSecret, this.tfaStrategy, this.tfaEnforced, this.passwordChangeFailCount, this.passwordChangeLockedTill, RequiredAuthType.fromString(this.requiredAuthType), this.salt, this.oauthTokens, this.authenticationSessions, this.authenticationTokensData, this.tokenSubject);
        }

        public String toString() {
            return "User.UserBuilder(fragments=" + this.fragments + ", username=" + this.username + ", password=" + this.password + ", shouldResetPassword=" + this.shouldResetPassword + ", lastPasswordChange=" + this.lastPasswordChange + ", lastTFARequest=" + this.lastTFARequest + ", enabled=" + this.enabled + ", firstname=" + this.firstname + ", lastname=" + this.lastname + ", phone=" + this.phone + ", email=" + this.email + ", passwordStrength=" + (Object)((Object)this.passwordStrength) + ", passwordEncryption=" + (Object)((Object)this.passwordEncryption) + ", origin=" + (Object)((Object)this.origin) + ", authorities=" + this.authorities + ", defaultAuthorities=" + this.defaultAuthorities + ", groups=" + this.groups + ", devicePermissions=" + this.devicePermissions + ", authenticationTokens=" + this.authenticationTokens + ", applications=" + this.applications + ", inventoryAssignments=" + this.inventoryAssignments + ", twoFactorAuthenticationEnabled=" + this.twoFactorAuthenticationEnabled + ", lastPasswords=" + this.lastPasswords + ", owner=" + this.owner + ", delegatedBy=" + this.delegatedBy + ", newsletter=" + this.newsletter + ", displayName=" + this.displayName + ", tfaTotpEncryptedSecret=" + this.tfaTotpEncryptedSecret + ", tfaStrategy=" + this.tfaStrategy + ", tfaEnforced=" + this.tfaEnforced + ", passwordChangeFailCount=" + this.passwordChangeFailCount + ", passwordChangeLockedTill=" + this.passwordChangeLockedTill + ", requiredAuthType=" + this.requiredAuthType + ", salt=" + this.salt + ", oauthTokens=" + this.oauthTokens + ", authenticationSessions=" + this.authenticationSessions + ", authenticationTokensData=" + this.authenticationTokensData + ", tokenSubject=" + this.tokenSubject + ")";
        }
    }
}

