/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.model.user;

import java.util.Arrays;

public enum RequiredAuthType {
    NONE(false),
    BASIC(true),
    CERTIFICATES(true),
    OAUTH_INTERNAL(false),
    SSO(false);

    private final boolean forDevices;

    private RequiredAuthType(boolean forDevices) {
        this.forDevices = forDevices;
    }

    public boolean isForDevices() {
        return this.forDevices;
    }

    public static RequiredAuthType fromString(String name) {
        return name == null ? NONE : RequiredAuthType.mapToRequiredAuthType(name);
    }

    public static String toString(RequiredAuthType requiredAuthType) {
        return requiredAuthType != null ? requiredAuthType.toString() : NONE.toString();
    }

    private static RequiredAuthType mapToRequiredAuthType(String name) {
        return Arrays.stream(RequiredAuthType.values()).map(Enum::name).filter(enumConstName -> enumConstName.equals(name.toUpperCase())).findFirst().map(RequiredAuthType::valueOf).orElse(NONE);
    }
}

