/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.model.user;

import com.cumulocity.model.IDTypeConverter;
import com.cumulocity.model.audit.AuditLogValue;
import com.cumulocity.model.idtype.GId;
import com.cumulocity.model.role.inventory.InventoryRole;
import com.cumulocity.model.user.User;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.svenson.JSONProperty;
import org.svenson.JSONTypeHint;
import org.svenson.converter.JSONConverter;

public class InventoryAssignment
implements AuditLogValue {
    private GId id;
    private User user;
    private List<InventoryRole> roles = new LinkedList<InventoryRole>();
    private String managedObject;

    public InventoryAssignment(GId id, User user, List<InventoryRole> roles, String managedObject) {
        this.id = id;
        this.user = user;
        this.roles = roles;
        this.managedObject = managedObject;
    }

    @JSONProperty(ignore=true)
    public Object getLogValue() {
        return "(managedObject=" + this.managedObject + ", roles=[" + FluentIterable.from(this.getRoles()).transform(InventoryRole.toName()).join(Joiner.on((String)",")) + "])";
    }

    public static Predicate<InventoryAssignment> byId(GId id) {
        return InventoryAssignment.byId(InventoryAssignment.inventoryAssignment().id(id).build());
    }

    public static Predicate<InventoryAssignment> byId(final InventoryAssignment inventoryAssignment) {
        return new Predicate<InventoryAssignment>(){

            public boolean apply(InventoryAssignment input) {
                return inventoryAssignment != null && input != null && Objects.equals(inventoryAssignment.getId(), input.getId());
            }
        };
    }

    public static Predicate<? super InventoryAssignment> byManagedObject(GId managedObjectId) {
        return InventoryAssignment.byManagedObject(InventoryAssignment.inventoryAssignment().managedObject(managedObjectId == null ? null : managedObjectId.getValue()).build());
    }

    public static Predicate<? super InventoryAssignment> byManagedObject(final InventoryAssignment inventoryAssignment) {
        return new Predicate<InventoryAssignment>(){

            public boolean apply(InventoryAssignment input) {
                return inventoryAssignment != null && input != null && Objects.equals(inventoryAssignment.getManagedObject(), input.getManagedObject());
            }
        };
    }

    public static InventoryAssignmentBuilder inventoryAssignment() {
        return new InventoryAssignmentBuilder();
    }

    public void setId(GId id) {
        this.id = id;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void setRoles(List<InventoryRole> roles) {
        this.roles = roles;
    }

    public void setManagedObject(String managedObject) {
        this.managedObject = managedObject;
    }

    public String toString() {
        return "InventoryAssignment(id=" + this.getId() + ", roles=" + this.getRoles() + ", managedObject=" + this.getManagedObject() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InventoryAssignment)) {
            return false;
        }
        InventoryAssignment other = (InventoryAssignment)o;
        if (!other.canEqual(this)) {
            return false;
        }
        GId this$id = this.getId();
        GId other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InventoryAssignment;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        GId $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    public InventoryAssignment withId(GId id) {
        return this.id == id ? this : new InventoryAssignment(id, this.user, this.roles, this.managedObject);
    }

    public InventoryAssignment withUser(User user) {
        return this.user == user ? this : new InventoryAssignment(this.id, user, this.roles, this.managedObject);
    }

    public InventoryAssignment withRoles(List<InventoryRole> roles) {
        return this.roles == roles ? this : new InventoryAssignment(this.id, this.user, roles, this.managedObject);
    }

    public InventoryAssignment withManagedObject(String managedObject) {
        return this.managedObject == managedObject ? this : new InventoryAssignment(this.id, this.user, this.roles, managedObject);
    }

    public InventoryAssignment() {
    }

    @JSONProperty(ignoreIfNull=true)
    @JSONConverter(type=IDTypeConverter.class)
    public GId getId() {
        return this.id;
    }

    @JSONProperty(ignore=true)
    public User getUser() {
        return this.user;
    }

    @JSONProperty(ignoreIfNull=true)
    @JSONTypeHint(value=InventoryRole.class)
    public List<InventoryRole> getRoles() {
        return this.roles;
    }

    @JSONProperty(ignoreIfNull=true)
    public String getManagedObject() {
        return this.managedObject;
    }

    public static class InventoryAssignmentBuilder {
        private GId id;
        private User user;
        private ArrayList<InventoryRole> roles;
        private String managedObject;

        InventoryAssignmentBuilder() {
        }

        public InventoryAssignmentBuilder id(GId id) {
            this.id = id;
            return this;
        }

        public InventoryAssignmentBuilder user(User user) {
            this.user = user;
            return this;
        }

        public InventoryAssignmentBuilder role(InventoryRole role) {
            if (this.roles == null) {
                this.roles = new ArrayList();
            }
            this.roles.add(role);
            return this;
        }

        public InventoryAssignmentBuilder roles(Collection<? extends InventoryRole> roles) {
            if (roles == null) {
                throw new NullPointerException("roles cannot be null");
            }
            if (this.roles == null) {
                this.roles = new ArrayList();
            }
            this.roles.addAll(roles);
            return this;
        }

        public InventoryAssignmentBuilder clearRoles() {
            if (this.roles != null) {
                this.roles.clear();
            }
            return this;
        }

        public InventoryAssignmentBuilder managedObject(String managedObject) {
            this.managedObject = managedObject;
            return this;
        }

        public InventoryAssignment build() {
            List<InventoryRole> roles;
            switch (this.roles == null ? 0 : this.roles.size()) {
                case 0: {
                    roles = Collections.emptyList();
                    break;
                }
                case 1: {
                    roles = Collections.singletonList(this.roles.get(0));
                    break;
                }
                default: {
                    roles = Collections.unmodifiableList(new ArrayList<InventoryRole>(this.roles));
                }
            }
            return new InventoryAssignment(this.id, this.user, roles, this.managedObject);
        }

        public String toString() {
            return "InventoryAssignment.InventoryAssignmentBuilder(id=" + this.id + ", user=" + this.user + ", roles=" + this.roles + ", managedObject=" + this.managedObject + ")";
        }
    }
}

