/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.model.user;

import com.cumulocity.model.user.DefaultApplication;
import com.cumulocity.model.user.DefaultAuthority;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum DefaultGroup {
    BUSINESS_GROUP{

        @Override
        public String getName() {
            return "business";
        }

        @Override
        public String getDescription() {
            return "Can access all devices and their data but has no management permission in the tenant";
        }

        @Override
        public List<DefaultAuthority> getAuthorities() {
            return Arrays.asList(DefaultAuthority.ALARM_ADMIN, DefaultAuthority.ALARM_READ, DefaultAuthority.AUDIT_ADMIN, DefaultAuthority.AUDIT_READ, DefaultAuthority.DEVICE_CONTROL_ADMIN, DefaultAuthority.DEVICE_CONTROL_READ, DefaultAuthority.EVENT_ADMIN, DefaultAuthority.EVENT_READ, DefaultAuthority.IDENTITY_ADMIN, DefaultAuthority.IDENTITY_READ, DefaultAuthority.INVENTORY_ADMIN, DefaultAuthority.INVENTORY_READ, DefaultAuthority.MEASUREMENT_ADMIN, DefaultAuthority.MEASUREMENT_READ, DefaultAuthority.USER_MANAGEMENT_OWN_ADMIN, DefaultAuthority.USER_MANAGEMENT_OWN_READ, DefaultAuthority.RETENTION_RULE_READ, DefaultAuthority.BULK_OPERATION_READ, DefaultAuthority.DATA_BROKER_READ);
        }

        @Override
        public List<DefaultApplication> getDefaultApplications() {
            return Arrays.asList(DefaultApplication.DEVICEMANAGEMENT, DefaultApplication.COCKPIT);
        }
    }
    ,
    ADMIN_GROUP{

        @Override
        public String getName() {
            return "admins";
        }

        @Override
        public String getDescription() {
            return "Enables administrative permissions. The first user created for the tenant receives this role";
        }

        @Override
        public List<DefaultAuthority> getAuthorities() {
            return Arrays.asList(DefaultAuthority.ALARM_ADMIN, DefaultAuthority.ALARM_READ, DefaultAuthority.AUDIT_ADMIN, DefaultAuthority.AUDIT_READ, DefaultAuthority.DEVICE_CONTROL_ADMIN, DefaultAuthority.DEVICE_CONTROL_READ, DefaultAuthority.EVENT_ADMIN, DefaultAuthority.EVENT_READ, DefaultAuthority.IDENTITY_ADMIN, DefaultAuthority.IDENTITY_READ, DefaultAuthority.INVENTORY_ADMIN, DefaultAuthority.INVENTORY_READ, DefaultAuthority.MEASUREMENT_ADMIN, DefaultAuthority.MEASUREMENT_READ, DefaultAuthority.TENANT_STATISTICS_READ, DefaultAuthority.APPLICATION_MANAGEMENT_ADMIN, DefaultAuthority.APPLICATION_MANAGEMENT_READ, DefaultAuthority.USER_MANAGEMENT_ADMIN, DefaultAuthority.USER_MANAGEMENT_CREATE, DefaultAuthority.USER_MANAGEMENT_READ, DefaultAuthority.USER_MANAGEMENT_OWN_ADMIN, DefaultAuthority.USER_MANAGEMENT_OWN_READ, DefaultAuthority.USER_MANAGEMENT_PASSWORD_RESET, DefaultAuthority.CEP_MANAGEMENT_ADMIN, DefaultAuthority.CEP_MANAGEMENT_READ, DefaultAuthority.OPTION_MANAGEMENT_ADMIN, DefaultAuthority.OPTION_MANAGEMENT_READ, DefaultAuthority.RETENTION_RULE_ADMIN, DefaultAuthority.RETENTION_RULE_READ, DefaultAuthority.BULK_OPERATION_ADMIN, DefaultAuthority.BULK_OPERATION_READ, DefaultAuthority.DATA_BROKER_ADMIN, DefaultAuthority.DATA_BROKER_READ, DefaultAuthority.ACCOUNT_ADMIN, DefaultAuthority.SCHEDULE_REPORT_ADMIN);
        }

        @Override
        public List<DefaultApplication> getDefaultApplications() {
            return Collections.emptyList();
        }
    }
    ,
    READER_GROUP{

        @Override
        public String getName() {
            return "readers";
        }

        @Override
        public String getDescription() {
            return "Can read all data (including users, in contrast to \"Global Reader\")";
        }

        @Override
        public List<DefaultAuthority> getAuthorities() {
            return Arrays.asList(DefaultAuthority.ALARM_READ, DefaultAuthority.AUDIT_READ, DefaultAuthority.DEVICE_CONTROL_READ, DefaultAuthority.EVENT_READ, DefaultAuthority.IDENTITY_READ, DefaultAuthority.INVENTORY_READ, DefaultAuthority.MEASUREMENT_READ, DefaultAuthority.TENANT_STATISTICS_READ, DefaultAuthority.APPLICATION_MANAGEMENT_READ, DefaultAuthority.USER_MANAGEMENT_READ, DefaultAuthority.USER_MANAGEMENT_OWN_READ, DefaultAuthority.CEP_MANAGEMENT_READ, DefaultAuthority.OPTION_MANAGEMENT_READ, DefaultAuthority.RETENTION_RULE_READ, DefaultAuthority.BULK_OPERATION_READ, DefaultAuthority.DATA_BROKER_READ);
        }

        @Override
        public List<DefaultApplication> getDefaultApplications() {
            return Collections.emptyList();
        }
    }
    ,
    DEVICE_GROUP{

        @Override
        public String getName() {
            return "devices";
        }

        @Override
        public String getDescription() {
            return "A role marker for device users. After registration, a device automatically has this role";
        }

        @Override
        public List<DefaultAuthority> getAuthorities() {
            return Arrays.asList(DefaultAuthority.DEVICE, DefaultAuthority.MEASUREMENT_READ, DefaultAuthority.EVENT_READ, DefaultAuthority.ALARM_READ, DefaultAuthority.AUDIT_READ, DefaultAuthority.IDENTITY_ADMIN, DefaultAuthority.IDENTITY_READ, DefaultAuthority.INVENTORY_READ, DefaultAuthority.INVENTORY_CREATE, DefaultAuthority.DEVICE_CONTROL_READ);
        }

        @Override
        public List<DefaultApplication> getDefaultApplications() {
            return Collections.emptyList();
        }
    }
    ,
    TENANT_MANAGER{

        @Override
        public String getName() {
            return "Tenant Manager";
        }

        @Override
        public String getDescription() {
            return "Can manage tenant wide configurations like applications, tenant options and retention rules";
        }

        @Override
        public List<DefaultAuthority> getAuthorities() {
            return Arrays.asList(DefaultAuthority.TENANT_STATISTICS_READ, DefaultAuthority.TENANT_MANAGEMENT_READ, DefaultAuthority.TENANT_MANAGEMENT_ADMIN, DefaultAuthority.OPTION_MANAGEMENT_READ, DefaultAuthority.OPTION_MANAGEMENT_ADMIN, DefaultAuthority.APPLICATION_MANAGEMENT_READ, DefaultAuthority.APPLICATION_MANAGEMENT_ADMIN, DefaultAuthority.RETENTION_RULE_READ, DefaultAuthority.RETENTION_RULE_ADMIN, DefaultAuthority.DATA_BROKER_READ, DefaultAuthority.DATA_BROKER_ADMIN);
        }

        @Override
        public List<DefaultApplication> getDefaultApplications() {
            return Arrays.asList(DefaultApplication.ADMINISTRATION);
        }
    }
    ,
    CEP_MANAGER{

        @Override
        public String getName() {
            return "CEP Manager";
        }

        @Override
        public String getDescription() {
            return "Has full access to all deployed CEP modules and SmartRules";
        }

        @Override
        public List<DefaultAuthority> getAuthorities() {
            return Arrays.asList(DefaultAuthority.CEP_MANAGEMENT_READ, DefaultAuthority.CEP_MANAGEMENT_ADMIN, DefaultAuthority.SCHEDULE_REPORT_ADMIN);
        }

        @Override
        public List<DefaultApplication> getDefaultApplications() {
            return Collections.emptyList();
        }
    }
    ,
    DEVICEMANAGEMENT_USER{

        @Override
        public String getName() {
            return "Devicemanagement User";
        }

        @Override
        public String getDescription() {
            return "Gives access to bulk operations and device management application. This does not include access to any device data.";
        }

        @Override
        public List<DefaultAuthority> getAuthorities() {
            return Arrays.asList(DefaultAuthority.BULK_OPERATION_READ, DefaultAuthority.SIMULATOR_ADMIN);
        }

        @Override
        public List<DefaultApplication> getDefaultApplications() {
            return Arrays.asList(DefaultApplication.DEVICEMANAGEMENT);
        }
    }
    ,
    COCKPIT_USER{

        @Override
        public String getName() {
            return "Cockpit User";
        }

        @Override
        public String getDescription() {
            return "User to work in Cockpit application. This does not include the access to any device data.";
        }

        @Override
        public List<DefaultAuthority> getAuthorities() {
            return Collections.emptyList();
        }

        @Override
        public List<DefaultApplication> getDefaultApplications() {
            return Arrays.asList(DefaultApplication.COCKPIT);
        }
    }
    ,
    GLOBAL_USER_MANAGER{

        @Override
        public String getName() {
            return "Global User Manager";
        }

        @Override
        public String getDescription() {
            return "Can access and modify the full user hierarchy";
        }

        @Override
        public List<DefaultAuthority> getAuthorities() {
            return Arrays.asList(DefaultAuthority.USER_MANAGEMENT_READ, DefaultAuthority.USER_MANAGEMENT_ADMIN);
        }

        @Override
        public List<DefaultApplication> getDefaultApplications() {
            return Arrays.asList(DefaultApplication.ADMINISTRATION);
        }
    }
    ,
    SHARED_USER_MANAGER{

        @Override
        public String getName() {
            return "Shared User Manager";
        }

        @Override
        public String getDescription() {
            return "Can create new user as his own sub-users and manage this";
        }

        @Override
        public List<DefaultAuthority> getAuthorities() {
            return Arrays.asList(DefaultAuthority.USER_MANAGEMENT_CREATE);
        }

        @Override
        public List<DefaultApplication> getDefaultApplications() {
            return Arrays.asList(DefaultApplication.ADMINISTRATION);
        }
    }
    ,
    GLOBAL_READER{

        @Override
        public String getName() {
            return "Global Reader";
        }

        @Override
        public String getDescription() {
            return "Can read all data from all devices";
        }

        @Override
        public List<DefaultAuthority> getAuthorities() {
            return Arrays.asList(DefaultAuthority.ALARM_READ, DefaultAuthority.MEASUREMENT_READ, DefaultAuthority.EVENT_READ, DefaultAuthority.INVENTORY_READ, DefaultAuthority.AUDIT_READ, DefaultAuthority.IDENTITY_READ, DefaultAuthority.DEVICE_CONTROL_READ);
        }

        @Override
        public List<DefaultApplication> getDefaultApplications() {
            return Collections.emptyList();
        }
    }
    ,
    GLOBAL_MANAGER{

        @Override
        public String getName() {
            return "Global Manager";
        }

        @Override
        public String getDescription() {
            return "Can read and write all data from all devices";
        }

        @Override
        public List<DefaultAuthority> getAuthorities() {
            return Arrays.asList(DefaultAuthority.ALARM_READ, DefaultAuthority.ALARM_ADMIN, DefaultAuthority.MEASUREMENT_READ, DefaultAuthority.MEASUREMENT_ADMIN, DefaultAuthority.EVENT_READ, DefaultAuthority.EVENT_ADMIN, DefaultAuthority.INVENTORY_READ, DefaultAuthority.INVENTORY_ADMIN, DefaultAuthority.AUDIT_READ, DefaultAuthority.AUDIT_ADMIN, DefaultAuthority.IDENTITY_READ, DefaultAuthority.IDENTITY_ADMIN, DefaultAuthority.DEVICE_CONTROL_READ, DefaultAuthority.DEVICE_CONTROL_ADMIN);
        }

        @Override
        public List<DefaultApplication> getDefaultApplications() {
            return Collections.emptyList();
        }
    };

    public static List<DefaultGroup> readOnlyGroups;

    public abstract String getName();

    public abstract String getDescription();

    public abstract List<DefaultAuthority> getAuthorities();

    public abstract List<DefaultApplication> getDefaultApplications();

    static {
        readOnlyGroups = Arrays.asList(DEVICE_GROUP, ADMIN_GROUP);
    }
}

