/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.model.user;

import com.cumulocity.model.user.Authority;
import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.springframework.security.core.GrantedAuthority;

public enum DefaultAuthority implements GrantedAuthority
{
    TENANT_MANAGEMENT_ADMIN(true, true),
    TENANT_MANAGEMENT_READ(true, true),
    TENANT_MANAGEMENT_CREATE(true, true),
    TENANT_MANAGEMENT_UPDATE(true, true),
    TENANT_STATISTICS_READ(true, true),
    OPTION_MANAGEMENT_ADMIN(true, true),
    OPTION_MANAGEMENT_READ(true, true),
    APPLICATION_MANAGEMENT_ADMIN(true, true),
    APPLICATION_MANAGEMENT_READ(true, true),
    APPLICATION_MANAGEMENT_SUBSCRIPTIONS_READ(true, false),
    USER_MANAGEMENT_ADMIN(true, true),
    USER_MANAGEMENT_READ(true, true),
    USER_MANAGEMENT_CREATE(true, true),
    USER_MANAGEMENT_OWN_ADMIN(true, true),
    USER_MANAGEMENT_OWN_READ(true, true),
    USER_MANAGEMENT_PASSWORD_RESET(true, true),
    IDENTITY_ADMIN(true, true),
    IDENTITY_READ(true, true),
    INVENTORY_ADMIN(true, true),
    INVENTORY_CREATE(true, true),
    INVENTORY_READ(true, true),
    MEASUREMENT_ADMIN(true, true),
    MEASUREMENT_READ(true, true),
    EVENT_ADMIN(true, true),
    EVENT_READ(true, true),
    ALARM_ADMIN(true, true),
    ALARM_READ(true, true),
    AUDIT_ADMIN(true, true),
    AUDIT_READ(true, true),
    DEVICE_CONTROL_ADMIN(true, true),
    DEVICE_CONTROL_READ(true, true),
    CEP_MANAGEMENT_ADMIN(true, true),
    CEP_MANAGEMENT_READ(true, true),
    SYSTEM(true, true),
    DEVICE(true, true),
    TENANT_ADMIN(true, true),
    DEVICE_BOOTSTRAP(true, true),
    RETENTION_RULE_READ(true, true),
    RETENTION_RULE_ADMIN(true, true),
    BULK_OPERATION_READ(true, true),
    BULK_OPERATION_ADMIN(true, true),
    SUPPORT_READ(true, false),
    SUPPORT_ADMIN(true, false),
    DATA_BROKER_ADMIN(true, true),
    DATA_BROKER_READ(true, true),
    SIMULATOR_ADMIN(true, true),
    ACCOUNT_ADMIN(true, true),
    SCHEDULE_REPORT_ADMIN(true, true),
    SMS_READ(true, true),
    SMS_ADMIN(true, true),
    NOTIFICATION_2_ADMIN(true, true),
    EMAIL_CREATE(true, true),
    GENERIC_MQTT_ADMIN(true, true);

    public static final String ROLE_PREFIX = "ROLE_";
    private final boolean managementScope;
    private final boolean tenantScope;

    private DefaultAuthority(boolean managementScope, boolean tenantScope) {
        this.managementScope = managementScope;
        this.tenantScope = tenantScope;
    }

    public String getAuthority() {
        return ROLE_PREFIX + this.name();
    }

    public Authority getRole() {
        return new Authority(this.getAuthority());
    }

    public static Authority getRole(String authority) {
        try {
            DefaultAuthority defaultAuthority = DefaultAuthority.valueOf(authority);
            return defaultAuthority.getRole();
        }
        catch (IllegalArgumentException err) {
            return null;
        }
    }

    public static DefaultAuthority getDefaultAuthority(String authority) {
        String defaultAuthorityName = authority.substring(ROLE_PREFIX.length());
        return DefaultAuthority.valueOf(defaultAuthorityName);
    }

    public boolean isTenantScope() {
        return this.tenantScope;
    }

    public boolean isManagementScope() {
        return this.managementScope;
    }

    public static List<Authority> valuesAsRoles() {
        ArrayList<Authority> result = new ArrayList<Authority>(DefaultAuthority.values().length);
        for (DefaultAuthority defRole : DefaultAuthority.values()) {
            result.add(defRole.getRole());
        }
        return Collections.unmodifiableList(result);
    }

    public static String getRoleNameById(Long roleId) {
        for (DefaultAuthority role : DefaultAuthority.values()) {
            if ((long)role.ordinal() != roleId) continue;
            return role.name();
        }
        return null;
    }

    public static List<String> getHiddenRoles() {
        return Arrays.asList(SYSTEM.getAuthority(), TENANT_ADMIN.getAuthority(), DEVICE_BOOTSTRAP.getAuthority(), DEVICE.getAuthority(), APPLICATION_MANAGEMENT_SUBSCRIPTIONS_READ.getAuthority(), ACCOUNT_ADMIN.getAuthority());
    }

    public static List<String> getSystemRoles() {
        return Arrays.asList(SYSTEM.getAuthority());
    }

    public static Function<DefaultAuthority, Authority> toAuthority() {
        return new Function<DefaultAuthority, Authority>(){

            @Nullable
            public Authority apply(@Nullable DefaultAuthority input) {
                return input == null ? null : input.getRole();
            }
        };
    }
}

