/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.model.user;

import com.cumulocity.model.acl.ACLExpression;
import com.cumulocity.model.acl.ACLExpressionUtils;
import com.cumulocity.model.acl.ACLPermission;
import com.cumulocity.model.acl.InventoryACLPermission;
import com.cumulocity.model.application.ApplicationUser;
import com.cumulocity.model.role.inventory.InventoryPermission;
import com.cumulocity.model.role.inventory.InventoryRole;
import com.cumulocity.model.user.Authorities;
import com.cumulocity.model.user.Authority;
import com.cumulocity.model.user.CumulocityAuthentication;
import com.cumulocity.model.user.DefaultAuthority;
import com.cumulocity.model.user.Group;
import com.cumulocity.model.user.InventoryAssignment;
import com.cumulocity.model.user.User;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;

public class CurrentUser
extends User
implements UserDetails {
    private static final long serialVersionUID = -8314064995303400684L;
    private final Set<GrantedAuthority> authorities = new HashSet<GrantedAuthority>();
    private List<ACLPermission> allDevicePermissions = new LinkedList<ACLPermission>();
    private String passwordResetToken;

    public static CumulocityAuthentication getAuthentication() {
        SecurityContext context = SecurityContextHolder.getContext();
        if (context == null) {
            return null;
        }
        Authentication authentication = context.getAuthentication();
        if (!(authentication instanceof CumulocityAuthentication)) {
            return null;
        }
        return (CumulocityAuthentication)authentication;
    }

    public static CurrentUser get() {
        CumulocityAuthentication authentication = CurrentUser.getAuthentication();
        if (authentication == null) {
            return null;
        }
        return authentication.getCurrentUser();
    }

    public static CurrentUser getOrThrowAccessDenied() {
        CurrentUser currentUser = CurrentUser.get();
        if (currentUser == null) {
            throw new AccessDeniedException("Access is denied");
        }
        return currentUser;
    }

    public static Optional<String> getTenantId() {
        CumulocityAuthentication auth = CurrentUser.getAuthentication();
        if (auth != null && auth.getTenant() != null) {
            return Optional.ofNullable(auth.getTenant().getTenantId());
        }
        return Optional.empty();
    }

    public CurrentUser(User user) {
        super(user);
        this.initAuthorities(user);
        this.initAllDevicePermissions(user);
    }

    public boolean isA(ApplicationUser.ApplicationUserType applicationUserType) {
        Optional currentUserType = ApplicationUser.ApplicationUserType.of((String)this.getUsername());
        return currentUserType.isPresent() && currentUserType.get() == applicationUserType;
    }

    public Collection<GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    public boolean isAccountNonExpired() {
        return this.isEnabled();
    }

    public boolean isAccountNonLocked() {
        return this.isEnabled();
    }

    public boolean isCredentialsNonExpired() {
        return this.isEnabled();
    }

    public boolean isEnabled() {
        return Boolean.TRUE.equals(this.getEnabled());
    }

    public String getPasswordResetToken() {
        return this.passwordResetToken;
    }

    public void setPasswordResetToken(String passwordResetToken) {
        this.passwordResetToken = passwordResetToken;
    }

    public List<ACLPermission> getAllACLPermissions() {
        return this.allDevicePermissions;
    }

    public Iterable<ACLExpression> findACLPermissionByManagedObject(String id) {
        return ACLExpressionUtils.getACLExpressionsForId(this.allDevicePermissions, id);
    }

    public boolean hasAuthority(Authority authority) {
        return this.hasAuthority((GrantedAuthority)authority);
    }

    public boolean hasAuthority(DefaultAuthority authority) {
        return this.hasAuthority((GrantedAuthority)authority);
    }

    public boolean hasAuthority(String authority1) {
        return this.hasAuthority((GrantedAuthority)new SimpleGrantedAuthority(authority1));
    }

    public boolean hasAuthority(GrantedAuthority grantedAuthority) {
        return Authorities.containsAuthority(this.getAuthorities(), grantedAuthority);
    }

    private void initAuthorities(User user) {
        this.addAuthorities(user.getRoles());
        if (user.getGroups() != null) {
            for (Group group : user.getGroups()) {
                this.addAuthorities(group.getRoles());
            }
        }
    }

    private void addAuthorities(Collection<Authority> roles) {
        if (roles == null) {
            return;
        }
        for (Authority role : roles) {
            this.authorities.add(role);
        }
    }

    private void initAllDevicePermissions(User user) {
        this.allDevicePermissions.addAll(user.getDevicePermissions());
        if (user.getGroups() != null) {
            for (Group group : user.getGroups()) {
                this.allDevicePermissions.addAll(group.getDevicePermissions());
            }
        }
        for (InventoryAssignment inventoryAssignment : user.getInventoryAssignments()) {
            for (InventoryRole inventoryRole : inventoryAssignment.getRoles()) {
                for (InventoryPermission inventoryPermission : inventoryRole.getPermissions()) {
                    this.allDevicePermissions.add(new InventoryACLPermission(inventoryAssignment.getManagedObject(), inventoryPermission));
                }
            }
        }
    }
}

