/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.model.acl;

import com.cumulocity.model.acl.ACLExpressionUtils;
import com.cumulocity.model.acl.ACLToken;
import com.cumulocity.model.user.DefaultAuthority;

public enum Api {
    ALARM(DefaultAuthority.ALARM_READ),
    AUDIT(null),
    EVENT(DefaultAuthority.EVENT_READ),
    MANAGED_OBJECT(DefaultAuthority.INVENTORY_READ),
    MEASUREMENT(DefaultAuthority.MEASUREMENT_READ),
    OPERATION(DefaultAuthority.DEVICE_CONTROL_READ),
    BULK_OPERATION(DefaultAuthority.BULK_OPERATION_READ),
    SUPPORT(null),
    BROKER_CONNECTOR(DefaultAuthority.DATA_BROKER_ADMIN),
    APPLICATION(DefaultAuthority.APPLICATION_MANAGEMENT_READ),
    ANY("*", null);

    private final ACLToken token;
    private final DefaultAuthority readAuthority;

    private Api(String expression, DefaultAuthority authority) {
        this.token = ACLToken.asACLToken(expression);
        this.readAuthority = authority;
    }

    private Api(DefaultAuthority authority) {
        this.token = ACLToken.asACLToken(this.name());
        this.readAuthority = authority;
    }

    public static Api fromExpression(String expr) {
        return ACLExpressionUtils.asApi(expr);
    }

    public String toExpression() {
        return this.token.getExpression();
    }

    public ACLToken getToken() {
        return this.token;
    }

    public DefaultAuthority getReadAuthority() {
        return this.readAuthority;
    }
}

