/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.model.acl;

import com.cumulocity.model.acl.ACLExpression;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;

public interface ACLPermission {
    public String getManagedObject();

    public ACLExpression getExpression();

    public static final class ACLPermissions {
        public static Predicate<ACLPermission> byManagedObjectAndExpression(ACLPermission permission) {
            return Predicates.and(ACLPermissions.byManagedObjectEquals(permission.getManagedObject()), ACLPermissions.byExpressionEquals(permission.getExpression()));
        }

        public static Predicate<ACLPermission> byManagedObjectEquals(final String managedObject) {
            return new Predicate<ACLPermission>(){

                public boolean apply(ACLPermission permission) {
                    return Objects.equal((Object)permission.getManagedObject(), (Object)managedObject);
                }
            };
        }

        public static Predicate<ACLPermission> byExpressionEquals(final ACLExpression expression) {
            return new Predicate<ACLPermission>(){

                public boolean apply(ACLPermission permission) {
                    return Objects.equal((Object)permission.getExpression(), (Object)expression);
                }
            };
        }

        public static Predicate<ACLPermission> byExpressionAccepts(final ACLExpression expression) {
            return new Predicate<ACLPermission>(){

                public boolean apply(ACLPermission permission) {
                    return permission.getExpression().accept(expression);
                }
            };
        }

        private ACLPermissions() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }
}

