/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.model.acl;

import com.cumulocity.model.acl.ACLExpression;
import com.cumulocity.model.acl.ACLPermission;
import com.cumulocity.model.acl.Api;
import com.cumulocity.model.acl.Permission;
import com.cumulocity.model.idtype.GId;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;

public class ACLExpressionUtils {
    private static final Map<String, Api> expressionToApi = new HashMap<String, Api>();
    private static final Map<String, Permission> expressionToPermission = new HashMap<String, Permission>();

    static ACLExpression asACLExpression(String expression) {
        String[] parts = expression.trim().split(":");
        if (parts.length != 3) {
            ACLExpressionUtils.throwSyntaxException();
        }
        return ACLExpressionUtils.asACLExpression(ACLExpressionUtils.trim(parts[0]), ACLExpressionUtils.trim(parts[1]), ACLExpressionUtils.trim(parts[2]));
    }

    static ACLExpression asACLExpression(String apiExpr, String fragment, String permissionExpr) {
        Api api = Api.fromExpression(apiExpr);
        Permission permission = Permission.fromExpression(permissionExpr);
        return new ACLExpression(api, fragment, permission);
    }

    public static Iterable<ACLExpression> getACLExpressionsForId(List<ACLPermission> ACLPermissions2, String id) {
        LinkedList<ACLExpression> expressions = new LinkedList<ACLExpression>();
        for (ACLPermission permission : ACLPermissions2) {
            if (!permission.getManagedObject().equals(id)) continue;
            expressions.add(permission.getExpression());
        }
        return expressions;
    }

    public static Set<ACLExpression> prepareRequiredExpressions(String api, Collection<?> fragments, String permission) {
        HashSet<ACLExpression> requiredEntries = new HashSet<ACLExpression>();
        for (Object fragmentElement : fragments) {
            if (fragmentElement == null || !(fragmentElement instanceof String)) continue;
            requiredEntries.add(ACLExpressionUtils.asACLExpression(api, String.valueOf(fragmentElement), permission));
        }
        if (requiredEntries.isEmpty()) {
            requiredEntries.add(ACLExpressionUtils.asACLExpression(api, "*", permission));
        }
        return requiredEntries;
    }

    public static boolean hasAllRequiredPermissions(final Iterable<ACLExpression> userACLExpressions, Set<ACLExpression> requiredExpressions) {
        return FluentIterable.from(requiredExpressions).allMatch((Predicate)new Predicate<ACLExpression>(){

            public boolean apply(ACLExpression requiredPermission) {
                return ACLExpressionUtils.containsMatchingPatern(userACLExpressions, requiredPermission);
            }
        });
    }

    public static boolean hasAccessToApi(List<ACLPermission> permissions, Api api) {
        for (Api userApi : ACLExpressionUtils.toApis(permissions)) {
            if (!userApi.getToken().accept(api.getToken())) continue;
            return true;
        }
        return false;
    }

    public static Set<GId> listAllowedIds(List<ACLPermission> permissions) {
        return ACLExpressionUtils.toAllowedIdList(permissions).toSet();
    }

    public static boolean accessToApiFiltersByFragment(List<ACLPermission> allACLPermissions, Api api) {
        return allACLPermissions.stream().anyMatch(acl -> acl.getExpression().getApi().getToken().accept(api.getToken()) && !"*".equals(acl.getExpression().getFragment()));
    }

    private static FluentIterable<GId> toAllowedIdList(List<ACLPermission> allACLPermissions) {
        return FluentIterable.from(allACLPermissions).transform((Function)new Function<ACLPermission, GId>(){

            public GId apply(@Nullable ACLPermission permission) {
                return GId.asGId((String)permission.getManagedObject());
            }
        });
    }

    private static Set<Api> toApis(List<ACLPermission> allACLPermissions) {
        return FluentIterable.from(allACLPermissions).transform((Function)new Function<ACLPermission, Api>(){

            public Api apply(ACLPermission permission) {
                return permission.getExpression().getApi();
            }
        }).toSet();
    }

    static Api asApi(String expression) {
        return ACLExpressionUtils.mapExpression(expressionToApi, expression);
    }

    static Permission asPermission(String expression) {
        return ACLExpressionUtils.mapExpression(expressionToPermission, expression);
    }

    private static boolean containsMatchingPatern(Iterable<ACLExpression> userACLExpressions, final ACLExpression requiredPermission) {
        return FluentIterable.from(userACLExpressions).anyMatch((Predicate)new Predicate<ACLExpression>(){

            public boolean apply(ACLExpression pattern) {
                return pattern.accept(requiredPermission);
            }
        });
    }

    private static <K> K mapExpression(Map<String, K> expressions, String expr) {
        K value = expressions.get(expr);
        if (value == null) {
            ACLExpressionUtils.throwSyntaxException();
        }
        return value;
    }

    private static String syntax(Set<String> expressions) {
        StringBuffer result = new StringBuffer("[");
        Iterator<String> iter = new TreeSet<String>(expressions).iterator();
        while (iter.hasNext()) {
            result.append("\"" + iter.next() + "\"");
            result.append(iter.hasNext() ? "|" : "]");
        }
        return result.toString();
    }

    private static String trim(String str) {
        return str == null ? null : str.trim();
    }

    private static void throwSyntaxException() {
        throw new IllegalArgumentException(String.format("Expected format \"%s:FRAGMENT_TYPE:%s\"", ACLExpressionUtils.syntax(expressionToApi.keySet()), ACLExpressionUtils.syntax(expressionToPermission.keySet())));
    }

    static {
        for (Api api : Api.values()) {
            expressionToApi.put(api.toExpression(), api);
        }
        for (Enum enum_ : Permission.values()) {
            expressionToPermission.put(((Permission)enum_).toExpression(), (Permission)enum_);
        }
    }
}

