/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.model.user;

import com.cumulocity.model.DateTimeConverter;
import com.cumulocity.model.util.DateTimeUtils;
import org.joda.time.DateTime;
import org.svenson.JSONProperty;
import org.svenson.converter.JSONConverter;

public class UserLastPassword {
    private static final long serialVersionUID = 67345740526235L;
    private Long id;
    private String password;
    private DateTime usedFrom;

    public UserLastPassword(Long id, String password, DateTime usedFrom) {
        this.id = id;
        this.password = password;
        this.usedFrom = usedFrom == null ? DateTimeUtils.nowUTC() : usedFrom;
    }

    public static UserLastPassword of(Long id, String password) {
        return UserLastPassword.lastPassword().id(id).password(password).build();
    }

    public void setUsedFrom(DateTime dateUpdated) {
        DateTimeUtils.checkChronologyUTC((DateTime)dateUpdated);
        this.usedFrom = dateUpdated;
    }

    public static UserLastPasswordBuilder lastPassword() {
        return new UserLastPasswordBuilder();
    }

    public UserLastPassword() {
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserLastPassword)) {
            return false;
        }
        UserLastPassword other = (UserLastPassword)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        return !(this$password == null ? other$password != null : !this$password.equals(other$password));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UserLastPassword;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        return result;
    }

    public String toString() {
        return "UserLastPassword(id=" + this.getId() + ", usedFrom=" + this.getUsedFrom() + ")";
    }

    @JSONProperty(ignoreIfNull=true)
    public Long getId() {
        return this.id;
    }

    @JSONProperty(ignoreIfNull=true)
    public String getPassword() {
        return this.password;
    }

    @JSONConverter(type=DateTimeConverter.class)
    @JSONProperty(ignoreIfNull=true)
    public DateTime getUsedFrom() {
        return this.usedFrom;
    }

    public static class UserLastPasswordBuilder {
        private Long id;
        private String password;
        private DateTime usedFrom;

        UserLastPasswordBuilder() {
        }

        public UserLastPasswordBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public UserLastPasswordBuilder password(String password) {
            this.password = password;
            return this;
        }

        public UserLastPasswordBuilder usedFrom(DateTime usedFrom) {
            this.usedFrom = usedFrom;
            return this;
        }

        public UserLastPassword build() {
            return new UserLastPassword(this.id, this.password, this.usedFrom);
        }

        public String toString() {
            return "UserLastPassword.UserLastPasswordBuilder(id=" + this.id + ", password=" + this.password + ", usedFrom=" + this.usedFrom + ")";
        }
    }
}

