/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.model.user;

import com.google.common.base.MoreObjects;

class SkipPart {
    private static final SkipPart NO_SKIP = new SkipPart();
    private boolean skipAuthenticationToken = false;
    private boolean skipInventoryAssignment = false;
    private boolean skipUser = false;
    private boolean skipUserLastPassword = false;

    SkipPart() {
    }

    static SkipPart getOrDefaultNoSkip(SkipPart skipPart) {
        return (SkipPart)MoreObjects.firstNonNull((Object)skipPart, (Object)NO_SKIP);
    }

    static SkipPart skipAuthenticationToken() {
        return SkipPart.skip().authenticationToken().get();
    }

    static SkipPart skipInventoryAssignment() {
        return SkipPart.skip().inventoryAssignment().get();
    }

    static SkipPart skipUser() {
        return SkipPart.skip().user().get();
    }

    static SkipPart skipUserLastPassword() {
        return SkipPart.skip().lastPassword().get();
    }

    boolean authenticationToken() {
        return this.skipAuthenticationToken;
    }

    boolean inventoryAssignment() {
        return this.skipInventoryAssignment;
    }

    boolean user() {
        return this.skipUser;
    }

    boolean lastPassword() {
        return this.skipUserLastPassword;
    }

    static SkipPartBuilder skip() {
        return new SkipPartBuilder();
    }

    static class SkipPartBuilder {
        private final SkipPart result = new SkipPart();

        SkipPartBuilder() {
        }

        SkipPartBuilder authenticationToken() {
            this.result.skipAuthenticationToken = false;
            return this;
        }

        SkipPartBuilder inventoryAssignment() {
            this.result.skipInventoryAssignment = false;
            return this;
        }

        SkipPartBuilder user() {
            this.result.skipUser = true;
            return this;
        }

        SkipPartBuilder lastPassword() {
            this.result.skipUserLastPassword = true;
            return this;
        }

        SkipPart get() {
            return this.result;
        }
    }
}

