/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.model.user;

import java.util.Arrays;

public enum CumulocityAuthenticationTokenType {
    UNKNOWN(false, false),
    SINGLE_SIGN_ON(false, false),
    OAUTH_INTERNAL_USER(true, true),
    OAUTH_INTERNAL_DEVICE(true, false);

    private final boolean sessionToken;
    private final boolean userAgentValidationRequired;

    private CumulocityAuthenticationTokenType(boolean sessionToken, boolean userAgentValidationRequired) {
        this.sessionToken = sessionToken;
        this.userAgentValidationRequired = userAgentValidationRequired;
    }

    public static CumulocityAuthenticationTokenType fromString(String name) {
        return Arrays.stream(CumulocityAuthenticationTokenType.values()).map(Enum::name).filter(enumName -> enumName.equalsIgnoreCase(name)).findFirst().map(CumulocityAuthenticationTokenType::valueOf).orElse(UNKNOWN);
    }

    public boolean isSessionToken() {
        return this.sessionToken;
    }

    public boolean isUserAgentValidationRequired() {
        return this.userAgentValidationRequired;
    }
}

