/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.model.user;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import java.util.Collection;
import javax.annotation.Nullable;
import org.springframework.security.core.GrantedAuthority;

public final class Authorities {
    public static <T extends GrantedAuthority> boolean containsAuthority(Collection<T> collection, final GrantedAuthority authority) {
        if (Authorities.nullAuthorityOrCollection(collection, authority)) {
            return false;
        }
        return !FluentIterable.from(collection).filter((Predicate)new Predicate<GrantedAuthority>(){

            public boolean apply(@Nullable GrantedAuthority input) {
                if (input == null) {
                    return false;
                }
                return authority.getAuthority().equals(input.getAuthority());
            }
        }).isEmpty();
    }

    private static <T extends GrantedAuthority> boolean nullAuthorityOrCollection(Collection<T> collection, GrantedAuthority authority) {
        return collection == null || authority == null || authority.getAuthority() == null;
    }

    private Authorities() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

