/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.model.role.inventory;

import com.cumulocity.model.Document;
import com.cumulocity.model.ID;
import com.cumulocity.model.audit.AuditLogSource;
import com.cumulocity.model.audit.annotation.IncludeFieldInAuditLog;
import com.cumulocity.model.idtype.GId;
import com.cumulocity.model.role.inventory.InventoryPermission;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.svenson.JSONProperty;
import org.svenson.JSONTypeHint;

@IncludeFieldInAuditLog(value={"name", "permissions"})
public class InventoryRole
extends Document<GId>
implements AuditLogSource {
    private String name;
    private String description;
    private List<InventoryPermission> permissions = new ArrayList<InventoryPermission>();

    public InventoryRole(GId id, String name, String description, List<InventoryPermission> permissions) {
        super((ID)id);
        this.name = name;
        this.description = description;
        this.permissions = permissions;
    }

    public static Predicate<InventoryRole> byId(final Iterable<GId> ids) {
        return new Predicate<InventoryRole>(){

            public boolean apply(InventoryRole inventoryRole) {
                return Iterables.contains((Iterable)ids, (Object)inventoryRole.getId());
            }
        };
    }

    public static Function<InventoryRole, String> toName() {
        return new Function<InventoryRole, String>(){

            public String apply(InventoryRole input) {
                return (String)MoreObjects.firstNonNull((Object)input.getName(), (Object)"");
            }
        };
    }

    public static Function<InventoryRole, GId> toId() {
        return new Function<InventoryRole, GId>(){

            public GId apply(InventoryRole role) {
                return (GId)role.getId();
            }
        };
    }

    @JSONProperty(ignore=true)
    public Object getLogSource() {
        return this.getId() == null ? null : ((GId)this.getId()).getValue();
    }

    public InventoryRoleBuilder toBuilder() {
        return InventoryRole.inventoryRole().id((GId)this.getId()).name(this.getName()).description(this.getDescription()).permissions(this.getPermissions() == null ? new ArrayList() : new ArrayList<InventoryPermission>(this.getPermissions()));
    }

    public String toString() {
        return "InventoryRole{id='" + this.getId() + '\'' + "name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", permissions=" + this.permissions + '}';
    }

    public static InventoryRoleBuilder inventoryRole() {
        return new InventoryRoleBuilder();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setPermissions(List<InventoryPermission> permissions) {
        this.permissions = permissions;
    }

    public InventoryRole(String name, String description, List<InventoryPermission> permissions) {
        this.name = name;
        this.description = description;
        this.permissions = permissions;
    }

    public InventoryRole() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InventoryRole)) {
            return false;
        }
        InventoryRole other = (InventoryRole)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        List<InventoryPermission> this$permissions = this.getPermissions();
        List<InventoryPermission> other$permissions = other.getPermissions();
        return !(this$permissions == null ? other$permissions != null : !((Object)this$permissions).equals(other$permissions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InventoryRole;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        List<InventoryPermission> $permissions = this.getPermissions();
        result = result * 59 + ($permissions == null ? 43 : ((Object)$permissions).hashCode());
        return result;
    }

    @JSONProperty(ignoreIfNull=true)
    public String getName() {
        return this.name;
    }

    @JSONProperty(ignoreIfNull=true)
    public String getDescription() {
        return this.description;
    }

    @JSONProperty(ignoreIfNull=true)
    @JSONTypeHint(value=InventoryPermission.class)
    public List<InventoryPermission> getPermissions() {
        return this.permissions;
    }

    public static class InventoryRoleBuilder {
        private GId id;
        private String name;
        private String description;
        private ArrayList<InventoryPermission> permissions;

        InventoryRoleBuilder() {
        }

        public InventoryRoleBuilder id(GId id) {
            this.id = id;
            return this;
        }

        public InventoryRoleBuilder name(String name) {
            this.name = name;
            return this;
        }

        public InventoryRoleBuilder description(String description) {
            this.description = description;
            return this;
        }

        public InventoryRoleBuilder permission(InventoryPermission permission) {
            if (this.permissions == null) {
                this.permissions = new ArrayList();
            }
            this.permissions.add(permission);
            return this;
        }

        public InventoryRoleBuilder permissions(Collection<? extends InventoryPermission> permissions) {
            if (permissions == null) {
                throw new NullPointerException("permissions cannot be null");
            }
            if (this.permissions == null) {
                this.permissions = new ArrayList();
            }
            this.permissions.addAll(permissions);
            return this;
        }

        public InventoryRoleBuilder clearPermissions() {
            if (this.permissions != null) {
                this.permissions.clear();
            }
            return this;
        }

        public InventoryRole build() {
            List<InventoryPermission> permissions;
            switch (this.permissions == null ? 0 : this.permissions.size()) {
                case 0: {
                    permissions = Collections.emptyList();
                    break;
                }
                case 1: {
                    permissions = Collections.singletonList(this.permissions.get(0));
                    break;
                }
                default: {
                    permissions = Collections.unmodifiableList(new ArrayList<InventoryPermission>(this.permissions));
                }
            }
            return new InventoryRole(this.id, this.name, this.description, permissions);
        }

        public String toString() {
            return "InventoryRole.InventoryRoleBuilder(id=" + this.id + ", name=" + this.name + ", description=" + this.description + ", permissions=" + this.permissions + ")";
        }
    }
}

