/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.model.role.inventory;

import com.cumulocity.model.Document;
import com.cumulocity.model.ID;
import com.cumulocity.model.acl.Api;
import com.cumulocity.model.acl.Permission;
import com.cumulocity.model.audit.AuditLogValue;
import com.cumulocity.model.idtype.GId;
import org.svenson.JSONProperty;

public class InventoryPermission
extends Document<GId>
implements AuditLogValue {
    private String type;
    private Api scope;
    private Permission permission;

    public InventoryPermission(GId id, String type, Api scope, Permission permission) {
        super((ID)id);
        this.type = type;
        this.scope = scope;
        this.permission = permission;
    }

    @JSONProperty(ignore=true)
    public Object getLogValue() {
        return String.format("%s:%s:%s", this.scope != null ? this.scope.toExpression() : "", this.type, this.permission != null ? this.permission.toExpression() : "");
    }

    public InventoryPermissionBuilder toBuilder() {
        return InventoryPermission.inventoryPermission().id((GId)this.getId()).type(this.getType()).scope(this.getScope()).permission(this.getPermission());
    }

    public String toString() {
        return "InventoryPermission{id='" + this.getId() + '\'' + "type='" + this.type + '\'' + ", scope=" + (Object)((Object)this.scope) + ", permission=" + (Object)((Object)this.permission) + '}';
    }

    public static InventoryPermissionBuilder inventoryPermission() {
        return new InventoryPermissionBuilder();
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setScope(Api scope) {
        this.scope = scope;
    }

    public void setPermission(Permission permission) {
        this.permission = permission;
    }

    public InventoryPermission(String type, Api scope, Permission permission) {
        this.type = type;
        this.scope = scope;
        this.permission = permission;
    }

    public InventoryPermission() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InventoryPermission)) {
            return false;
        }
        InventoryPermission other = (InventoryPermission)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Api this$scope = this.getScope();
        Api other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !((Object)((Object)this$scope)).equals((Object)other$scope)) {
            return false;
        }
        Permission this$permission = this.getPermission();
        Permission other$permission = other.getPermission();
        return !(this$permission == null ? other$permission != null : !((Object)((Object)this$permission)).equals((Object)other$permission));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InventoryPermission;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Api $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : ((Object)((Object)$scope)).hashCode());
        Permission $permission = this.getPermission();
        result = result * 59 + ($permission == null ? 43 : ((Object)((Object)$permission)).hashCode());
        return result;
    }

    @JSONProperty(ignoreIfNull=true)
    public String getType() {
        return this.type;
    }

    @JSONProperty(ignoreIfNull=true)
    public Api getScope() {
        return this.scope;
    }

    @JSONProperty(ignoreIfNull=true)
    public Permission getPermission() {
        return this.permission;
    }

    public static class InventoryPermissionBuilder {
        private GId id;
        private String type;
        private Api scope;
        private Permission permission;

        InventoryPermissionBuilder() {
        }

        public InventoryPermissionBuilder id(GId id) {
            this.id = id;
            return this;
        }

        public InventoryPermissionBuilder type(String type) {
            this.type = type;
            return this;
        }

        public InventoryPermissionBuilder scope(Api scope) {
            this.scope = scope;
            return this;
        }

        public InventoryPermissionBuilder permission(Permission permission) {
            this.permission = permission;
            return this;
        }

        public InventoryPermission build() {
            return new InventoryPermission(this.id, this.type, this.scope, this.permission);
        }

        public String toString() {
            return "InventoryPermission.InventoryPermissionBuilder(id=" + this.id + ", type=" + this.type + ", scope=" + (Object)((Object)this.scope) + ", permission=" + (Object)((Object)this.permission) + ")";
        }
    }
}

