/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.model.acl;

import com.cumulocity.model.acl.ACLToken;
import com.cumulocity.model.acl.Api;
import com.cumulocity.model.acl.Permission;

public class ACLExpression {
    private Api api;
    private String fragment;
    private Permission permission;

    public ACLExpression(Api api, String fragment, Permission permission) {
        this.api = api;
        this.fragment = fragment;
        this.permission = permission;
    }

    public boolean accept(ACLExpression candidate) {
        boolean result = true;
        result &= this.api.getToken().accept(candidate.getApi().getToken());
        result &= ACLToken.asACLToken(this.fragment).accept(ACLToken.asACLToken(candidate.getFragment()));
        return result &= this.permission.getToken().accept(candidate.getPermission().getToken());
    }

    public Api getApi() {
        return this.api;
    }

    public String getFragment() {
        return this.fragment;
    }

    public Permission getPermission() {
        return this.permission;
    }

    public void setApi(Api api) {
        this.api = api;
    }

    public void setFragment(String fragment) {
        this.fragment = fragment;
    }

    public void setPermission(Permission permission) {
        this.permission = permission;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ACLExpression)) {
            return false;
        }
        ACLExpression other = (ACLExpression)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Api this$api = this.getApi();
        Api other$api = other.getApi();
        if (this$api == null ? other$api != null : !((Object)((Object)this$api)).equals((Object)other$api)) {
            return false;
        }
        String this$fragment = this.getFragment();
        String other$fragment = other.getFragment();
        if (this$fragment == null ? other$fragment != null : !this$fragment.equals(other$fragment)) {
            return false;
        }
        Permission this$permission = this.getPermission();
        Permission other$permission = other.getPermission();
        return !(this$permission == null ? other$permission != null : !((Object)((Object)this$permission)).equals((Object)other$permission));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ACLExpression;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Api $api = this.getApi();
        result = result * 59 + ($api == null ? 43 : ((Object)((Object)$api)).hashCode());
        String $fragment = this.getFragment();
        result = result * 59 + ($fragment == null ? 43 : $fragment.hashCode());
        Permission $permission = this.getPermission();
        result = result * 59 + ($permission == null ? 43 : ((Object)((Object)$permission)).hashCode());
        return result;
    }

    public String toString() {
        return "ACLExpression(api=" + (Object)((Object)this.getApi()) + ", fragment=" + this.getFragment() + ", permission=" + (Object)((Object)this.getPermission()) + ")";
    }
}

