/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.model.user.command;

import com.cumulocity.model.user.PasswordEncryption;
import com.cumulocity.model.user.PasswordStrength;
import com.cumulocity.model.user.RequiredAuthType;
import com.cumulocity.model.user.command.UserCredentialsAware;
import lombok.NonNull;

public final class UpdatePasswordCommand
implements UserCredentialsAware {
    @NonNull
    private final String username;
    private final String password;
    private final Boolean shouldResetPassword;
    @Deprecated
    private final PasswordStrength passwordStrength;
    private final PasswordEncryption passwordEncryption;
    private final Boolean twoFactorAuthenticationEnabled;
    private final Integer passwordChangeFailCount;
    private final RequiredAuthType requiredAuthType;

    public static UpdatePasswordCommand shaAlreadyEncrypted(String userName, String password) {
        return UpdatePasswordCommand.builder().passwordEncryption(PasswordEncryption.SHA_ALREADY_ENCRYPTED).password(password).username(userName).build();
    }

    public static UpdatePasswordCommand plain(String userName, String password) {
        return UpdatePasswordCommand.builder().passwordEncryption(PasswordEncryption.PLAIN).password(password).username(userName).build();
    }

    public static UpdatePasswordCommand aes(String userName, String password) {
        return UpdatePasswordCommand.builder().passwordEncryption(PasswordEncryption.AES).password(password).username(userName).build();
    }

    public static UpdatePasswordCommand sha(String userName, String password) {
        return UpdatePasswordCommand.builder().passwordEncryption(PasswordEncryption.SHA).password(password).username(userName).build();
    }

    UpdatePasswordCommand(@NonNull String username, String password, Boolean shouldResetPassword, PasswordStrength passwordStrength, PasswordEncryption passwordEncryption, Boolean twoFactorAuthenticationEnabled, Integer passwordChangeFailCount, RequiredAuthType requiredAuthType) {
        if (username == null) {
            throw new NullPointerException("username is marked non-null but is null");
        }
        this.username = username;
        this.password = password;
        this.shouldResetPassword = shouldResetPassword;
        this.passwordStrength = passwordStrength;
        this.passwordEncryption = passwordEncryption;
        this.twoFactorAuthenticationEnabled = twoFactorAuthenticationEnabled;
        this.passwordChangeFailCount = passwordChangeFailCount;
        this.requiredAuthType = requiredAuthType;
    }

    public static UpdatePasswordCommandBuilder builder() {
        return new UpdatePasswordCommandBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdatePasswordCommand)) {
            return false;
        }
        UpdatePasswordCommand other = (UpdatePasswordCommand)o;
        Boolean this$shouldResetPassword = this.getShouldResetPassword();
        Boolean other$shouldResetPassword = other.getShouldResetPassword();
        if (this$shouldResetPassword == null ? other$shouldResetPassword != null : !((Object)this$shouldResetPassword).equals(other$shouldResetPassword)) {
            return false;
        }
        Boolean this$twoFactorAuthenticationEnabled = this.getTwoFactorAuthenticationEnabled();
        Boolean other$twoFactorAuthenticationEnabled = other.getTwoFactorAuthenticationEnabled();
        if (this$twoFactorAuthenticationEnabled == null ? other$twoFactorAuthenticationEnabled != null : !((Object)this$twoFactorAuthenticationEnabled).equals(other$twoFactorAuthenticationEnabled)) {
            return false;
        }
        Integer this$passwordChangeFailCount = this.getPasswordChangeFailCount();
        Integer other$passwordChangeFailCount = other.getPasswordChangeFailCount();
        if (this$passwordChangeFailCount == null ? other$passwordChangeFailCount != null : !((Object)this$passwordChangeFailCount).equals(other$passwordChangeFailCount)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        PasswordStrength this$passwordStrength = this.getPasswordStrength();
        PasswordStrength other$passwordStrength = other.getPasswordStrength();
        if (this$passwordStrength == null ? other$passwordStrength != null : !((Object)((Object)this$passwordStrength)).equals((Object)other$passwordStrength)) {
            return false;
        }
        PasswordEncryption this$passwordEncryption = this.getPasswordEncryption();
        PasswordEncryption other$passwordEncryption = other.getPasswordEncryption();
        if (this$passwordEncryption == null ? other$passwordEncryption != null : !((Object)((Object)this$passwordEncryption)).equals((Object)other$passwordEncryption)) {
            return false;
        }
        RequiredAuthType this$requiredAuthType = this.getRequiredAuthType();
        RequiredAuthType other$requiredAuthType = other.getRequiredAuthType();
        return !(this$requiredAuthType == null ? other$requiredAuthType != null : !((Object)((Object)this$requiredAuthType)).equals((Object)other$requiredAuthType));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $shouldResetPassword = this.getShouldResetPassword();
        result = result * 59 + ($shouldResetPassword == null ? 43 : ((Object)$shouldResetPassword).hashCode());
        Boolean $twoFactorAuthenticationEnabled = this.getTwoFactorAuthenticationEnabled();
        result = result * 59 + ($twoFactorAuthenticationEnabled == null ? 43 : ((Object)$twoFactorAuthenticationEnabled).hashCode());
        Integer $passwordChangeFailCount = this.getPasswordChangeFailCount();
        result = result * 59 + ($passwordChangeFailCount == null ? 43 : ((Object)$passwordChangeFailCount).hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        PasswordStrength $passwordStrength = this.getPasswordStrength();
        result = result * 59 + ($passwordStrength == null ? 43 : ((Object)((Object)$passwordStrength)).hashCode());
        PasswordEncryption $passwordEncryption = this.getPasswordEncryption();
        result = result * 59 + ($passwordEncryption == null ? 43 : ((Object)((Object)$passwordEncryption)).hashCode());
        RequiredAuthType $requiredAuthType = this.getRequiredAuthType();
        result = result * 59 + ($requiredAuthType == null ? 43 : ((Object)((Object)$requiredAuthType)).hashCode());
        return result;
    }

    public String toString() {
        return "UpdatePasswordCommand(username=" + this.getUsername() + ", shouldResetPassword=" + this.getShouldResetPassword() + ", passwordStrength=" + (Object)((Object)this.getPasswordStrength()) + ", passwordEncryption=" + (Object)((Object)this.getPasswordEncryption()) + ", twoFactorAuthenticationEnabled=" + this.getTwoFactorAuthenticationEnabled() + ", passwordChangeFailCount=" + this.getPasswordChangeFailCount() + ", requiredAuthType=" + (Object)((Object)this.getRequiredAuthType()) + ")";
    }

    @Override
    @NonNull
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public Boolean getShouldResetPassword() {
        return this.shouldResetPassword;
    }

    @Override
    @Deprecated
    public PasswordStrength getPasswordStrength() {
        return this.passwordStrength;
    }

    public PasswordEncryption getPasswordEncryption() {
        return this.passwordEncryption;
    }

    @Override
    public Boolean getTwoFactorAuthenticationEnabled() {
        return this.twoFactorAuthenticationEnabled;
    }

    @Override
    public Integer getPasswordChangeFailCount() {
        return this.passwordChangeFailCount;
    }

    public RequiredAuthType getRequiredAuthType() {
        return this.requiredAuthType;
    }

    public static class UpdatePasswordCommandBuilder {
        private String username;
        private String password;
        private Boolean shouldResetPassword;
        private PasswordStrength passwordStrength;
        private PasswordEncryption passwordEncryption;
        private Boolean twoFactorAuthenticationEnabled;
        private Integer passwordChangeFailCount;
        private RequiredAuthType requiredAuthType;

        UpdatePasswordCommandBuilder() {
        }

        public UpdatePasswordCommandBuilder username(@NonNull String username) {
            if (username == null) {
                throw new NullPointerException("username is marked non-null but is null");
            }
            this.username = username;
            return this;
        }

        public UpdatePasswordCommandBuilder password(String password) {
            this.password = password;
            return this;
        }

        public UpdatePasswordCommandBuilder shouldResetPassword(Boolean shouldResetPassword) {
            this.shouldResetPassword = shouldResetPassword;
            return this;
        }

        @Deprecated
        public UpdatePasswordCommandBuilder passwordStrength(PasswordStrength passwordStrength) {
            this.passwordStrength = passwordStrength;
            return this;
        }

        public UpdatePasswordCommandBuilder passwordEncryption(PasswordEncryption passwordEncryption) {
            this.passwordEncryption = passwordEncryption;
            return this;
        }

        public UpdatePasswordCommandBuilder twoFactorAuthenticationEnabled(Boolean twoFactorAuthenticationEnabled) {
            this.twoFactorAuthenticationEnabled = twoFactorAuthenticationEnabled;
            return this;
        }

        public UpdatePasswordCommandBuilder passwordChangeFailCount(Integer passwordChangeFailCount) {
            this.passwordChangeFailCount = passwordChangeFailCount;
            return this;
        }

        public UpdatePasswordCommandBuilder requiredAuthType(RequiredAuthType requiredAuthType) {
            this.requiredAuthType = requiredAuthType;
            return this;
        }

        public UpdatePasswordCommand build() {
            return new UpdatePasswordCommand(this.username, this.password, this.shouldResetPassword, this.passwordStrength, this.passwordEncryption, this.twoFactorAuthenticationEnabled, this.passwordChangeFailCount, this.requiredAuthType);
        }

        public String toString() {
            return "UpdatePasswordCommand.UpdatePasswordCommandBuilder(username=" + this.username + ", password=" + this.password + ", shouldResetPassword=" + this.shouldResetPassword + ", passwordStrength=" + (Object)((Object)this.passwordStrength) + ", passwordEncryption=" + (Object)((Object)this.passwordEncryption) + ", twoFactorAuthenticationEnabled=" + this.twoFactorAuthenticationEnabled + ", passwordChangeFailCount=" + this.passwordChangeFailCount + ", requiredAuthType=" + (Object)((Object)this.requiredAuthType) + ")";
        }
    }
}

