/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.model.user;

import com.cumulocity.model.Document;
import com.cumulocity.model.ID;
import com.cumulocity.model.Link;
import com.cumulocity.model.acl.ACLPermission;
import com.cumulocity.model.acl.DevicePermission;
import com.cumulocity.model.application.Application;
import com.cumulocity.model.application.ApplicationReference;
import com.cumulocity.model.audit.AuditLogSource;
import com.cumulocity.model.audit.AuditLogValue;
import com.cumulocity.model.audit.annotation.IncludeFieldInAuditLog;
import com.cumulocity.model.idtype.GId;
import com.cumulocity.model.user.Authority;
import com.cumulocity.model.user.core.HasDevicePermissions;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.svenson.JSONProperty;
import org.svenson.JSONTypeHint;

@IncludeFieldInAuditLog(value={"roles", "devicePermissions", "applications"})
public class Group
extends Document<GId>
implements HasDevicePermissions<GId>,
AuditLogValue,
AuditLogSource {
    private static final long serialVersionUID = 5514955346599369205L;
    private String name;
    private String description;
    private List<Authority> roles = new LinkedList<Authority>();
    private List<DevicePermission> devicePermissions = new LinkedList<DevicePermission>();
    @Link
    private List<Application> applications = new ArrayList<Application>();

    public Group(GId id, String name) {
        this(id, name, null);
    }

    public Group(GId id, String name, String description) {
        super((ID)id);
        this.name = name;
        this.description = description;
    }

    public boolean hasRole(Authority authority) {
        return this.getRoles().contains((Object)authority);
    }

    public void setRoles(List<Authority> roles) {
        this.roles = roles == null ? new LinkedList() : roles;
    }

    public boolean addRole(Authority role) {
        return this.getRoles().add(role);
    }

    public boolean removeRole(Authority role) {
        return this.getRoles().remove((Object)role);
    }

    public void setDevicePermissions(List<DevicePermission> devicePermissions) {
        this.devicePermissions = devicePermissions == null ? new LinkedList() : devicePermissions;
    }

    public boolean hasDevicePermission(DevicePermission devicePermission) {
        return this.getDevicePermissions().contains(devicePermission);
    }

    @Override
    public boolean addDevicePermission(DevicePermission devicePermission) {
        return !this.hasDevicePermission(devicePermission) && this.getDevicePermissions().add(devicePermission);
    }

    public void addApplication(Application application) {
        this.applications.add(application);
    }

    @JSONProperty(ignore=true)
    public Object getLogSource() {
        return this.getName();
    }

    @JSONProperty(ignore=true)
    public Object getLogValue() {
        return this.getName();
    }

    @Override
    public boolean removeDevicePermission(DevicePermission permission) {
        Optional devicePermission = FluentIterable.from(this.getDevicePermissions()).firstMatch(ACLPermission.ACLPermissions.byManagedObjectAndExpression(permission));
        if (devicePermission.isPresent()) {
            return this.getDevicePermissions().remove(devicePermission.get());
        }
        return false;
    }

    public static Function<Group, GId> toId() {
        return new Function<Group, GId>(){

            public GId apply(Group group) {
                return (GId)group.getId();
            }
        };
    }

    public static GroupBuilder group() {
        return new GroupBuilder();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setApplications(List<Application> applications) {
        this.applications = applications;
    }

    public String toString() {
        return "Group(name=" + this.getName() + ", description=" + this.getDescription() + ")";
    }

    public Group() {
    }

    public Group(String name, String description, List<Authority> roles, List<DevicePermission> devicePermissions, List<Application> applications) {
        this.name = name;
        this.description = description;
        this.roles = roles;
        this.devicePermissions = devicePermissions;
        this.applications = applications;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    @JSONProperty(ignoreIfNull=true)
    @JSONTypeHint(value=Authority.class)
    public List<Authority> getRoles() {
        return this.roles;
    }

    @Override
    @JSONProperty(ignoreIfNull=true)
    @JSONTypeHint(value=DevicePermission.class)
    public List<DevicePermission> getDevicePermissions() {
        return this.devicePermissions;
    }

    @JSONProperty(ignoreIfNull=true)
    @JSONTypeHint(value=ApplicationReference.class)
    public List<Application> getApplications() {
        return this.applications;
    }

    public static class GroupBuilder {
        private GId id;
        private String name;
        private String description;
        private List<Authority> roles = new LinkedList<Authority>();
        private List<DevicePermission> devicePermissions = new LinkedList<DevicePermission>();
        private List<Application> applications = new LinkedList<Application>();

        public GroupBuilder id(GId id) {
            this.id = id;
            return this;
        }

        public GroupBuilder id(Object id) {
            return this.id(GId.asGId((Object)id));
        }

        public GroupBuilder name(String name) {
            this.name = name;
            return this;
        }

        public GroupBuilder description(String description) {
            this.description = description;
            return this;
        }

        public GroupBuilder roles(List<Authority> roles) {
            this.roles.addAll(roles);
            return this;
        }

        public GroupBuilder roles(Authority ... roles) {
            return this.roles(Arrays.asList(roles));
        }

        public GroupBuilder devicePermissions(List<DevicePermission> devicePermissions) {
            this.devicePermissions = devicePermissions;
            return this;
        }

        public GroupBuilder devicePermissions(DevicePermission ... devicePermissions) {
            return this.devicePermissions(Arrays.asList(devicePermissions));
        }

        public GroupBuilder applications(List<Application> applications) {
            this.applications = applications;
            return this;
        }

        public GroupBuilder applications(Application ... applications) {
            return this.applications(Arrays.asList(applications));
        }

        public Group build() {
            Group group = new Group(this.name, this.description, this.roles, this.devicePermissions, this.applications);
            group.setId((ID)this.id);
            return group;
        }
    }
}

