/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.model.user;

import com.cumulocity.model.DateTimeConverter;
import com.cumulocity.model.Document;
import com.cumulocity.model.ID;
import com.cumulocity.model.idtype.GId;
import com.cumulocity.model.persistence.PrePersist;
import com.cumulocity.model.user.AuthenticationTokenType;
import com.cumulocity.model.user.User;
import com.cumulocity.model.util.DateTimeUtils;
import org.joda.time.DateTime;
import org.svenson.JSONProperty;
import org.svenson.converter.JSONConverter;

public class AuthenticationToken
extends Document<GId> {
    public static final String TFA_TOKEN = "TFAToken";
    private String token;
    private DateTime dateCreated;
    private DateTime validTill;
    private AuthenticationTokenType type;
    private User user;
    private Integer sendCounter;

    private AuthenticationToken(Long id, String token, DateTime dateCreated, DateTime validTill, AuthenticationTokenType type, User user, Integer sendCounter) {
        super((ID)(id == null ? null : GId.asGId((Long)id)));
        this.token = token;
        DateTimeUtils.checkChronologyUTC((DateTime)dateCreated);
        DateTimeUtils.checkChronologyUTC((DateTime)validTill);
        this.dateCreated = dateCreated;
        this.validTill = validTill;
        this.type = type;
        this.user = user;
        this.sendCounter = sendCounter;
    }

    public static AuthenticationToken of(Long id, User user, String token, AuthenticationTokenType type) {
        return new AuthenticationToken(id, token, DateTimeUtils.nowUTC(), DateTimeUtils.nowUTC().plusMinutes(1), type, user, 1);
    }

    public void setDateCreated(DateTime dateCreated) {
        DateTimeUtils.checkChronologyUTC((DateTime)dateCreated);
        this.dateCreated = dateCreated;
    }

    @PrePersist
    public void init() {
        this.dateCreated = DateTimeUtils.nowUTC();
        this.sendCounter = 1;
    }

    @JSONProperty(ignore=true)
    public boolean isValid() {
        return this.validTill != null && this.validTill.isAfterNow();
    }

    public boolean matches(String token) {
        if (token == null) {
            return false;
        }
        return token.equals(this.token);
    }

    public static AuthenticationTokenBuilder authenticationToken() {
        return new AuthenticationTokenBuilder();
    }

    public AuthenticationToken() {
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setValidTill(DateTime validTill) {
        this.validTill = validTill;
    }

    public void setType(AuthenticationTokenType type) {
        this.type = type;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void setSendCounter(Integer sendCounter) {
        this.sendCounter = sendCounter;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthenticationToken)) {
            return false;
        }
        AuthenticationToken other = (AuthenticationToken)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        return !(this$token == null ? other$token != null : !this$token.equals(other$token));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AuthenticationToken;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        return result;
    }

    public String toString() {
        return "AuthenticationToken(token=" + this.getToken() + ", dateCreated=" + this.getDateCreated() + ", validTill=" + this.getValidTill() + ", type=" + (Object)((Object)this.getType()) + ", sendCounter=" + this.getSendCounter() + ")";
    }

    @JSONProperty(ignoreIfNull=true)
    public String getToken() {
        return this.token;
    }

    @JSONProperty(ignoreIfNull=true)
    @JSONConverter(type=DateTimeConverter.class)
    public DateTime getDateCreated() {
        return this.dateCreated;
    }

    @JSONProperty(ignoreIfNull=true)
    @JSONConverter(type=DateTimeConverter.class)
    public DateTime getValidTill() {
        return this.validTill;
    }

    @JSONProperty(ignoreIfNull=true)
    public AuthenticationTokenType getType() {
        return this.type;
    }

    @JSONProperty(ignore=true)
    public User getUser() {
        return this.user;
    }

    @JSONProperty(ignoreIfNull=true)
    public Integer getSendCounter() {
        return this.sendCounter;
    }

    public static class AuthenticationTokenBuilder {
        private Long id;
        private String token;
        private DateTime dateCreated;
        private DateTime validTill;
        private AuthenticationTokenType type;
        private User user;
        private Integer sendCounter;

        AuthenticationTokenBuilder() {
        }

        public AuthenticationTokenBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public AuthenticationTokenBuilder token(String token) {
            this.token = token;
            return this;
        }

        public AuthenticationTokenBuilder dateCreated(DateTime dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public AuthenticationTokenBuilder validTill(DateTime validTill) {
            this.validTill = validTill;
            return this;
        }

        public AuthenticationTokenBuilder type(AuthenticationTokenType type) {
            this.type = type;
            return this;
        }

        public AuthenticationTokenBuilder user(User user) {
            this.user = user;
            return this;
        }

        public AuthenticationTokenBuilder sendCounter(Integer sendCounter) {
            this.sendCounter = sendCounter;
            return this;
        }

        public AuthenticationToken build() {
            return new AuthenticationToken(this.id, this.token, this.dateCreated, this.validTill, this.type, this.user, this.sendCounter);
        }

        public String toString() {
            return "AuthenticationToken.AuthenticationTokenBuilder(id=" + this.id + ", token=" + this.token + ", dateCreated=" + this.dateCreated + ", validTill=" + this.validTill + ", type=" + (Object)((Object)this.type) + ", user=" + this.user + ", sendCounter=" + this.sendCounter + ")";
        }
    }
}

