/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.model.acl;

import com.cumulocity.model.acl.ACLExpressionUtils;
import com.cumulocity.model.acl.ACLToken;

public enum Permission {
    ADMIN,
    READ,
    ANY("*");

    private final ACLToken token;

    private Permission(String permission) {
        this.token = ACLToken.asACLToken(permission);
    }

    private Permission() {
        this.token = ACLToken.asACLToken(this.name());
    }

    public static Permission fromExpression(String expr) {
        return ACLExpressionUtils.asPermission(expr);
    }

    public String toExpression() {
        return this.token.getExpression();
    }

    public ACLToken getToken() {
        return this.token;
    }

    public static boolean isRead(String permission) {
        return READ.name().equals(permission);
    }
}

