/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.model.acl;

import com.cumulocity.model.user.Group;
import com.cumulocity.model.user.User;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class DevicePermissionOwners {
    private List<User> users = new LinkedList<User>();
    private List<Group> groups = new LinkedList<Group>();

    public DevicePermissionOwners() {
    }

    public static DevicePermissionOwners create(List<User> dbUsers, List<Group> dbGroups) {
        if (dbUsers == null || dbGroups == null) {
            throw new IllegalArgumentException("Failed to create device permission owners, users or groups are null.");
        }
        DevicePermissionOwners permissionOwners = new DevicePermissionOwners();
        permissionOwners.users.addAll(dbUsers);
        permissionOwners.groups.addAll(dbGroups);
        return permissionOwners;
    }

    public void addUser(User user) {
        this.users.add(user);
    }

    public List<User> getUsers() {
        return this.users;
    }

    public void setUsers(List<User> users) {
        this.users = users;
    }

    public void addGroup(Group group) {
        this.groups.add(group);
    }

    public List<Group> getGroups() {
        return this.groups;
    }

    public void setGroups(List<Group> groups) {
        this.groups = groups;
    }

    public static DevicePermissionOwnersBuilder builder() {
        return new DevicePermissionOwnersBuilder();
    }

    public DevicePermissionOwners(List<User> users, List<Group> groups) {
        this.users = users;
        this.groups = groups;
    }

    public static class DevicePermissionOwnersBuilder {
        private ArrayList<User> users;
        private ArrayList<Group> groups;

        DevicePermissionOwnersBuilder() {
        }

        public DevicePermissionOwnersBuilder user(User user) {
            if (this.users == null) {
                this.users = new ArrayList();
            }
            this.users.add(user);
            return this;
        }

        public DevicePermissionOwnersBuilder users(Collection<? extends User> users) {
            if (users == null) {
                throw new NullPointerException("users cannot be null");
            }
            if (this.users == null) {
                this.users = new ArrayList();
            }
            this.users.addAll(users);
            return this;
        }

        public DevicePermissionOwnersBuilder clearUsers() {
            if (this.users != null) {
                this.users.clear();
            }
            return this;
        }

        public DevicePermissionOwnersBuilder group(Group group) {
            if (this.groups == null) {
                this.groups = new ArrayList();
            }
            this.groups.add(group);
            return this;
        }

        public DevicePermissionOwnersBuilder groups(Collection<? extends Group> groups) {
            if (groups == null) {
                throw new NullPointerException("groups cannot be null");
            }
            if (this.groups == null) {
                this.groups = new ArrayList();
            }
            this.groups.addAll(groups);
            return this;
        }

        public DevicePermissionOwnersBuilder clearGroups() {
            if (this.groups != null) {
                this.groups.clear();
            }
            return this;
        }

        public DevicePermissionOwners build() {
            List<Group> groups;
            List<User> users;
            switch (this.users == null ? 0 : this.users.size()) {
                case 0: {
                    users = Collections.emptyList();
                    break;
                }
                case 1: {
                    users = Collections.singletonList(this.users.get(0));
                    break;
                }
                default: {
                    users = Collections.unmodifiableList(new ArrayList<User>(this.users));
                }
            }
            switch (this.groups == null ? 0 : this.groups.size()) {
                case 0: {
                    groups = Collections.emptyList();
                    break;
                }
                case 1: {
                    groups = Collections.singletonList(this.groups.get(0));
                    break;
                }
                default: {
                    groups = Collections.unmodifiableList(new ArrayList<Group>(this.groups));
                }
            }
            return new DevicePermissionOwners(users, groups);
        }

        public String toString() {
            return "DevicePermissionOwners.DevicePermissionOwnersBuilder(users=" + this.users + ", groups=" + this.groups + ")";
        }
    }
}

