/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.model.user;

import com.cumulocity.model.DateTimeConverter;
import com.cumulocity.model.JSONBase;
import com.cumulocity.model.user.CumulocityAuthenticationTokenType;
import java.time.Duration;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.svenson.JSONProperty;
import org.svenson.converter.JSONConverter;

public class AuthenticationTokenData
extends JSONBase {
    private String tokenId;
    private String refreshToken;
    private String type;
    private String sessionId;
    private DateTime issuedAt;
    private DateTime expirationTime;
    private DateTime revokedAt;
    private String xsrfToken;
    private Boolean tfaVerified;

    public AuthenticationTokenData(String tokenId, String refreshToken, String type, String sessionId, DateTime issuedAt, DateTime expirationTime, DateTime revokedAt, String xsrfToken, Boolean tfaVerified) {
        this.tokenId = tokenId;
        this.refreshToken = refreshToken;
        this.type = CumulocityAuthenticationTokenType.fromString(type).name();
        this.sessionId = sessionId;
        this.issuedAt = issuedAt;
        this.expirationTime = expirationTime;
        this.revokedAt = revokedAt;
        this.xsrfToken = xsrfToken;
        this.tfaVerified = tfaVerified;
    }

    @JSONProperty(ignoreIfNull=true)
    public void setType(String type) {
        this.type = CumulocityAuthenticationTokenType.fromString(type).name();
    }

    @JSONProperty(ignore=true)
    public boolean containTokenId(String tokenId) {
        return this.tokenId.equals(tokenId);
    }

    @JSONProperty(ignore=true)
    public boolean isValidFromNowFor(Duration duration) {
        DateTime dateTimeInFuture = DateTime.now().plusSeconds((int)duration.getSeconds());
        return this.isTokenLived(dateTimeInFuture);
    }

    private boolean isTokenLived(DateTime dateTime) {
        if (this.revokedAt == null) {
            return dateTime.isBefore((ReadableInstant)this.expirationTime);
        }
        return dateTime.isBefore((ReadableInstant)this.expirationTime) && dateTime.isBefore((ReadableInstant)this.revokedAt);
    }

    @JSONProperty(ignore=true)
    public boolean isSessionToken() {
        return CumulocityAuthenticationTokenType.valueOf(this.type).isSessionToken();
    }

    @JSONProperty(ignore=true)
    public boolean isUserAgentValidationRequired() {
        return CumulocityAuthenticationTokenType.valueOf(this.type).isUserAgentValidationRequired();
    }

    @JSONProperty(ignore=true)
    public boolean isTokenTerminated() {
        return !this.isTokenLived(DateTime.now());
    }

    @JSONProperty(ignore=true)
    public boolean isVerifiedByTfa() {
        return this.tfaVerified != null && this.tfaVerified != false;
    }

    public void setTokenId(String tokenId) {
        this.tokenId = tokenId;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public void setIssuedAt(DateTime issuedAt) {
        this.issuedAt = issuedAt;
    }

    public void setExpirationTime(DateTime expirationTime) {
        this.expirationTime = expirationTime;
    }

    public void setRevokedAt(DateTime revokedAt) {
        this.revokedAt = revokedAt;
    }

    public void setXsrfToken(String xsrfToken) {
        this.xsrfToken = xsrfToken;
    }

    public void setTfaVerified(Boolean tfaVerified) {
        this.tfaVerified = tfaVerified;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthenticationTokenData)) {
            return false;
        }
        AuthenticationTokenData other = (AuthenticationTokenData)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$tfaVerified = this.getTfaVerified();
        Boolean other$tfaVerified = other.getTfaVerified();
        if (this$tfaVerified == null ? other$tfaVerified != null : !((Object)this$tfaVerified).equals(other$tfaVerified)) {
            return false;
        }
        String this$tokenId = this.getTokenId();
        String other$tokenId = other.getTokenId();
        if (this$tokenId == null ? other$tokenId != null : !this$tokenId.equals(other$tokenId)) {
            return false;
        }
        String this$refreshToken = this.getRefreshToken();
        String other$refreshToken = other.getRefreshToken();
        if (this$refreshToken == null ? other$refreshToken != null : !this$refreshToken.equals(other$refreshToken)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$sessionId = this.getSessionId();
        String other$sessionId = other.getSessionId();
        if (this$sessionId == null ? other$sessionId != null : !this$sessionId.equals(other$sessionId)) {
            return false;
        }
        DateTime this$issuedAt = this.getIssuedAt();
        DateTime other$issuedAt = other.getIssuedAt();
        if (this$issuedAt == null ? other$issuedAt != null : !this$issuedAt.equals(other$issuedAt)) {
            return false;
        }
        DateTime this$expirationTime = this.getExpirationTime();
        DateTime other$expirationTime = other.getExpirationTime();
        if (this$expirationTime == null ? other$expirationTime != null : !this$expirationTime.equals(other$expirationTime)) {
            return false;
        }
        DateTime this$revokedAt = this.getRevokedAt();
        DateTime other$revokedAt = other.getRevokedAt();
        if (this$revokedAt == null ? other$revokedAt != null : !this$revokedAt.equals(other$revokedAt)) {
            return false;
        }
        String this$xsrfToken = this.getXsrfToken();
        String other$xsrfToken = other.getXsrfToken();
        return !(this$xsrfToken == null ? other$xsrfToken != null : !this$xsrfToken.equals(other$xsrfToken));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AuthenticationTokenData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $tfaVerified = this.getTfaVerified();
        result = result * 59 + ($tfaVerified == null ? 43 : ((Object)$tfaVerified).hashCode());
        String $tokenId = this.getTokenId();
        result = result * 59 + ($tokenId == null ? 43 : $tokenId.hashCode());
        String $refreshToken = this.getRefreshToken();
        result = result * 59 + ($refreshToken == null ? 43 : $refreshToken.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $sessionId = this.getSessionId();
        result = result * 59 + ($sessionId == null ? 43 : $sessionId.hashCode());
        DateTime $issuedAt = this.getIssuedAt();
        result = result * 59 + ($issuedAt == null ? 43 : $issuedAt.hashCode());
        DateTime $expirationTime = this.getExpirationTime();
        result = result * 59 + ($expirationTime == null ? 43 : $expirationTime.hashCode());
        DateTime $revokedAt = this.getRevokedAt();
        result = result * 59 + ($revokedAt == null ? 43 : $revokedAt.hashCode());
        String $xsrfToken = this.getXsrfToken();
        result = result * 59 + ($xsrfToken == null ? 43 : $xsrfToken.hashCode());
        return result;
    }

    public String toString() {
        return "AuthenticationTokenData(tokenId=" + this.getTokenId() + ", refreshToken=" + this.getRefreshToken() + ", type=" + this.getType() + ", sessionId=" + this.getSessionId() + ", issuedAt=" + this.getIssuedAt() + ", expirationTime=" + this.getExpirationTime() + ", revokedAt=" + this.getRevokedAt() + ", xsrfToken=" + this.getXsrfToken() + ", tfaVerified=" + this.getTfaVerified() + ")";
    }

    public AuthenticationTokenData() {
    }

    @JSONProperty(ignore=true)
    public String getTokenId() {
        return this.tokenId;
    }

    @JSONProperty(ignoreIfNull=true)
    public String getRefreshToken() {
        return this.refreshToken;
    }

    @JSONProperty(ignoreIfNull=true)
    public String getType() {
        return this.type;
    }

    @JSONProperty(ignoreIfNull=true)
    public String getSessionId() {
        return this.sessionId;
    }

    @JSONConverter(type=DateTimeConverter.class)
    @JSONProperty(ignoreIfNull=true)
    public DateTime getIssuedAt() {
        return this.issuedAt;
    }

    @JSONConverter(type=DateTimeConverter.class)
    @JSONProperty(ignoreIfNull=true)
    public DateTime getExpirationTime() {
        return this.expirationTime;
    }

    @JSONConverter(type=DateTimeConverter.class)
    @JSONProperty(ignoreIfNull=true)
    public DateTime getRevokedAt() {
        return this.revokedAt;
    }

    @JSONProperty(ignoreIfNull=true)
    public String getXsrfToken() {
        return this.xsrfToken;
    }

    @JSONProperty(ignoreIfNull=true)
    public Boolean getTfaVerified() {
        return this.tfaVerified;
    }
}

