/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.model.user;

import com.cumulocity.model.DateTimeConverter;
import com.cumulocity.model.JSONBase;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.svenson.JSONProperty;
import org.svenson.converter.JSONConverter;

public class AuthenticationSession
extends JSONBase {
    public static final String USER_PROPERTY_AGENT = "User-Agent";
    private String sessionId;
    private DateTime creationTime;
    private DateTime expirationTime;
    private Map<String, String> userProperties = new HashMap<String, String>();
    private Boolean tokensRenewable;

    public AuthenticationSession(String sessionId, DateTime creationTime, DateTime expirationTime, boolean tokensRenewable, String userAgent) {
        this.sessionId = sessionId;
        this.creationTime = creationTime;
        this.expirationTime = expirationTime;
        this.userProperties = new HashMap<String, String>();
        this.userProperties.put(USER_PROPERTY_AGENT, userAgent);
        this.tokensRenewable = tokensRenewable;
    }

    @JSONProperty(ignore=true)
    public boolean isValidFromNowFor(Duration duration) {
        return this.expirationTime.isAfter((ReadableInstant)DateTime.now().plusSeconds((int)duration.getSeconds()));
    }

    @JSONProperty(ignore=true)
    public boolean isSessionExpired() {
        return DateTime.now().isAfter((ReadableInstant)this.getExpirationTime());
    }

    @JSONProperty(ignore=true)
    public boolean isUserAgentNotAccepted(String providedUserAgent) {
        String userAgent = this.userProperties.get(USER_PROPERTY_AGENT);
        return userAgent != null && !userAgent.equals(providedUserAgent);
    }

    @JSONProperty(ignore=true)
    public Optional<String> getUserAgentProperty() {
        return Optional.ofNullable(this.userProperties.get(USER_PROPERTY_AGENT));
    }

    @JSONProperty(ignore=true)
    public boolean areTokensRenewable() {
        return this.tokensRenewable != null && this.tokensRenewable != false;
    }

    public AuthenticationSession() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthenticationSession)) {
            return false;
        }
        AuthenticationSession other = (AuthenticationSession)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$tokensRenewable = this.getTokensRenewable();
        Boolean other$tokensRenewable = other.getTokensRenewable();
        if (this$tokensRenewable == null ? other$tokensRenewable != null : !((Object)this$tokensRenewable).equals(other$tokensRenewable)) {
            return false;
        }
        String this$sessionId = this.getSessionId();
        String other$sessionId = other.getSessionId();
        if (this$sessionId == null ? other$sessionId != null : !this$sessionId.equals(other$sessionId)) {
            return false;
        }
        DateTime this$creationTime = this.getCreationTime();
        DateTime other$creationTime = other.getCreationTime();
        if (this$creationTime == null ? other$creationTime != null : !this$creationTime.equals(other$creationTime)) {
            return false;
        }
        DateTime this$expirationTime = this.getExpirationTime();
        DateTime other$expirationTime = other.getExpirationTime();
        if (this$expirationTime == null ? other$expirationTime != null : !this$expirationTime.equals(other$expirationTime)) {
            return false;
        }
        Map<String, String> this$userProperties = this.getUserProperties();
        Map<String, String> other$userProperties = other.getUserProperties();
        return !(this$userProperties == null ? other$userProperties != null : !((Object)this$userProperties).equals(other$userProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AuthenticationSession;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $tokensRenewable = this.getTokensRenewable();
        result = result * 59 + ($tokensRenewable == null ? 43 : ((Object)$tokensRenewable).hashCode());
        String $sessionId = this.getSessionId();
        result = result * 59 + ($sessionId == null ? 43 : $sessionId.hashCode());
        DateTime $creationTime = this.getCreationTime();
        result = result * 59 + ($creationTime == null ? 43 : $creationTime.hashCode());
        DateTime $expirationTime = this.getExpirationTime();
        result = result * 59 + ($expirationTime == null ? 43 : $expirationTime.hashCode());
        Map<String, String> $userProperties = this.getUserProperties();
        result = result * 59 + ($userProperties == null ? 43 : ((Object)$userProperties).hashCode());
        return result;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public void setCreationTime(DateTime creationTime) {
        this.creationTime = creationTime;
    }

    public void setExpirationTime(DateTime expirationTime) {
        this.expirationTime = expirationTime;
    }

    public void setUserProperties(Map<String, String> userProperties) {
        this.userProperties = userProperties;
    }

    public void setTokensRenewable(Boolean tokensRenewable) {
        this.tokensRenewable = tokensRenewable;
    }

    @JSONProperty(ignore=true)
    public String getSessionId() {
        return this.sessionId;
    }

    @JSONConverter(type=DateTimeConverter.class)
    @JSONProperty(ignoreIfNull=true)
    public DateTime getCreationTime() {
        return this.creationTime;
    }

    @JSONConverter(type=DateTimeConverter.class)
    @JSONProperty(ignoreIfNull=true)
    public DateTime getExpirationTime() {
        return this.expirationTime;
    }

    @JSONProperty(ignoreIfNull=true)
    public Map<String, String> getUserProperties() {
        return this.userProperties;
    }

    @JSONProperty(ignoreIfNull=true)
    public Boolean getTokensRenewable() {
        return this.tokensRenewable;
    }
}

