/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.model.role.inventory;

import com.cumulocity.model.acl.Api;
import com.cumulocity.model.acl.Permission;
import com.cumulocity.model.role.inventory.InventoryPermission;
import com.cumulocity.model.role.inventory.InventoryRole;
import com.google.common.collect.Lists;

public enum DefaultInventoryRole {
    READER(InventoryRole.inventoryRole().name("Reader").description("Can read all data of the asset.").permission(InventoryPermission.inventoryPermission().scope(Api.ANY).type("*").permission(Permission.READ).build()).build()),
    MANAGER(InventoryRole.inventoryRole().name("Manager").description("Can read all data of the asset and manage all inventory data, but cannot perform operations. Can also acknowledge and clear alarms. Can create and updates dashboards.").permission(InventoryPermission.inventoryPermission().scope(Api.ANY).type("*").permission(Permission.READ).build()).permission(InventoryPermission.inventoryPermission().scope(Api.MANAGED_OBJECT).type("*").permission(Permission.ADMIN).build()).permission(InventoryPermission.inventoryPermission().scope(Api.ALARM).type("*").permission(Permission.ADMIN).build()).build()),
    OPERATIONS_ALL(InventoryRole.inventoryRole().name("Operations: All").description("Can remotely manage the assets by sending operations to the device. This includes for example remote configuration, software update, etc. ").permission(InventoryPermission.inventoryPermission().scope(Api.OPERATION).type("*").permission(Permission.ADMIN).build()).build()),
    OPERATIONS_RESTART(InventoryRole.inventoryRole().name("Operations: Restart Device").description("Can restart devices.").permission(InventoryPermission.inventoryPermission().scope(Api.MANAGED_OBJECT).type("*").permission(Permission.READ).build()).permission(InventoryPermission.inventoryPermission().scope(Api.OPERATION).type("c8y_Restart").permission(Permission.ADMIN).build()).permission(InventoryPermission.inventoryPermission().scope(Api.OPERATION).type("c8y_Restart").permission(Permission.READ).build()).build());

    private final InventoryRole inventoryRole;

    public InventoryRole newInstance() {
        InventoryRole role = this.inventoryRole.toBuilder().build();
        role.setPermissions(Lists.newArrayList());
        for (InventoryPermission inventoryPermission : this.inventoryRole.getPermissions()) {
            role.getPermissions().add(inventoryPermission.toBuilder().build());
        }
        return role;
    }

    private DefaultInventoryRole(InventoryRole inventoryRole) {
        this.inventoryRole = inventoryRole;
    }
}

