/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.model.acl;

import com.cumulocity.model.acl.ACLExpression;
import com.cumulocity.model.acl.ACLExpressionUtils;
import com.cumulocity.model.acl.ACLPermission;
import com.cumulocity.model.audit.AuditLogValue;
import org.svenson.JSONProperty;

public class DevicePermission
implements AuditLogValue,
ACLPermission {
    public static final String GLOBAL_PERMISSION = "c8y_Global";
    private String managedObject;
    private String permission;

    public DevicePermission(String managedObject, String permission) {
        this.managedObject = managedObject;
        this.permission = permission;
    }

    @Override
    @JSONProperty(ignore=true)
    public ACLExpression getExpression() {
        return ACLExpressionUtils.asACLExpression(this.permission);
    }

    @JSONProperty(ignore=true)
    public Object getLogValue() {
        return "(managedObject=" + this.managedObject + ", permission=" + this.permission + ")";
    }

    public static DevicePermissionBuilder devicePermission() {
        return new DevicePermissionBuilder();
    }

    public DevicePermission() {
    }

    public void setManagedObject(String managedObject) {
        this.managedObject = managedObject;
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DevicePermission)) {
            return false;
        }
        DevicePermission other = (DevicePermission)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$managedObject = this.getManagedObject();
        String other$managedObject = other.getManagedObject();
        if (this$managedObject == null ? other$managedObject != null : !this$managedObject.equals(other$managedObject)) {
            return false;
        }
        String this$permission = this.getPermission();
        String other$permission = other.getPermission();
        return !(this$permission == null ? other$permission != null : !this$permission.equals(other$permission));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DevicePermission;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $managedObject = this.getManagedObject();
        result = result * 59 + ($managedObject == null ? 43 : $managedObject.hashCode());
        String $permission = this.getPermission();
        result = result * 59 + ($permission == null ? 43 : $permission.hashCode());
        return result;
    }

    public String toString() {
        return "DevicePermission(managedObject=" + this.getManagedObject() + ", permission=" + this.getPermission() + ")";
    }

    @Override
    @JSONProperty(ignoreIfNull=true)
    public String getManagedObject() {
        return this.managedObject;
    }

    @JSONProperty(ignoreIfNull=true)
    public String getPermission() {
        return this.permission;
    }

    public static class DevicePermissionBuilder {
        private String managedObject;
        private String permission;

        DevicePermissionBuilder() {
        }

        public DevicePermissionBuilder managedObject(String managedObject) {
            this.managedObject = managedObject;
            return this;
        }

        public DevicePermissionBuilder permission(String permission) {
            this.permission = permission;
            return this;
        }

        public DevicePermission build() {
            return new DevicePermission(this.managedObject, this.permission);
        }

        public String toString() {
            return "DevicePermission.DevicePermissionBuilder(managedObject=" + this.managedObject + ", permission=" + this.permission + ")";
        }
    }
}

