/*
 * Decompiled with CFR 0.152.
 */
package org.svenson.util;

import org.svenson.tokenize.JSONTokenizer;
import org.svenson.tokenize.Token;
import org.svenson.tokenize.TokenType;

public class TokenUtil {
    public static void skipObjectValue(JSONTokenizer tokenizer) {
        TokenUtil.skipComplexValue(tokenizer, TokenType.BRACE_OPEN, TokenType.BRACE_CLOSE);
    }

    public static void skipArrayValue(JSONTokenizer tokenizer) {
        TokenUtil.skipComplexValue(tokenizer, TokenType.BRACKET_OPEN, TokenType.BRACKET_CLOSE);
    }

    private static void skipComplexValue(JSONTokenizer tokenizer, TokenType open, TokenType close) {
        Token token;
        TokenType tokenType;
        int level = 1;
        while ((tokenType = (token = tokenizer.next()).type()) != TokenType.END) {
            if (tokenType == open) {
                ++level;
            } else if (tokenType == close) {
                --level;
            }
            if (level != 0) continue;
        }
        if (token.type() == TokenType.END) {
            throw new IllegalStateException("Unexpected end");
        }
    }
}

