/*
 * Decompiled with CFR 0.152.
 */
package org.svenson.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.svenson.DynamicProperties;
import org.svenson.JSONParseException;
import org.svenson.ObjectFactory;
import org.svenson.TypeAnalyzer;
import org.svenson.info.JSONPropertyInfo;
import org.svenson.info.JavaObjectSupport;
import org.svenson.info.ObjectSupport;
import org.svenson.util.ExceptionWrapper;
import org.svenson.util.InvalidPropertyPathException;
import org.svenson.util.JSONBeanUtil;
import org.svenson.util.PropertyPathAccessException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONPathUtil {
    private static final Object GET_VALUE = new Object();
    private static final Pattern PATH_PATTERN = Pattern.compile("[\\[\\.]");
    private List<ObjectFactory<?>> objectFactories = Collections.emptyList();
    private boolean grow = true;
    private ObjectSupport objectSupport;
    private static final Pattern NUMERIC_PATTERN = Pattern.compile("^[0-9]+$");
    private static final int HEX_LETTER_OFFSET = 7;

    public JSONPathUtil() {
        this(new JavaObjectSupport());
    }

    public JSONPathUtil(ObjectSupport objectSupport) {
        this.objectSupport = objectSupport;
    }

    public void setGrow(boolean grow) {
        this.grow = grow;
    }

    public void setObjectFactories(List<ObjectFactory<?>> objectFactories) {
        this.objectFactories = objectFactories;
    }

    public void setPropertyPath(Object bean, String path, Object value) {
        this.getOrSetPropertyPath(bean, path, value);
    }

    public Object getPropertyPath(Object bean, String path) {
        return this.getOrSetPropertyPath(bean, path, GET_VALUE);
    }

    private Object getOrSetPropertyPath(Object bean, String path, Object value) throws InvalidPropertyPathException, PropertyPathAccessException {
        block47: {
            if (bean == null) {
                throw new IllegalArgumentException("bean cannot be null");
            }
            Object rootBean = bean;
            boolean canGrow = this.grow && value != GET_VALUE;
            try {
                boolean isList;
                String[] parts = this.parsePropertyPath(path);
                Object lastDoc = null;
                JSONPropertyInfo lastPD = null;
                if (parts.length > 1) {
                    for (int curPart = 0; curPart < parts.length - 1; ++curPart) {
                        Class type;
                        String part = parts[curPart].trim();
                        if (part.length() == 0) {
                            throw new InvalidPropertyPathException(path, "empty property-path segment");
                        }
                        if (JSONPathUtil.isNumeric(part)) {
                            isList = bean instanceof List;
                            boolean isArray = bean.getClass().isArray();
                            if (!isList && !isArray) {
                                throw new InvalidPropertyPathException(path, "numeric index on non-indexable type " + bean);
                            }
                            Object child = null;
                            int idx = Integer.parseInt(part);
                            if (isList) {
                                List list = (List)bean;
                                if (idx < list.size()) {
                                    child = list.get(idx);
                                }
                                if (child == null) {
                                    if (!canGrow) {
                                        throw new PropertyPathAccessException(path, bean, "List has no child at index " + idx);
                                    }
                                    Class<Object> type2 = null;
                                    if (lastPD != null) {
                                        type2 = lastPD.getTypeHint();
                                    }
                                    if (type2 == null) {
                                        type2 = JSONPathUtil.isNumeric(parts[curPart + 1]) ? ArrayList.class : HashMap.class;
                                    }
                                    child = JSONPathUtil.createNewObjectOfType(type2, this.objectFactories);
                                    JSONPathUtil.setIndexInList(list, idx, child);
                                }
                                lastPD = null;
                            } else {
                                Object newArray;
                                child = Array.get(bean, idx);
                                if (child == null) {
                                    if (!canGrow) {
                                        throw new PropertyPathAccessException(path, bean, "Array has no child at index " + idx);
                                    }
                                    child = JSONPathUtil.createNewObjectOfType(bean.getClass().getComponentType(), this.objectFactories);
                                }
                                if ((newArray = JSONPathUtil.setIndexInList(bean, idx, child)) != bean) {
                                    this.writeBackArray(rootBean, parts, curPart, newArray);
                                }
                            }
                            lastDoc = bean;
                            bean = child;
                            continue;
                        }
                        part = JSONPathUtil.unquotePart(part);
                        Object child = null;
                        JSONPropertyInfo propertyInfo = null;
                        if (bean instanceof Map) {
                            child = ((Map)bean).get(part);
                            if (child == null) {
                                if (!canGrow) {
                                    throw new PropertyPathAccessException(path, bean, "Map has no value at key '" + part + "'");
                                }
                                type = null;
                                type = lastPD != null ? lastPD.getTypeHint() : (JSONPathUtil.isNumeric(parts[curPart + 1]) ? ArrayList.class : HashMap.class);
                                child = JSONPathUtil.createNewObjectOfType(type, this.objectFactories);
                                ((Map)bean).put(part, child);
                            }
                            lastPD = null;
                        } else {
                            propertyInfo = TypeAnalyzer.getClassInfo(this.objectSupport, bean.getClass()).getPropertyInfo(part);
                            if (propertyInfo != null && propertyInfo.isReadable()) {
                                String propertyName = propertyInfo.getJavaPropertyName();
                                if (propertyName == null) {
                                    propertyName = part;
                                }
                                if ((child = propertyInfo.getProperty(bean)) == null) {
                                    if (!canGrow) {
                                        throw new PropertyPathAccessException(path, bean, bean + " has no value for property '" + part + "'");
                                    }
                                    if (!propertyInfo.isWriteable()) {
                                        throw new InvalidPropertyPathException(path, "No write method for null value");
                                    }
                                    child = JSONPathUtil.createNewObjectOfType(propertyInfo.getType(), this.objectFactories);
                                    propertyInfo.setProperty(bean, child);
                                }
                            } else if (bean instanceof DynamicProperties) {
                                child = ((DynamicProperties)bean).getProperty(part);
                                if (child == null) {
                                    if (!canGrow) {
                                        throw new PropertyPathAccessException(path, bean, bean + " has no value for dynamic property '" + part + "'");
                                    }
                                    type = JSONPathUtil.isNumeric(parts[curPart + 1]) ? ArrayList.class : HashMap.class;
                                    child = JSONPathUtil.createNewObjectOfType(type, this.objectFactories);
                                    ((DynamicProperties)bean).setProperty(part, child);
                                }
                                lastPD = null;
                            } else {
                                throw new InvalidPropertyPathException(path, "Cannot read property '" + part + "' from " + bean);
                            }
                        }
                        lastDoc = bean;
                        bean = child;
                        lastPD = propertyInfo;
                    }
                }
                String part = JSONPathUtil.unquotePart(parts[parts.length - 1]);
                if (value == GET_VALUE) {
                    if (JSONPathUtil.isNumeric(part)) {
                        int idx = Integer.parseInt(part);
                        isList = bean instanceof List;
                        if (!isList && !bean.getClass().isArray()) {
                            throw new InvalidPropertyPathException(path, "Path component for numeric parts must be either List or Array");
                        }
                        if (isList) {
                            return ((List)bean).get(idx);
                        }
                        return Array.get(bean, idx);
                    }
                    return JSONBeanUtil.defaultUtil().getProperty(bean, part);
                }
                if (JSONPathUtil.isNumeric(part)) {
                    int idx = Integer.parseInt(part);
                    isList = bean instanceof List;
                    if (!isList && !bean.getClass().isArray()) {
                        throw new InvalidPropertyPathException(path, "Path componente for numeric parts must be either List or Array");
                    }
                    if (isList) {
                        JSONPathUtil.setIndexInList(bean, idx, value);
                    } else {
                        Object newArray = JSONPathUtil.setIndexInList(bean, idx, value);
                        if (newArray != bean) {
                            this.writeBackArray(rootBean, parts, parts.length - 1, newArray);
                        }
                    }
                    break block47;
                }
                part = JSONPathUtil.unquotePart(part);
                if (bean instanceof Map) {
                    ((Map)bean).put(part, value);
                    break block47;
                }
                JSONPropertyInfo propertyInfo = TypeAnalyzer.getClassInfo(this.objectSupport, bean.getClass()).getPropertyInfo(part);
                if (propertyInfo != null && propertyInfo.isWriteable()) {
                    propertyInfo.setProperty(bean, value);
                    break block47;
                }
                if (bean instanceof DynamicProperties) {
                    ((DynamicProperties)bean).setProperty(part, value);
                    break block47;
                }
                throw new InvalidPropertyPathException(path, "Cannot set property path");
            }
            catch (NumberFormatException e) {
                throw ExceptionWrapper.wrap(e);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw ExceptionWrapper.wrap(e);
            }
            catch (IllegalAccessException e) {
                throw ExceptionWrapper.wrap(e);
            }
            catch (InstantiationException e) {
                throw ExceptionWrapper.wrap(e);
            }
        }
        return null;
    }

    private static Object setIndexInList(Object bean, int idx, Object child) {
        if (bean instanceof List) {
            List l = (List)bean;
            while (l.size() <= idx) {
                l.add(null);
            }
            l.set(idx, child);
            return l;
        }
        if (bean.getClass().isArray()) {
            int length = Array.getLength(bean);
            if (length <= idx) {
                Object newArray = Array.newInstance(bean.getClass().getComponentType(), idx + 1);
                System.arraycopy(bean, 0, newArray, 0, length);
                bean = newArray;
            }
            Array.set(bean, idx, child);
            return bean;
        }
        return null;
    }

    private static Object createNewObjectOfType(Class<?> type, List<ObjectFactory<?>> factories) throws InstantiationException, IllegalAccessException {
        HashMap bean = null;
        for (ObjectFactory<?> factory : factories) {
            if (!factory.supports(type)) continue;
            bean = factory.create(type);
        }
        if (bean == null) {
            if (Map.class.isAssignableFrom(type)) {
                bean = new HashMap();
            } else {
                if (List.class.isAssignableFrom(type)) {
                    return JSONPathUtil.createNewArrayLike(type, factories, 1);
                }
                if (type.isArray()) {
                    return JSONPathUtil.createNewArrayLike(type, factories, 1);
                }
                bean = type.newInstance();
            }
        }
        return bean;
    }

    private static Object createNewArrayLike(Class type, List<ObjectFactory<?>> factories, int size) {
        Object bean = null;
        for (ObjectFactory<?> factory : factories) {
            if (!factory.supports(type)) continue;
            bean = factory.create(type);
        }
        if (bean == null) {
            if (List.class.isAssignableFrom(type)) {
                bean = new ArrayList(size);
            } else if (type.isArray()) {
                bean = Array.newInstance(type.getComponentType(), size);
            }
        }
        return bean;
    }

    private static String unquotePart(String part) {
        char c = part.charAt(0);
        if (c == '\"' || c == '\'') {
            part = new StringParser(part, 1).parseString(c);
        }
        return part;
    }

    private static boolean isNumeric(String part) {
        return NUMERIC_PATTERN.matcher(part).matches();
    }

    static int hexValue(char c) {
        int n = c;
        if (n >= 97) {
            n &= 0xFFFFFFDF;
        }
        if (n >= 48 && n <= 57 || n >= 65 && n <= 70) {
            if ((n -= 48) > 9) {
                return n - 7;
            }
            return n;
        }
        throw new NumberFormatException("Invalid hex character " + (char)c);
    }

    private String[] parsePropertyPath(String path) {
        return PATH_PATTERN.split(path.replace("]", ""));
    }

    private void writeBackArray(Object rootBean, String[] parts, int curPart, Object newArray) {
        StringBuilder writeBackPathBuf = new StringBuilder();
        for (int i = 0; i < curPart; ++i) {
            if (i > 0) {
                writeBackPathBuf.append(".");
            }
            writeBackPathBuf.append(parts[i]);
        }
        this.setPropertyPath(rootBean, writeBackPathBuf.toString(), newArray);
    }

    private static class StringParser {
        private String string;
        private int pos;

        public StringParser(String s, int i) {
            this.string = s;
            this.pos = i;
        }

        public int getPos() {
            return this.pos;
        }

        public String parseString(char quoteChar) {
            int c;
            StringBuilder sb = new StringBuilder();
            boolean escape = false;
            while ((c = this.nextChar()) >= 0) {
                if (c == quoteChar && !escape) {
                    return sb.toString();
                }
                if (c == 92) {
                    if (escape) {
                        sb.append('\\');
                    }
                    escape = !escape;
                    continue;
                }
                if (escape) {
                    switch ((char)c) {
                        case '\"': 
                        case '\'': 
                        case '/': {
                            sb.append((char)c);
                            break;
                        }
                        case 'b': {
                            sb.append('\b');
                            break;
                        }
                        case 'f': {
                            sb.append('\f');
                            break;
                        }
                        case 'n': {
                            sb.append('\n');
                            break;
                        }
                        case 'r': {
                            sb.append('\r');
                            break;
                        }
                        case 't': {
                            sb.append('\t');
                            break;
                        }
                        case 'u': {
                            int unicode = (JSONPathUtil.hexValue((char)this.nextChar()) << 12) + (JSONPathUtil.hexValue((char)this.nextChar()) << 8) + (JSONPathUtil.hexValue((char)this.nextChar()) << 4) + JSONPathUtil.hexValue((char)this.nextChar());
                            sb.append((char)unicode);
                            break;
                        }
                        default: {
                            throw new JSONParseException("Illegal escape character " + c + " / " + Integer.toHexString(c));
                        }
                    }
                    escape = false;
                    continue;
                }
                if (Character.isISOControl(c)) {
                    throw new JSONParseException("Illegal control character 0x" + Integer.toHexString(c));
                }
                sb.append((char)c);
            }
            throw new JSONParseException("Unclosed quotes");
        }

        private int nextChar() {
            return this.string.charAt(this.pos++);
        }
    }
}

