/*
 * Decompiled with CFR 0.152.
 */
package org.svenson.util;

import java.util.Collection;
import org.svenson.JSON;
import org.svenson.JSONCharacterSink;
import org.svenson.StringBuilderSink;
import org.svenson.util.IllegalBuilderStateException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONBuilder {
    private final JSON generator;
    private final JSONCharacterSink sink;
    private Level topMost;

    private JSONBuilder(JSON generator, JSONCharacterSink sink, boolean isObject) {
        this.generator = generator != null ? generator : JSON.defaultJSON();
        this.sink = sink;
        this.topMost = new Level(null, isObject);
    }

    private void commaUnlessFirst() {
        if (!this.topMost.isFirst()) {
            this.sink.append(",");
        } else {
            this.topMost.first = false;
        }
    }

    private void ensureObject() {
        if (!this.topMost.isObject()) {
            throw new IllegalBuilderStateException("Cannot add property to array");
        }
    }

    private void ensureArray() {
        if (this.topMost.isObject()) {
            throw new IllegalBuilderStateException("Cannot add elements to object");
        }
    }

    public JSONBuilder objectProperty(String name) {
        this.ensureUnlocked();
        this.ensureObject();
        this.commaUnlessFirst();
        this.generator.quote(this.sink, name);
        this.sink.append(":{");
        this.topMost = new Level(this.topMost, true);
        return this;
    }

    public JSONBuilder includeProperty(String name, String json) {
        this.ensureUnlocked();
        this.ensureObject();
        this.commaUnlessFirst();
        this.generator.quote(this.sink, name);
        this.sink.append(":");
        this.sink.append(json);
        return this;
    }

    public JSONBuilder arrayProperty(String name) {
        this.ensureUnlocked();
        this.ensureObject();
        this.commaUnlessFirst();
        this.generator.quote(this.sink, name);
        this.sink.append(":[");
        this.topMost = new Level(this.topMost, false);
        return this;
    }

    public JSONBuilder objectElement() {
        this.ensureUnlocked();
        this.ensureArray();
        this.commaUnlessFirst();
        this.sink.append("{");
        this.topMost = new Level(this.topMost, true);
        return this;
    }

    public JSONBuilder arrayElement() {
        this.ensureUnlocked();
        this.ensureArray();
        this.commaUnlessFirst();
        this.sink.append("[");
        this.topMost = new Level(this.topMost, false);
        return this;
    }

    public JSONBuilder property(String name, Object value) {
        this.ensureUnlocked();
        this.ensureObject();
        this.commaUnlessFirst();
        this.generator.quote(this.sink, name);
        this.sink.append(':');
        this.generator.dumpObject(this.sink, value);
        return this;
    }

    public JSONBuilder propertyUnlessNull(String name, Object value) {
        if (value != null) {
            return this.property(name, value);
        }
        return this;
    }

    public JSONBuilder element(Object value) {
        this.ensureUnlocked();
        this.ensureArray();
        this.commaUnlessFirst();
        this.generator.dumpObject(this.sink, value);
        return this;
    }

    public JSONBuilder elements(Object ... values) {
        this.ensureUnlocked();
        this.ensureArray();
        for (Object value : values) {
            this.commaUnlessFirst();
            this.generator.dumpObject(this.sink, value);
        }
        return this;
    }

    public JSONBuilder elements(Collection<?> values) {
        this.ensureUnlocked();
        this.ensureArray();
        for (Object value : values) {
            this.commaUnlessFirst();
            this.generator.dumpObject(this.sink, value);
        }
        return this;
    }

    public JSONBuilder close() {
        this.ensureUnlocked();
        if (this.topMost.isObject()) {
            this.sink.append('}');
        } else {
            this.sink.append(']');
        }
        this.topMost = this.topMost.getParent();
        return this;
    }

    public JSONBuilder includeElement(String json) {
        this.ensureUnlocked();
        this.ensureArray();
        this.commaUnlessFirst();
        this.sink.append(json);
        return this;
    }

    private void ensureUnlocked() {
        if (this.isLocked()) {
            throw new IllegalBuilderStateException("Invalid operation on locked builder. Root level already closed.");
        }
    }

    public boolean isLocked() {
        return this.topMost == null;
    }

    public boolean isObject() {
        return this.topMost != null && this.topMost.isObject();
    }

    public boolean isFirst() {
        return this.topMost != null && this.topMost.isFirst();
    }

    public String output() {
        this.closeAll();
        if (!(this.sink instanceof StringBuilderSink)) {
            throw new IllegalBuilderStateException("Cannot get output from sink " + this.sink + ", it is not a StringBuilderSink");
        }
        return ((StringBuilderSink)this.sink).getContent();
    }

    public JSONBuilder closeAll() {
        while (!this.isLocked()) {
            this.close();
        }
        return this;
    }

    public static JSONBuilder buildObject() {
        return JSONBuilder.buildObject(null);
    }

    public static JSONBuilder buildObject(JSON generator) {
        return JSONBuilder.buildObject(generator, new StringBuilderSink());
    }

    public static JSONBuilder buildObject(JSON generator, JSONCharacterSink sink) {
        sink.append('{');
        return new JSONBuilder(generator, sink, true);
    }

    public static JSONBuilder buildArray() {
        return JSONBuilder.buildArray(null);
    }

    public static JSONBuilder buildArray(JSON generator) {
        return JSONBuilder.buildArray(generator, new StringBuilderSink());
    }

    public static JSONBuilder buildArray(JSON generator, JSONCharacterSink sink) {
        sink.append('[');
        return new JSONBuilder(generator, sink, false);
    }

    public Level getCurrentLevel() {
        return this.topMost;
    }

    public JSONBuilder closeUntil(Level level) {
        while (this.topMost != null && this.topMost != level) {
            this.close();
        }
        if (this.topMost == null) {
            throw new IllegalBuilderStateException("Unknown level" + level);
        }
        return this;
    }

    public static class Level {
        private final Level parent;
        private final boolean isObject;
        private boolean first;

        public Level(Level parent, boolean isObject) {
            this.parent = parent;
            this.isObject = isObject;
            this.first = true;
        }

        public Level getParent() {
            return this.parent;
        }

        public boolean isObject() {
            return this.isObject;
        }

        public boolean isFirst() {
            return this.first;
        }
    }
}

