/*
 * Decompiled with CFR 0.152.
 */
package org.svenson.util;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.svenson.DynamicProperties;
import org.svenson.TypeAnalyzer;
import org.svenson.info.JSONClassInfo;
import org.svenson.info.JSONPropertyInfo;
import org.svenson.info.JavaObjectSupport;
import org.svenson.info.ObjectSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONBeanUtil {
    private static final JSONBeanUtil instance = new JSONBeanUtil();
    private ObjectSupport objectSupport = new JavaObjectSupport();

    public void setObjectSupport(ObjectSupport objectSupport) {
        this.objectSupport = objectSupport;
    }

    public Set<String> getAllPropertyNames(Object bean) {
        if (bean instanceof Map) {
            return new HashSet<String>(((Map)bean).keySet());
        }
        HashSet<String> names = new HashSet<String>();
        if (bean instanceof DynamicProperties) {
            names.addAll(((DynamicProperties)bean).propertyNames());
        }
        names.addAll(this.getBeanPropertyNames(bean));
        return names;
    }

    public Set<String> getBeanPropertyNames(Object bean) {
        JSONClassInfo classInfo = this.getClassInfoForBean(bean);
        return classInfo.getPropertyNames();
    }

    protected JSONClassInfo getClassInfoForBean(Object bean) {
        return TypeAnalyzer.getClassInfo(this.objectSupport, bean.getClass());
    }

    public Object getProperty(Object bean, String name) throws IllegalArgumentException {
        if (bean instanceof Map) {
            return ((Map)bean).get(name);
        }
        JSONPropertyInfo propertyInfo = this.getClassInfoForBean(bean).getPropertyInfo(name);
        if (propertyInfo != null && propertyInfo.isReadable()) {
            return propertyInfo.getProperty(bean);
        }
        if (bean instanceof DynamicProperties) {
            return ((DynamicProperties)bean).getProperty(name);
        }
        throw new IllegalArgumentException(bean + " has no JSON property with the name '" + name + "' and does not implements DynamicProperties");
    }

    public void setProperty(Object bean, String name, Object value) throws IllegalArgumentException {
        if (bean instanceof Map) {
            ((Map)bean).put(name, value);
        } else {
            JSONPropertyInfo propertyInfo = this.getClassInfoForBean(bean).getPropertyInfo(name);
            if (propertyInfo != null && propertyInfo.isWriteable()) {
                if (Enum.class.isAssignableFrom(propertyInfo.getType()) && value instanceof String) {
                    Class<Object> cls = propertyInfo.getType();
                    propertyInfo.setProperty(bean, Enum.valueOf(cls, (String)value));
                } else {
                    propertyInfo.setProperty(bean, value);
                }
            } else if (bean instanceof DynamicProperties) {
                ((DynamicProperties)bean).setProperty(name, value);
            } else {
                throw new IllegalArgumentException(bean + " has no JSON property with the name '" + name + "' and does not implements DynamicProperties");
            }
        }
    }

    public static JSONBeanUtil defaultUtil() {
        return instance;
    }
}

