/*
 * Decompiled with CFR 0.152.
 */
package org.svenson.matcher;

import org.svenson.matcher.PathMatcher;

public class AndMatcher
implements PathMatcher {
    private PathMatcher[] matchers;

    public AndMatcher(PathMatcher ... matchers) {
        this.matchers = matchers;
    }

    public boolean matches(String parsePath, Class typeHint) {
        boolean matches = true;
        for (PathMatcher matcher : this.matchers) {
            if (matcher.matches(parsePath, typeHint)) continue;
            matches = false;
            break;
        }
        return matches;
    }

    public String toString() {
        return AndMatcher.toString("AND", this.matchers);
    }

    static String toString(String name, PathMatcher[] matchers) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        sb.append(name).append('(');
        for (PathMatcher m : matchers) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(m);
            first = false;
        }
        sb.append(')');
        return sb.toString();
    }
}

