/*
 * Decompiled with CFR 0.152.
 */
package org.svenson.info;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.svenson.JSONParameter;
import org.svenson.JSONParameters;
import org.svenson.JSONProperty;
import org.svenson.JSONReference;
import org.svenson.JSONTypeHint;
import org.svenson.info.AbstractObjectSupport;
import org.svenson.info.JSONClassInfo;
import org.svenson.info.JSONPropertyInfo;
import org.svenson.info.JavaObjectPropertyInfo;
import org.svenson.info.MethodUtil;

public class JavaObjectSupport
extends AbstractObjectSupport {
    private static final String ADDER_PREFIX = "add";
    private static final String SETTER_PREFIX = "set";
    private static final String GETTER_PREFIX = "get";
    private static final String ISSER_PREFIX = "is";

    /*
     * WARNING - void declaration
     */
    @Override
    public JSONClassInfo createClassInfo(Class<?> cls) {
        HashMap<String, JavaObjectPropertyInfo> javaNameToInfo = new HashMap<String, JavaObjectPropertyInfo>();
        Constructor<?> ctor = null;
        Class ctorTypeHint = null;
        boolean isWildCard = false;
        int wildCardIndex = -1;
        Executable postConstructMethod = null;
        for (Constructor<?> constructor : cls.getConstructors()) {
            Annotation[][] parameterAnnotations = constructor.getParameterAnnotations();
            int parameterAnnotationsLength = parameterAnnotations.length;
            for (int i = 0; i < parameterAnnotationsLength; ++i) {
                Annotation[] annotations;
                for (Annotation annotation : annotations = parameterAnnotations[i]) {
                    if (annotation instanceof JSONParameter) {
                        ctor = constructor;
                    } else if (annotation instanceof JSONParameters) {
                        if (!Map.class.isAssignableFrom(constructor.getParameterTypes()[i])) {
                            throw new IllegalStateException("@JSONParameters annotation must be on a constructor map parameter");
                        }
                        ctor = constructor;
                        isWildCard = true;
                        wildCardIndex = i;
                    }
                    if (!(annotation instanceof JSONTypeHint)) continue;
                    Class<?>[] parameterTypes = constructor.getParameterTypes();
                    if (wildCardIndex != i) continue;
                    if (parameterTypes.length != 1) {
                        throw new IllegalStateException("@JSONParameters/@JSONTypeHint combination must only have one map parameter");
                    }
                    if (!Map.class.isAssignableFrom(parameterTypes[0])) {
                        throw new IllegalStateException("@JSONParameters/@JSONTypeHint combination must be on a constructor map parameter");
                    }
                    ctorTypeHint = ((JSONTypeHint)annotation).value();
                }
            }
        }
        for (Executable executable : cls.getMethods()) {
            JavaObjectPropertyInfo pair;
            String javaPropertyName;
            JSONProperty jsonProperty;
            String name = ((Method)executable).getName();
            if ((((Method)executable).getModifiers() & 1) == 0 || name.equals("getClass") || ((Method)executable).isBridge()) continue;
            if (((Method)executable).getAnnotation(PostConstruct.class) != null) {
                if (((Method)executable).getParameterTypes().length != 0) {
                    throw new IllegalStateException("@PostConstruct methods can't have parameters: " + executable);
                }
                postConstructMethod = executable;
            }
            if (name.startsWith(SETTER_PREFIX) && ((Method)executable).getParameterTypes().length == 1) {
                Class<?> paramType;
                if (!(ctor == null || (jsonProperty = ((Method)executable).getAnnotation(JSONProperty.class)) != null && jsonProperty.ignore())) {
                    throw new IllegalStateException("Classes with @JSONParameter constructors can't have setters.");
                }
                javaPropertyName = JavaObjectSupport.propertyName(name, SETTER_PREFIX.length());
                pair = (JavaObjectPropertyInfo)javaNameToInfo.get(javaPropertyName);
                if (pair != null) {
                    Method existing = pair.getSetterMethod();
                    if (existing == null || JavaObjectSupport.isOverriding((Method)executable, existing) || this.isBestMatchSetter(pair, (Method)executable)) {
                        pair.setSetterMethod((Method)executable);
                        pair.setAdderMethod(null);
                    }
                } else {
                    pair = new JavaObjectPropertyInfo(javaPropertyName, null, (Method)executable);
                    javaNameToInfo.put(javaPropertyName, pair);
                }
                Class<?>[] parameterTypes = ((Method)executable).getParameterTypes();
                if (parameterTypes.length != 1 || !(paramType = parameterTypes[0]).isArray()) continue;
                pair.setTypeHint(paramType.getComponentType());
                continue;
            }
            if (((Method)executable).getParameterTypes().length == 0 && !((Method)executable).getReturnType().equals(Void.TYPE)) {
                if (name.startsWith(GETTER_PREFIX)) {
                    String javaPropertyName2 = JavaObjectSupport.propertyName(name, GETTER_PREFIX.length());
                    JavaObjectPropertyInfo pair2 = (JavaObjectPropertyInfo)javaNameToInfo.get(javaPropertyName2);
                    if (pair2 != null) {
                        Method existing = pair2.getGetterMethod();
                        if (existing != null && !JavaObjectSupport.isOverriding((Method)executable, existing)) continue;
                        pair2.setGetterMethod((Method)executable);
                        continue;
                    }
                    javaNameToInfo.put(javaPropertyName2, new JavaObjectPropertyInfo(javaPropertyName2, (Method)executable, null));
                    continue;
                }
                if (!name.startsWith(ISSER_PREFIX)) continue;
                String javaPropertyName2 = JavaObjectSupport.propertyName(name, ISSER_PREFIX.length());
                JavaObjectPropertyInfo pair2 = (JavaObjectPropertyInfo)javaNameToInfo.get(javaPropertyName2);
                if (pair2 != null) {
                    pair2.setGetterMethod((Method)executable);
                    continue;
                }
                javaNameToInfo.put(javaPropertyName2, new JavaObjectPropertyInfo(javaPropertyName2, (Method)executable, null));
                continue;
            }
            if (!name.startsWith(ADDER_PREFIX) || ((Method)executable).getParameterTypes().length != 1) continue;
            if (!(ctor == null || (jsonProperty = ((Method)executable).getAnnotation(JSONProperty.class)) != null && jsonProperty.ignore())) {
                throw new IllegalStateException("Classes with @JSONParameter constructors can't have adders.");
            }
            javaPropertyName = JavaObjectSupport.propertyName(name, ADDER_PREFIX.length());
            pair = (JavaObjectPropertyInfo)javaNameToInfo.get(javaPropertyName);
            if (pair != null) {
                if (pair.getSetterMethod() != null) continue;
                pair.setAdderMethod((Method)executable);
                continue;
            }
            JavaObjectPropertyInfo newInfo = new JavaObjectPropertyInfo(javaPropertyName, null, null);
            newInfo.setAdderMethod((Method)executable);
            javaNameToInfo.put(javaPropertyName, newInfo);
        }
        HashMap<void, JavaObjectPropertyInfo> propertyInfos = new HashMap<void, JavaObjectPropertyInfo>(javaNameToInfo.size());
        for (Map.Entry e : javaNameToInfo.entrySet()) {
            JSONTypeHint typeHintAnno;
            void var11_19;
            String string = (String)e.getKey();
            JavaObjectPropertyInfo propertyInfo = (JavaObjectPropertyInfo)e.getValue();
            Method getterMethod = propertyInfo.getGetterMethod();
            Method setterMethod = propertyInfo.getSetterMethod();
            Method adderMethod = propertyInfo.getAdderMethod();
            JSONProperty jsonProperty = MethodUtil.getAnnotation(JSONProperty.class, getterMethod, setterMethod);
            if (jsonProperty != null) {
                if (jsonProperty.value().length() > 0) {
                    String string2 = jsonProperty.value();
                }
                propertyInfo.setIgnore(jsonProperty.ignore());
                propertyInfo.setIgnoreIfNull(jsonProperty.ignoreIfNull());
                propertyInfo.setReadOnly(jsonProperty.readOnly());
                propertyInfo.setPriority(jsonProperty.priority());
            }
            propertyInfo.setJsonName((String)var11_19);
            JSONReference refAnno = MethodUtil.getAnnotation(JSONReference.class, getterMethod, setterMethod);
            if (refAnno != null) {
                propertyInfo.setLinkIdProperty(refAnno.idProperty());
            }
            if ((typeHintAnno = MethodUtil.getAnnotation(JSONTypeHint.class, getterMethod, setterMethod)) != null) {
                propertyInfo.setTypeHint(typeHintAnno.value());
            } else if (adderMethod != null) {
                propertyInfo.setTypeHint(adderMethod.getParameterTypes()[0]);
            }
            propertyInfos.put(var11_19, propertyInfo);
        }
        return new JSONClassInfo(cls, (Map<String, ? extends JSONPropertyInfo>)propertyInfos, ctor, ctorTypeHint, (Method)postConstructMethod);
    }

    private boolean isBestMatchSetter(JavaObjectPropertyInfo pair, Method m) {
        if (pair.getGetterMethod() != null) {
            if (pair.getGetterMethod().getReturnType().equals(m.getParameterTypes()[0])) {
                return true;
            }
        } else {
            try {
                Method getter = m.getDeclaringClass().getMethod(this.toGetterName(pair.getJavaPropertyName()), new Class[0]);
                if (getter.getReturnType().equals(m.getParameterTypes()[0])) {
                    return true;
                }
            }
            catch (NoSuchMethodException e) {
                return true;
            }
        }
        return pair.getSetterMethod() == null;
    }

    private String toGetterName(String javaPropertyName) {
        StringBuilder methodName = new StringBuilder();
        methodName.append(GETTER_PREFIX).append(javaPropertyName);
        int firstPropNameLetter = GETTER_PREFIX.length();
        methodName.setCharAt(firstPropNameLetter, Character.toUpperCase(methodName.charAt(firstPropNameLetter)));
        return methodName.toString();
    }

    static boolean isOverriding(Method a, Method b) {
        Class<?> superClass;
        if (!a.getParameterTypes().equals(b.getParameterTypes())) {
            return false;
        }
        if (b.getDeclaringClass() == null) {
            return true;
        }
        Class<?> cls = a.getDeclaringClass();
        while ((superClass = cls.getSuperclass()) != null) {
            cls = superClass;
            if (!cls.equals(b)) continue;
            return true;
        }
        return false;
    }
}

