/*
 * Decompiled with CFR 0.152.
 */
package org.svenson.info;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.svenson.JSONParseException;
import org.svenson.SvensonRuntimeException;
import org.svenson.converter.JSONConverter;
import org.svenson.converter.TypeConverter;
import org.svenson.converter.TypeConverterRepository;
import org.svenson.info.JSONPropertyInfo;
import org.svenson.info.MethodUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaObjectPropertyInfo
implements JSONPropertyInfo {
    private Method getterMethod;
    private Method setterMethod;
    private Method adderMethod;
    private int ctorIndex = -1;
    private boolean ignore;
    private boolean ignoreIfNull;
    private boolean readOnly;
    private String javaPropertyName;
    private Class<?> typeHint;
    private String jsonName;
    private String linkIdProperty;
    private int priority = 0;
    private Constructor<?> constructor;

    public JavaObjectPropertyInfo(String javaPropertyName, Method getterMethod, Method setterMethod) {
        this.javaPropertyName = javaPropertyName;
        this.getterMethod = getterMethod;
        this.setterMethod = setterMethod;
    }

    public Method getSetterMethod() {
        return this.setterMethod;
    }

    public void setSetterMethod(Method setterMethod) {
        this.setterMethod = setterMethod;
    }

    public Method getGetterMethod() {
        return this.getterMethod;
    }

    public void setGetterMethod(Method getterMethod) {
        this.getterMethod = getterMethod;
    }

    @Override
    public boolean isIgnore() {
        return this.ignore;
    }

    public void setIgnore(boolean ignore) {
        this.ignore = ignore;
    }

    @Override
    public boolean isIgnoreIfNull() {
        return this.ignoreIfNull;
    }

    public void setIgnoreIfNull(boolean ignoreIfNull) {
        this.ignoreIfNull = ignoreIfNull;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public String getJavaPropertyName() {
        return this.javaPropertyName;
    }

    public void setJavaPropertyName(String javaPropertyName) {
        this.javaPropertyName = javaPropertyName;
    }

    @Override
    public boolean isLinkedProperty() {
        return this.linkIdProperty != null;
    }

    @Override
    public String getLinkIdProperty() {
        return this.linkIdProperty;
    }

    public void setLinkIdProperty(String linkIdProperty) {
        this.linkIdProperty = linkIdProperty;
    }

    public Class<Object> getTypeOfProperty() {
        if (this.setterMethod != null) {
            return this.setterMethod.getParameterTypes()[0];
        }
        return null;
    }

    @Override
    public boolean isWriteable() {
        return this.setterMethod != null;
    }

    @Override
    public boolean isReadable() {
        return this.getterMethod != null;
    }

    @Override
    public Class<Object> getTypeHint() {
        return this.typeHint;
    }

    public void setTypeHint(Class<?> typeHint) {
        this.typeHint = typeHint;
    }

    public Method getAdderMethod() {
        return this.adderMethod;
    }

    public void setAdderMethod(Method adderMethod) {
        this.adderMethod = adderMethod;
    }

    @Override
    public String getJsonName() {
        return this.jsonName;
    }

    public void setJsonName(String jsonName) {
        this.jsonName = jsonName;
    }

    @Override
    public Object getProperty(Object target) {
        if (this.getterMethod == null) {
            throw new JSONParseException("Property '" + this.getJavaPropertyName() + "' in " + target.getClass() + " is not readable.");
        }
        try {
            return this.getterMethod.invoke(target, new Object[0]);
        }
        catch (Throwable t) {
            throw new SvensonRuntimeException("Error getting value from target " + target + " using " + this.getterMethod, t);
        }
    }

    @Override
    public void setProperty(Object target, Object value) {
        if (this.setterMethod == null) {
            throw new JSONParseException("Property '" + this.getJavaPropertyName() + "' in " + target.getClass() + " is not writable.");
        }
        try {
            this.setterMethod.invoke(target, value);
        }
        catch (Throwable t) {
            throw new SvensonRuntimeException("Error setting value " + value + " on target " + target + " using " + this.setterMethod, t);
        }
    }

    public String toString() {
        return super.toString() + " adderMethod=" + this.adderMethod + ", getterMethod=" + this.getterMethod + ", ignore=" + this.ignore + ", ignoreIfNull=" + this.ignoreIfNull + ", javaPropertyName=" + this.javaPropertyName + ", jsonName=" + this.jsonName + ", linkIdProperty=" + this.linkIdProperty + ", readOnly=" + this.readOnly + ", setterMethod=" + this.setterMethod + ", typeHint=" + this.typeHint;
    }

    @Override
    public TypeConverter getTypeConverter(TypeConverterRepository typeConverterRepository) {
        JSONConverter converterAnno;
        if (typeConverterRepository != null && (converterAnno = MethodUtil.getAnnotation(JSONConverter.class, this.getterMethod, this.setterMethod)) != null) {
            TypeConverter typeConverter = null;
            typeConverter = converterAnno.name().length() == 0 ? typeConverterRepository.getConverterByType(converterAnno.type()) : typeConverterRepository.getConverterById(converterAnno.name());
            return typeConverter;
        }
        return null;
    }

    @Override
    public boolean canAdd() {
        return this.adderMethod != null;
    }

    @Override
    public void add(Object target, Object value) {
        try {
            this.adderMethod.invoke(target, value);
        }
        catch (Throwable t) {
            throw new SvensonRuntimeException("Error adding value " + value + " to target " + target + " using " + this.adderMethod, t);
        }
    }

    @Override
    public Class<Object> getType() {
        Class<Object> type;
        if (this.getterMethod != null) {
            type = this.getterMethod.getReturnType();
        } else if (this.setterMethod != null) {
            type = this.setterMethod.getParameterTypes()[0];
        } else if (this.adderMethod != null) {
            type = this.adderMethod.getParameterTypes()[0];
        } else {
            throw new IllegalStateException("No method!?");
        }
        return type;
    }

    public void setPriority(int order) {
        this.priority = order;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public int getCtorIndex() {
        return this.ctorIndex;
    }

    public void setCtorIndex(int ctorIndex) {
        this.ctorIndex = ctorIndex;
    }

    public void setConstructor(Constructor<?> constructor) {
        this.constructor = constructor;
    }

    public Constructor<?> getConstructor() {
        return this.constructor;
    }
}

