/*
 * Decompiled with CFR 0.152.
 */
package org.svenson.info;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.svenson.JSONPropertyOrder;
import org.svenson.info.ConstructorInfo;
import org.svenson.info.JSONPropertyInfo;
import org.svenson.info.JSONPropertyPriorityComparator;
import org.svenson.util.ExceptionWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONClassInfo {
    private final ConstructorInfo constructorInfo;
    private final Class<?> cls;
    protected final Map<String, JSONPropertyInfo> propertyInfos;
    private final List<JSONPropertyInfo> sortedPropertyInfos;
    private final Method postConstructMethod;

    public JSONClassInfo(Class<?> cls, Map<String, ? extends JSONPropertyInfo> propertyInfos, Constructor<?> ctor, Class<?> ctorTypeHint, Method postConstructMethod) {
        if (cls == null) {
            throw new IllegalArgumentException("Class can't be null.");
        }
        if (propertyInfos == null) {
            throw new IllegalArgumentException("Infos can't be null.");
        }
        this.cls = cls;
        this.constructorInfo = ctor != null ? new ConstructorInfo(ctor, ctorTypeHint) : null;
        this.propertyInfos = propertyInfos;
        ArrayList<? extends JSONPropertyInfo> copy = new ArrayList<JSONPropertyInfo>(propertyInfos.values());
        JSONPropertyOrder orderAnno = cls.getAnnotation(JSONPropertyOrder.class);
        Class comparatorClass = JSONPropertyPriorityComparator.class;
        if (orderAnno != null) {
            comparatorClass = orderAnno.value();
        }
        try {
            Collections.sort(copy, (Comparator)comparatorClass.newInstance());
        }
        catch (InstantiationException e) {
            throw ExceptionWrapper.wrap(e);
        }
        catch (IllegalAccessException e) {
            throw ExceptionWrapper.wrap(e);
        }
        this.sortedPropertyInfos = copy;
        this.postConstructMethod = postConstructMethod;
    }

    public JSONPropertyInfo getPropertyInfo(String jsonPropertyName) {
        return this.propertyInfos.get(jsonPropertyName);
    }

    public Set<String> getPropertyNames() {
        return this.propertyInfos.keySet();
    }

    public List<JSONPropertyInfo> getPropertyInfos() {
        return this.sortedPropertyInfos;
    }

    public String toString() {
        return super.toString() + " cls = " + this.cls + ", propertyInfos = " + this.propertyInfos;
    }

    public ConstructorInfo getConstructorInfo() {
        return this.constructorInfo;
    }

    public Method getPostConstructMethod() {
        return this.postConstructMethod;
    }
}

