/*
 * Decompiled with CFR 0.152.
 */
package org.svenson.info;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.svenson.JSONParameter;
import org.svenson.JSONParameters;
import org.svenson.JSONTypeHint;
import org.svenson.info.ParameterInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstructorInfo {
    private final Constructor constructor;
    private final Map<String, ParameterInfo> indexMap;
    private final Class<?> ctorTypeHint;
    private final int wildCardArgsIndex;

    public ConstructorInfo(Constructor constructor, Class<?> ctorTypeHint) {
        this.constructor = constructor;
        HashMap<String, ParameterInfo> map = new HashMap<String, ParameterInfo>();
        Annotation[][] parameterAnnotations = constructor.getParameterAnnotations();
        int wildCardArgsIndex = -1;
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            Annotation[] annotations = parameterAnnotations[i];
            String name = null;
            Class typeHint = null;
            for (Annotation annotation : annotations) {
                if (annotation instanceof JSONParameter) {
                    name = ((JSONParameter)annotation).value();
                }
                if (annotation instanceof JSONTypeHint) {
                    typeHint = ((JSONTypeHint)annotation).value();
                }
                if (!(annotation instanceof JSONParameters)) continue;
                wildCardArgsIndex = i;
            }
            if (name == null) continue;
            map.put(name, new ParameterInfo(i, typeHint));
        }
        this.ctorTypeHint = ctorTypeHint;
        this.indexMap = Collections.unmodifiableMap(map);
        this.wildCardArgsIndex = wildCardArgsIndex;
    }

    public ParameterInfo getParameterInfo(String name) {
        return this.indexMap.get(name);
    }

    public Constructor<?> getConstructor() {
        return this.constructor;
    }

    public Set<String> getJSONPropertyNames() {
        return this.indexMap.keySet();
    }

    public Class<?> getCtorTypeHint() {
        return this.ctorTypeHint;
    }

    public int getWildCardArgsIndex() {
        return this.wildCardArgsIndex;
    }
}

