/*
 * Decompiled with CFR 0.152.
 */
package org.svenson.converter;

import java.util.HashMap;
import java.util.Map;
import org.svenson.converter.TypeConverter;
import org.svenson.converter.TypeConverterRepository;
import org.svenson.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTypeConverterRepository
implements TypeConverterRepository {
    private Map<String, TypeConverter> converters = new HashMap<String, TypeConverter>();

    public void addTypeConverter(TypeConverter converter) {
        String id = this.createId();
        this.addTypeConverter(id, converter);
    }

    public void addTypeConverter(String id, TypeConverter converter) {
        this.converters.put(id, converter);
    }

    private String createId() {
        return "__converter-" + this.converters.size();
    }

    @Override
    public <T extends TypeConverter> T getConverterByType(Class<T> t) {
        TypeConverter typeConverter = null;
        for (TypeConverter tc : this.converters.values()) {
            if (!t.isAssignableFrom(tc.getClass())) continue;
            if (typeConverter != null) {
                throw new IllegalStateException("Found more than one instances of " + t);
            }
            typeConverter = tc;
        }
        return (T)typeConverter;
    }

    @Override
    public TypeConverter getConverterById(String id) {
        return this.converters.get(id);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof DefaultTypeConverterRepository) {
            return Util.equals(this.converters, ((DefaultTypeConverterRepository)obj).converters);
        }
        return false;
    }

    public int hashCode() {
        return 17 + 37 * this.converters.hashCode();
    }
}

