/*
 * Decompiled with CFR 0.152.
 */
package org.svenson;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.ConvertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.svenson.DelayedConstructor;
import org.svenson.DynamicProperties;
import org.svenson.JSONParseException;
import org.svenson.ObjectFactory;
import org.svenson.SvensonRuntimeException;
import org.svenson.TypeAnalyzer;
import org.svenson.TypeMapper;
import org.svenson.converter.DefaultTypeConverterRepository;
import org.svenson.converter.TypeConverter;
import org.svenson.info.ConstructorInfo;
import org.svenson.info.JSONClassInfo;
import org.svenson.info.JSONPropertyInfo;
import org.svenson.info.JavaObjectSupport;
import org.svenson.info.ObjectSupport;
import org.svenson.info.ParameterInfo;
import org.svenson.matcher.EqualsPathMatcher;
import org.svenson.matcher.PathMatcher;
import org.svenson.tokenize.JSONCharacterSource;
import org.svenson.tokenize.JSONTokenizer;
import org.svenson.tokenize.Token;
import org.svenson.tokenize.TokenType;
import org.svenson.util.ExceptionWrapper;
import org.svenson.util.TokenUtil;

public class JSONParser {
    protected static Logger log = LoggerFactory.getLogger(JSONParser.class);
    private static final JSONParser defaultJSONParser = new JSONParser();
    private Map<PathMatcher, Class> typeHints = new HashMap<PathMatcher, Class>();
    private TypeMapper typeMapper;
    private Map<Class, Class> interfaceMappings;
    private List<ObjectFactory> objectFactories = new ArrayList<ObjectFactory>();
    private boolean allowSingleQuotes;
    private Map<Class, TypeConverter> typeConvertersByClass;
    private ObjectSupport objectSupport;
    private DefaultTypeConverterRepository typeConverterRepository;

    public JSONParser() {
        this.interfaceMappings = new HashMap<Class, Class>();
        this.interfaceMappings.put(Collection.class, ArrayList.class);
        this.interfaceMappings.put(Set.class, HashSet.class);
        this.interfaceMappings.put(List.class, ArrayList.class);
        this.interfaceMappings.put(Map.class, HashMap.class);
        this.objectSupport = new JavaObjectSupport();
    }

    public void setObjectSupport(ObjectSupport objectSupport) {
        this.objectSupport = objectSupport;
    }

    public JSONParser(JSONParser src) {
        this();
        if (src != null) {
            this.typeHints = new HashMap<PathMatcher, Class>(src.typeHints);
            this.typeMapper = src.typeMapper;
            this.interfaceMappings = new HashMap<Class, Class>(src.interfaceMappings);
            this.objectFactories = new ArrayList<ObjectFactory>(src.objectFactories);
            this.allowSingleQuotes = src.allowSingleQuotes;
            if (src.typeConvertersByClass != null) {
                this.typeConvertersByClass = new HashMap<Class, TypeConverter>(src.typeConvertersByClass);
            }
            this.objectSupport = src.objectSupport;
        }
    }

    public static JSONParser defaultJSONParser() {
        return defaultJSONParser;
    }

    public void setTypeMapper(TypeMapper typeMapper) {
        this.typeMapper = typeMapper;
    }

    public void registerTypeConversion(Class cls, TypeConverter converter) {
        if (this.typeConvertersByClass == null) {
            this.typeConvertersByClass = new HashMap<Class, TypeConverter>();
        }
        this.typeConvertersByClass.put(cls, converter);
    }

    public void setTypeHints(Map<String, Class> typeHints) {
        this.typeHints = new HashMap<PathMatcher, Class>();
        for (Map.Entry<String, Class> e : typeHints.entrySet()) {
            this.typeHints.put(new EqualsPathMatcher(e.getKey()), e.getValue());
        }
    }

    public void setInterfaceMappings(Map<Class, Class> interfaceMappings) {
        for (Map.Entry<Class, Class> e : interfaceMappings.entrySet()) {
            Class iface = e.getKey();
            Class cls = e.getValue();
            if (!iface.isInterface()) {
                throw new IllegalArgumentException("The key " + iface + " must be an interface that is mapped to a class type.");
            }
            if (cls.isInterface()) {
                throw new IllegalArgumentException("The value " + cls + " must be a class type.");
            }
            if (iface.isAssignableFrom(cls)) continue;
            throw new IllegalArgumentException("The class " + cls + " does not implement the interface " + iface);
        }
        this.interfaceMappings = interfaceMappings;
    }

    public void addObjectFactory(ObjectFactory objectFactory) {
        if (objectFactory == null) {
            throw new IllegalArgumentException("objectFactory can't be null");
        }
        this.objectFactories.add(objectFactory);
    }

    public void addTypeHint(String key, Class typeHint) {
        this.typeHints.put(new EqualsPathMatcher(key), typeHint);
    }

    public void addTypeHint(PathMatcher pathMatcher, Class typeHint) {
        this.typeHints.put(pathMatcher, typeHint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object parse(String json) {
        JSONTokenizer tokenizer = new JSONTokenizer(json, this.allowSingleQuotes);
        try {
            Object object = this.parse(tokenizer);
            return object;
        }
        finally {
            tokenizer.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object parse(JSONCharacterSource source) {
        JSONTokenizer tokenizer = new JSONTokenizer(source, this.allowSingleQuotes);
        try {
            Object object = this.parse(tokenizer);
            return object;
        }
        finally {
            tokenizer.destroy();
        }
    }

    private Object parse(JSONTokenizer tokenizer) {
        Token token = tokenizer.peekToken();
        if (token.isType(TokenType.BRACKET_OPEN)) {
            return this.parse(ArrayList.class, tokenizer);
        }
        if (token.isType(TokenType.BRACE_OPEN)) {
            Class typeHint = this.getTypeHint("", tokenizer, null, true);
            if (typeHint != null) {
                return this.parse(typeHint, tokenizer);
            }
            return this.parse(HashMap.class, tokenizer);
        }
        if (token.isType(TokenType.NULL) || token.isType(TokenType.FALSE) || token.isType(TokenType.TRUE) || token.isType(TokenType.INTEGER) || token.isType(TokenType.DECIMAL) || token.isType(TokenType.STRING)) {
            return token.value();
        }
        throw new JSONParseException("Invalid start token " + token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T parse(Class<T> targetType, String json) {
        if (targetType == null) {
            throw new IllegalArgumentException("target type cannot be null");
        }
        if (json == null) {
            throw new IllegalArgumentException("json string cannot be null");
        }
        JSONTokenizer tokenizer = new JSONTokenizer(json, this.allowSingleQuotes);
        try {
            T t = this.parse(targetType, tokenizer);
            return t;
        }
        finally {
            tokenizer.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T parse(Class<T> targetType, JSONCharacterSource source) {
        if (targetType == null) {
            throw new IllegalArgumentException("target type cannot be null");
        }
        if (source == null) {
            throw new IllegalArgumentException("character source cannot be null");
        }
        JSONTokenizer tokenizer = new JSONTokenizer(source, this.allowSingleQuotes);
        try {
            T t = this.parse(targetType, tokenizer);
            return t;
        }
        finally {
            tokenizer.destroy();
        }
    }

    private <T> T parse(Class<T> targetType, JSONTokenizer tokenizer) {
        try {
            Object t;
            Token token = tokenizer.next();
            TokenType type = token.type();
            if (type == TokenType.BRACE_OPEN) {
                Method postConstructMethod;
                Class typeHint = this.getTypeHint("", tokenizer, targetType, true);
                if (typeHint != null) {
                    targetType = typeHint;
                }
                JSONClassInfo newClassInfo = TypeAnalyzer.getClassInfo(this.objectSupport, targetType);
                t = this.createNewTargetInstance(targetType, newClassInfo, true);
                this.parseObjectInto(new ParseContext(t, null, newClassInfo), tokenizer);
                t = DelayedConstructor.unwrap(t);
                if (newClassInfo != null && (postConstructMethod = newClassInfo.getPostConstructMethod()) != null) {
                    postConstructMethod.invoke(t, new Object[0]);
                }
            } else if (type == TokenType.BRACKET_OPEN) {
                Method postConstructMethod;
                JSONClassInfo newClassInfo = TypeAnalyzer.getClassInfo(this.objectSupport, targetType);
                t = this.createNewTargetInstance(targetType, newClassInfo, false);
                this.parseArrayInto(new ParseContext(t, null, newClassInfo), tokenizer);
                if (newClassInfo != null && (postConstructMethod = newClassInfo.getPostConstructMethod()) != null) {
                    postConstructMethod.invoke(t, new Object[0]);
                }
            } else {
                if (type == TokenType.STRING && Enum.class.isAssignableFrom(targetType)) {
                    return Enum.valueOf(targetType, (String)token.value());
                }
                if (type == TokenType.NULL) {
                    return null;
                }
                throw new JSONParseException("unexpected token " + token);
            }
            return (T)t;
        }
        catch (InstantiationException e) {
            throw ExceptionWrapper.wrap(e);
        }
        catch (IllegalAccessException e) {
            throw ExceptionWrapper.wrap(e);
        }
        catch (InvocationTargetException e) {
            throw ExceptionWrapper.wrap(e);
        }
        catch (NoSuchMethodException e) {
            throw ExceptionWrapper.wrap(e);
        }
    }

    public void setAllowSingleQuotes(boolean allowSingleQuotes) {
        this.allowSingleQuotes = allowSingleQuotes;
    }

    private void parseArrayInto(ParseContext cx, JSONTokenizer tokenizer) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Token valueToken;
        TokenType valueType;
        boolean containerIsCollection = Collection.class.isAssignableFrom(cx.target.getClass());
        boolean first = true;
        while ((valueType = (valueToken = tokenizer.next()).type()) != TokenType.BRACKET_CLOSE) {
            Object value;
            if (!first) {
                valueToken.expect(TokenType.COMMA);
                valueToken = tokenizer.next();
                valueType = valueToken.type();
            }
            Class typeHint = this.getTypeHint(cx, cx.getParsePathInfo("[]"), tokenizer, "[]", false, valueType.isPrimitive());
            if (valueType.isPrimitive()) {
                value = valueToken.value();
                if (typeHint != null) {
                    value = JSONParser.convertValueTo(value, typeHint, this.typeConvertersByClass);
                }
            } else {
                Method postConstructMethod;
                JSONClassInfo classInfo;
                Object newTarget = null;
                if (valueType == TokenType.BRACE_OPEN) {
                    classInfo = TypeAnalyzer.getClassInfo(this.objectSupport, typeHint);
                    newTarget = this.createNewTargetInstance(typeHint, classInfo, true);
                    this.parseObjectInto(cx.push(newTarget, null, "[]", classInfo), tokenizer);
                    newTarget = DelayedConstructor.unwrap(newTarget);
                    if (classInfo != null && (postConstructMethod = classInfo.getPostConstructMethod()) != null) {
                        postConstructMethod.invoke(newTarget, new Object[0]);
                    }
                } else if (valueType == TokenType.BRACKET_OPEN) {
                    classInfo = TypeAnalyzer.getClassInfo(this.objectSupport, typeHint);
                    newTarget = this.createNewTargetInstance(typeHint, classInfo, false);
                    this.parseArrayInto(cx.push(newTarget, null, "[]", classInfo), tokenizer);
                    newTarget = DelayedConstructor.unwrap(newTarget);
                    if (classInfo != null && (postConstructMethod = classInfo.getPostConstructMethod()) != null) {
                        postConstructMethod.invoke(newTarget, new Object[0]);
                    }
                } else {
                    throw new JSONParseException("Unexpected token " + valueToken);
                }
                value = newTarget;
            }
            if (!containerIsCollection) {
                throw new JSONParseException("Cannot add value " + value + " to " + cx.target + " ( " + cx.target.getClass() + " )");
            }
            ((Collection)cx.target).add(value);
            first = false;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseObjectInto(ParseContext cx, JSONTokenizer tokenizer) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Token key;
        boolean containerIsMap = Map.class.isAssignableFrom(cx.target.getClass());
        boolean containerIsDynAttrs = cx.target instanceof DynamicProperties;
        boolean first = true;
        while ((key = first ? tokenizer.expectNext(TokenType.STRING, TokenType.BRACE_CLOSE) : tokenizer.expectNext(TokenType.COMMA, TokenType.BRACE_CLOSE)).type() != TokenType.BRACE_CLOSE) {
            Object value;
            TypeConverter typeConverter;
            if (!first) {
                key = tokenizer.expectNext(TokenType.STRING);
            }
            first = false;
            String jsonName = (String)key.value();
            if (jsonName.length() == 0) {
                throw new JSONParseException("Invalid empty property name");
            }
            String name = null;
            tokenizer.expectNext(TokenType.COLON);
            Token valueToken = tokenizer.next();
            TokenType valueType = valueToken.type();
            boolean isProperty = false;
            boolean isIgnoredOnParse = false;
            JSONClassInfo classInfo = null;
            JSONPropertyInfo propertyInfo = null;
            if (!containerIsMap) {
                classInfo = cx.getClassInfo();
                propertyInfo = classInfo.getPropertyInfo(jsonName);
                if (propertyInfo != null) {
                    name = propertyInfo.getJavaPropertyName();
                }
                if (propertyInfo == null && !containerIsDynAttrs) {
                    log.warn("Property '{}' will be ignored as it was not found in {}", (Object)jsonName, cx.target.getClass());
                    if (valueType == TokenType.BRACE_OPEN) {
                        TokenUtil.skipObjectValue(tokenizer);
                        continue;
                    }
                    if (valueType != TokenType.BRACKET_OPEN) continue;
                    TokenUtil.skipArrayValue(tokenizer);
                    continue;
                }
                isProperty = false;
                isIgnoredOnParse = false;
                if (name != null) {
                    boolean writeable = propertyInfo.isWriteable();
                    boolean bl = isIgnoredOnParse = !writeable && propertyInfo.isReadOnly();
                    if (isIgnoredOnParse) {
                        if (valueType == TokenType.BRACE_OPEN) {
                            TokenUtil.skipObjectValue(tokenizer);
                            continue;
                        }
                        if (valueType == TokenType.BRACKET_OPEN) {
                            TokenUtil.skipArrayValue(tokenizer);
                            continue;
                        }
                    }
                    if (propertyInfo.isLinkedProperty()) {
                        isIgnoredOnParse = true;
                    }
                    isProperty = writeable || isIgnoredOnParse;
                }
            }
            TypeConverter typeConverter2 = typeConverter = propertyInfo == null ? null : propertyInfo.getTypeConverter(this.typeConverterRepository);
            if (!(isProperty || containerIsMap || containerIsDynAttrs || propertyInfo != null && propertyInfo.canAdd())) {
                throw new JSONParseException("Cannot set property " + jsonName + " on " + cx.target.getClass());
            }
            if (name == null) {
                name = jsonName;
            }
            Class typeHint = this.getTypeHint(cx, cx.getParsePathInfo(jsonName), tokenizer, jsonName, isProperty, valueType.isPrimitive());
            if (valueType.isPrimitive()) {
                value = valueToken.value();
            } else {
                Object postConstructMethod;
                JSONClassInfo newClassInfo;
                Class ctorTypeHint;
                ParameterInfo parameterInfo;
                Object newTarget = null;
                if (valueType == TokenType.BRACE_OPEN) {
                    void var19_25;
                    Object var19_21 = null;
                    if (cx.target instanceof DelayedConstructor) {
                        Class<?> parameterType;
                        DelayedConstructor target = (DelayedConstructor)cx.target;
                        ConstructorInfo constructorInfo = target.getConstructorInfo();
                        parameterInfo = constructorInfo.getParameterInfo(name);
                        if (parameterInfo != null) {
                            parameterType = constructorInfo.getConstructor().getParameterTypes()[parameterInfo.getIndex()];
                            ctorTypeHint = parameterInfo.getTypeHint();
                        } else {
                            int wildCardArgsIndex = target.getWildCardArgsIndex();
                            if (wildCardArgsIndex >= 0) {
                                parameterType = constructorInfo.getConstructor().getParameterTypes()[wildCardArgsIndex];
                                ctorTypeHint = constructorInfo.getCtorTypeHint();
                            } else {
                                parameterType = null;
                                ctorTypeHint = null;
                            }
                        }
                        if (ctorTypeHint != null) {
                            if (parameterInfo != null && (Collection.class.isAssignableFrom(parameterType) || Map.class.isAssignableFrom(parameterType))) {
                                Class clazz = ctorTypeHint;
                            } else {
                                typeHint = this.getTypeHint(cx.info, tokenizer, ctorTypeHint, true);
                            }
                        } else {
                            typeHint = parameterType;
                        }
                    }
                    if (isProperty && propertyInfo != null && propertyInfo.getTypeHint() != null) {
                        Class<Object> clazz = typeHint != null && !Map.class.isAssignableFrom(typeHint) ? null : propertyInfo.getTypeHint();
                    }
                    newClassInfo = TypeAnalyzer.getClassInfo(this.objectSupport, typeHint);
                    newTarget = this.createNewTargetInstance(typeHint, newClassInfo, true);
                    try {
                        tokenizer.startRecording();
                        this.parseObjectInto(cx.push(newTarget, (Class)var19_25, "." + name, newClassInfo), tokenizer);
                    }
                    catch (ConversionException | JSONParseException e) {
                        tokenizer.pushBackAfterOrToFirstRecorded(valueToken);
                        newTarget = this.createNewTargetInstance(null, null, true);
                        this.parseObjectInto(cx.push(newTarget, (Class)var19_25, "." + name, newClassInfo), tokenizer);
                    }
                    newTarget = DelayedConstructor.unwrap(newTarget);
                    if (newClassInfo != null && (postConstructMethod = newClassInfo.getPostConstructMethod()) != null) {
                        ((Method)postConstructMethod).invoke(newTarget, new Object[0]);
                    }
                } else {
                    Method postConstructMethod2;
                    void var19_29;
                    if (valueType != TokenType.BRACKET_OPEN) throw new JSONParseException("Unexpected token " + valueToken);
                    if (propertyInfo != null && propertyInfo.canAdd()) {
                        ArrayList arrayList = new ArrayList();
                        newClassInfo = TypeAnalyzer.getClassInfo(this.objectSupport, arrayList.getClass());
                        this.parseArrayInto(cx.push(arrayList, propertyInfo.getTypeHint(), "." + name, newClassInfo), tokenizer);
                        postConstructMethod = arrayList.iterator();
                        while (postConstructMethod.hasNext()) {
                            Object o = postConstructMethod.next();
                            o = DelayedConstructor.unwrap(o);
                            propertyInfo.add(cx.target, o);
                        }
                        continue;
                    }
                    if (!isProperty && !containerIsMap && !containerIsDynAttrs) throw new JSONParseException("Cannot set array to property " + name + " on " + cx.target);
                    Class<Object> clazz = typeHint;
                    if (isProperty && typeConverter != null && !List.class.isAssignableFrom(clazz)) {
                        Class<List> clazz2 = List.class;
                    }
                    newClassInfo = TypeAnalyzer.getClassInfo(this.objectSupport, var19_29);
                    newTarget = this.createNewTargetInstance((Class)var19_29, newClassInfo, false);
                    Class memberType = null;
                    if (propertyInfo != null) {
                        memberType = propertyInfo.getTypeHint();
                    }
                    if (cx.target instanceof DelayedConstructor && (parameterInfo = ((DelayedConstructor)cx.target).getConstructorInfo().getParameterInfo(name)) != null && (ctorTypeHint = parameterInfo.getTypeHint()) != null) {
                        memberType = ctorTypeHint;
                    }
                    try {
                        tokenizer.startRecording();
                        this.parseArrayInto(cx.push(newTarget, memberType, "." + name, newClassInfo), tokenizer);
                    }
                    catch (JSONParseException e) {
                        tokenizer.pushBackAfterOrToFirstRecorded(valueToken);
                        newTarget = this.createNewTargetInstance(null, null, false);
                        this.parseArrayInto(cx.push(newTarget, memberType, "." + name, newClassInfo), tokenizer);
                    }
                    newTarget = DelayedConstructor.unwrap(newTarget);
                    if (newClassInfo != null && (postConstructMethod2 = newClassInfo.getPostConstructMethod()) != null) {
                        postConstructMethod2.invoke(newTarget, new Object[0]);
                    }
                }
                value = newTarget;
            }
            if (typeConverter != null && !isIgnoredOnParse) {
                value = typeConverter.fromJSON(value);
            }
            if (typeHint == null && propertyInfo != null && isProperty) {
                typeHint = propertyInfo.getType();
            }
            if (typeHint != null && !isIgnoredOnParse) {
                value = JSONParser.convertValueTo(value, typeHint, this.typeConvertersByClass);
            }
            if (isProperty) {
                if (isIgnoredOnParse) continue;
                propertyInfo.setProperty(cx.target, value);
                continue;
            }
            if (containerIsMap) {
                ((Map)cx.target).put(name, value);
                continue;
            }
            if (!containerIsDynAttrs) throw new JSONParseException("Cannot set property " + name + " on " + cx.target);
            ((DynamicProperties)cx.target).setProperty(name, value);
        }
    }

    private Class getReplacementForKnownInterface(Class type) {
        if (type != null && type.isInterface()) {
            int leastTypeDistance = Integer.MAX_VALUE;
            Class best = null;
            for (Map.Entry<Class, Class> e : this.interfaceMappings.entrySet()) {
                Class curInterface = e.getKey();
                if (!type.isAssignableFrom(curInterface)) continue;
                if (type.getName().equals(curInterface.getName())) {
                    return e.getValue();
                }
                int distance = JSONParser.getTypeDistance(type, curInterface, 1);
                if (distance >= leastTypeDistance) continue;
                leastTypeDistance = distance;
                best = curInterface;
            }
            if (best == null) {
                throw new IllegalArgumentException("No Mapping found for " + type + ". cannot instantiate interfaces ");
            }
            return best;
        }
        return null;
    }

    static Integer getTypeDistance(Class type, Class ifaceClass, int dist) {
        for (Class<?> cls : ifaceClass.getInterfaces()) {
            if (type.getName().equals(cls.getName())) {
                return dist;
            }
            Integer d2 = JSONParser.getTypeDistance(type, cls, dist + 1);
            if (d2 == null) continue;
            return d2;
        }
        return null;
    }

    static Object convertValueTo(Object value, Class targetClass, Map<Class, TypeConverter> typeConvertersByClass) {
        if (targetClass == null) {
            throw new IllegalArgumentException("target class is null");
        }
        if (value == null) {
            return null;
        }
        if (targetClass.equals(Object.class)) {
            return value;
        }
        AbstractSet convertedValue = null;
        if (targetClass.isAssignableFrom(value.getClass())) {
            convertedValue = value;
        } else if (value instanceof String && Enum.class.isAssignableFrom(targetClass)) {
            convertedValue = Enum.valueOf(targetClass, (String)value);
        } else {
            TypeConverter typeConverter = null;
            if (typeConvertersByClass != null) {
                typeConverter = typeConvertersByClass.get(targetClass);
            }
            if (typeConverter != null) {
                convertedValue = typeConverter.fromJSON(value);
            } else if (List.class.isInstance(value)) {
                List list = (List)value;
                if (targetClass.isArray()) {
                    convertedValue = Array.newInstance(targetClass.getComponentType(), list.size());
                    int idx = 0;
                    for (Object o : list) {
                        Array.set(convertedValue, idx++, o);
                    }
                } else if (targetClass.isAssignableFrom(HashSet.class)) {
                    convertedValue = new HashSet(list);
                } else if (targetClass.isAssignableFrom(LinkedHashSet.class)) {
                    convertedValue = new LinkedHashSet(list);
                } else if (targetClass.isAssignableFrom(TreeSet.class)) {
                    convertedValue = new TreeSet(list);
                }
            }
            if (convertedValue == null) {
                convertedValue = ConvertUtils.convert((Object)value, (Class)targetClass);
            }
        }
        return convertedValue;
    }

    private Object createNewTargetInstance(Class typeHint, JSONClassInfo classInfo, boolean object) {
        Object replacement;
        if (typeHint == null || typeHint.equals(Object.class)) {
            typeHint = object ? Map.class : List.class;
            if (log.isTraceEnabled()) {
                log.trace("replace null typeHint with " + typeHint);
            }
        }
        if (((Class)typeHint).isInterface() && (replacement = this.getReplacementForKnownInterface((Class)typeHint)) != null) {
            typeHint = replacement;
            if (log.isTraceEnabled()) {
                log.trace("interface replaced with " + typeHint);
            }
        }
        try {
            ConstructorInfo ctorInfo;
            for (ObjectFactory factory : this.objectFactories) {
                if (!factory.supports(typeHint)) continue;
                return factory.create(typeHint);
            }
            if (((Class)typeHint).isArray()) {
                return new ArrayList();
            }
            if (classInfo != null && (ctorInfo = classInfo.getConstructorInfo()) != null) {
                return new DelayedConstructor(ctorInfo);
            }
            return ((Class)typeHint).newInstance();
        }
        catch (InstantiationException e) {
            throw new SvensonRuntimeException("Error creating new instance of " + ((Class)typeHint).getName(), e);
        }
        catch (IllegalAccessException e) {
            throw ExceptionWrapper.wrap(e);
        }
    }

    private Class getTypeHint(ParseContext cx, String parsePathInfo, JSONTokenizer tokenizer, String name, boolean isProperty, boolean primitive) {
        Class cls;
        Class<Object> typeOfProperty;
        JSONPropertyInfo propertyInfo;
        Class<Object> memberType = cx.getMemberType();
        if (memberType == null && isProperty && (propertyInfo = cx.getClassInfo().getPropertyInfo(name)) != null && (typeOfProperty = propertyInfo.getType()) != null) {
            Class<Object> typeHint = propertyInfo.getTypeHint();
            memberType = typeHint != null && typeOfProperty.isAssignableFrom(typeHint) ? typeHint : typeOfProperty;
        }
        if (log.isTraceEnabled()) {
            log.trace("typeHint = " + memberType + ", name = " + name);
        }
        if ((cls = this.getTypeHint(parsePathInfo, tokenizer, memberType, !primitive)) != null) {
            memberType = cls;
            if (log.isTraceEnabled()) {
                log.trace("set typeHint to  " + memberType);
            }
        }
        return memberType;
    }

    private Class getTypeHint(String parsePathInfo, JSONTokenizer tokenizer, Class typeHint, boolean consultTypeMapper) {
        Class typeHintFromTypeMapper;
        for (Map.Entry<PathMatcher, Class> e : this.typeHints.entrySet()) {
            PathMatcher matcher = e.getKey();
            if (!matcher.matches(parsePathInfo, Object.class)) continue;
            if (log.isTraceEnabled()) {
                log.trace("Parse path '" + parsePathInfo + "' matches " + matcher + ": setting type hint to " + typeHint);
            }
            typeHint = e.getValue();
            break;
        }
        if (this.typeMapper != null && consultTypeMapper && (typeHintFromTypeMapper = this.typeMapper.getTypeHint(tokenizer, parsePathInfo, typeHint)) != null) {
            typeHint = typeHintFromTypeMapper;
        }
        return typeHint;
    }

    public void setTypeConverterRepository(DefaultTypeConverterRepository typeConverterRepository) {
        this.typeConverterRepository = typeConverterRepository;
    }

    private class ParseContext {
        private final Object target;
        private final ParseContext parent;
        private final Class memberType;
        private final JSONClassInfo classInfo;
        private String info = "";

        public ParseContext(Object target, Class memberType, JSONClassInfo classInfo) {
            this(target, memberType, null, classInfo);
        }

        private ParseContext(Object target, Class memberType, ParseContext parent, JSONClassInfo classInfo) {
            this.target = target;
            this.parent = parent;
            this.memberType = memberType;
            this.classInfo = classInfo;
        }

        public Class getMemberType() {
            return this.memberType;
        }

        public ParseContext push(Object target, Class memberType, String info, JSONClassInfo classInfo) {
            ParseContext child = new ParseContext(target, memberType, this, classInfo);
            child.info = this.info + info;
            return child;
        }

        public ParseContext pop() {
            return this.parent;
        }

        public String getParsePathInfo(String name) {
            String parsePathInfo = name.equals("[]") ? this.info + name : this.info + "." + name;
            return parsePathInfo;
        }

        public String toString() {
            return super.toString() + ", target = " + this.target + ", memberType = " + this.memberType + ", info = " + this.info;
        }

        public JSONClassInfo getClassInfo() {
            return this.classInfo;
        }
    }
}

