/*
 * Decompiled with CFR 0.152.
 */
package org.svenson;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.svenson.DynamicProperties;
import org.svenson.JSONParser;
import org.svenson.SvensonRuntimeException;
import org.svenson.info.ConstructorInfo;
import org.svenson.info.ParameterInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelayedConstructor<T>
implements DynamicProperties {
    private static Logger log = LoggerFactory.getLogger(DelayedConstructor.class);
    private final ConstructorInfo info;
    private final Object[] args;
    private final int wildCardArgsIndex;

    public DelayedConstructor(ConstructorInfo info) {
        if (log.isDebugEnabled()) {
            log.debug("DelayedConstructor for {}", info.getConstructor().getDeclaringClass());
        }
        this.info = info;
        Class<?>[] parameterTypes = info.getConstructor().getParameterTypes();
        this.args = new Object[parameterTypes.length];
        this.wildCardArgsIndex = info.getWildCardArgsIndex();
        if (this.wildCardArgsIndex >= 0) {
            this.args[this.wildCardArgsIndex] = new HashMap();
        }
    }

    public T construct() {
        try {
            Constructor<?> constructor = this.info.getConstructor();
            return (T)constructor.newInstance(this.args);
        }
        catch (IllegalArgumentException e) {
            throw new SvensonRuntimeException("Error constructing instance of " + this.info.getConstructor().getDeclaringClass().getName() + " with " + Arrays.toString(this.args), e);
        }
        catch (InstantiationException e) {
            throw new SvensonRuntimeException("Error constructing instance of " + this.info.getConstructor().getDeclaringClass().getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new SvensonRuntimeException("Error constructing instance of " + this.info.getConstructor().getDeclaringClass().getName(), e);
        }
        catch (InvocationTargetException e) {
            throw new SvensonRuntimeException("Error constructing instance of " + this.info.getConstructor().getDeclaringClass().getName(), e.getTargetException());
        }
    }

    public static <E> E unwrap(E t) {
        if (t instanceof DelayedConstructor) {
            return (E)((DelayedConstructor)t).construct();
        }
        return t;
    }

    @Override
    public void setProperty(String name, Object value) {
        Class<?>[] parameterTypes;
        Class<?> targetClass;
        ParameterInfo paramInfo = this.info.getParameterInfo(name);
        if (paramInfo == null) {
            if (this.wildCardArgsIndex >= 0) {
                this.wildCardMap().put(name, value);
                return;
            }
            throw new IllegalArgumentException("No constructor parameter for JSON property '" + name + "' in " + this.info.getConstructor().getDeclaringClass());
        }
        int index = paramInfo.getIndex();
        if (value != null && !(targetClass = (parameterTypes = this.info.getConstructor().getParameterTypes())[index]).equals(value.getClass())) {
            value = JSONParser.convertValueTo(value, targetClass, null);
        }
        this.args[index] = DelayedConstructor.unwrap(value);
    }

    private Map<String, Object> wildCardMap() {
        Object map = this.args[this.wildCardArgsIndex];
        if (map instanceof Map) {
            return (Map)map;
        }
        throw new SvensonRuntimeException("No map");
    }

    @Override
    public Object getProperty(String name) {
        ParameterInfo paramInfo = this.info.getParameterInfo(name);
        if (paramInfo == null) {
            if (this.wildCardArgsIndex >= 0) {
                return this.wildCardMap().get(name);
            }
            throw new IllegalArgumentException("No constructor parameter for JSON property '" + name + "' in " + this.info.getConstructor().getDeclaringClass());
        }
        int index = paramInfo.getIndex();
        return this.args[index];
    }

    @Override
    public Set<String> propertyNames() {
        Set<String> jsonPropertyNames = this.info.getJSONPropertyNames();
        if (this.wildCardArgsIndex < 0) {
            return jsonPropertyNames;
        }
        Set<String> wildCardKeys = this.wildCardMap().keySet();
        if (jsonPropertyNames.size() == 0) {
            return wildCardKeys;
        }
        if (wildCardKeys.size() == 0) {
            return jsonPropertyNames;
        }
        HashSet<String> set = new HashSet<String>(jsonPropertyNames);
        set.addAll(wildCardKeys);
        return set;
    }

    @Override
    public boolean hasProperty(String name) {
        return this.propertyNames().contains(name);
    }

    @Override
    public Object removeProperty(String name) {
        ParameterInfo paramInfo = this.info.getParameterInfo(name);
        if (paramInfo == null) {
            if (this.wildCardArgsIndex >= 0) {
                return this.wildCardMap().remove(name);
            }
            throw new IllegalArgumentException("No constructor parameter for JSON property '" + name + "' in " + this.info.getConstructor().getDeclaringClass());
        }
        int index = paramInfo.getIndex();
        Object old = this.args[index];
        this.args[index] = null;
        return old;
    }

    public ConstructorInfo getConstructorInfo() {
        return this.info;
    }

    public int getWildCardArgsIndex() {
        return this.wildCardArgsIndex;
    }

    public String toString() {
        return super.toString() + ": " + this.info.getConstructor().getDeclaringClass().getName() + "(" + Arrays.toString(this.args) + ")";
    }
}

