/*
 * Decompiled with CFR 0.152.
 */
package org.svenson;

import org.svenson.AbstractPropertyValueBasedTypeMapper;

public class ClassNameBasedTypeMapper
extends AbstractPropertyValueBasedTypeMapper {
    private String basePackage;
    private Class enforcedBaseType;

    public void setEnforcedBaseType(Class enforcedBaseType) {
        this.enforcedBaseType = enforcedBaseType;
    }

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    protected Class getTypeHintFromTypeProperty(Object o) throws IllegalStateException {
        if (o == null) {
            throw new IllegalArgumentException("class name can't be null");
        }
        String value = (String)o;
        if (this.basePackage != null) {
            value = this.basePackage + "." + value;
        }
        try {
            Class<?> cls = Class.forName(value);
            if (this.enforcedBaseType != null && !this.enforcedBaseType.isAssignableFrom(cls)) {
                throw new IllegalStateException(cls + " is not assignable to " + this.enforcedBaseType);
            }
            return cls;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("No class found for property '" + value + "'", e);
        }
    }
}

