/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.microservice.subscription.repository.impl;

import com.cumulocity.microservice.subscription.model.MicroserviceMetadataRepresentation;
import com.cumulocity.microservice.subscription.repository.CredentialsSwitchingPlatform;
import com.cumulocity.microservice.subscription.repository.MicroserviceRepository;
import com.cumulocity.microservice.subscription.repository.application.ApplicationApi;
import com.cumulocity.microservice.subscription.repository.application.ApplicationApiRepresentation;
import com.cumulocity.rest.representation.application.ApplicationMediaType;
import com.cumulocity.rest.representation.application.ApplicationRepresentation;
import com.cumulocity.rest.representation.application.ApplicationUserCollectionRepresentation;
import com.cumulocity.rest.representation.application.ApplicationUserRepresentation;
import com.cumulocity.sdk.client.RestOperations;
import com.cumulocity.sdk.client.SDKException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CurrentMicroserviceRepository
implements MicroserviceRepository {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CurrentMicroserviceRepository.class);
    private final CredentialsSwitchingPlatform platform;
    private final ApplicationApiRepresentation api;

    public CurrentMicroserviceRepository(CredentialsSwitchingPlatform platform, ApplicationApiRepresentation api) {
        this.platform = platform;
        this.api = api;
    }

    @Override
    public ApplicationRepresentation register(MicroserviceMetadataRepresentation metadata) {
        log.debug("Self registration procedure not activated for current application with {}", (Object)metadata);
        ApplicationRepresentation application = this.getCurrentApplication();
        if (application == null) {
            throw new SDKException("Failed to load current microservice. Microservice must be configured before running the SDK, please contact administrator");
        }
        if (!"MICROSERVICE".equals(application.getType())) {
            throw new SDKException("Failed to load current microservice. There is another application with name \"" + application.getName() + "\"");
        }
        return application;
    }

    @Override
    @Deprecated
    public ApplicationRepresentation register(String applicationNameNotUsed, MicroserviceMetadataRepresentation metadata) {
        return this.register(metadata);
    }

    @Override
    public ApplicationRepresentation getCurrentApplication() {
        try {
            return this.applicationApi().currentApplication().get();
        }
        catch (Exception ex) {
            return (ApplicationRepresentation)this.handleException("GET", this.api.getCurrentApplication(), ex);
        }
    }

    @Override
    public Iterable<ApplicationUserRepresentation> getSubscriptions() {
        String url = this.api.getCurrentApplicationSubscriptions();
        try {
            return (Iterable)this.rest().get(url, ApplicationMediaType.APPLICATION_USER_COLLECTION_MEDIA_TYPE, ApplicationUserCollectionRepresentation.class);
        }
        catch (Exception ex) {
            return (ApplicationUserCollectionRepresentation)this.handleException("GET", url, ex);
        }
    }

    @Override
    public Iterable<ApplicationUserRepresentation> getSubscriptions(String notUsedApplicationId) {
        return this.getSubscriptions();
    }

    private RestOperations rest() {
        return this.platform.get();
    }

    private Object handleException(String method, String url, Exception ex) {
        if (ex instanceof SDKException) {
            SDKException sdkException = (SDKException)ex;
            if (sdkException.getHttpStatus() == 403 || sdkException.getHttpStatus() == 401) {
                log.warn("User has no permission to api " + method + " " + url);
                log.debug("Details :", (Throwable)ex);
                return null;
            }
            if (sdkException.getHttpStatus() == 404) {
                log.warn("Not found " + method + " " + url + "(" + ex.getMessage() + ")");
                log.debug("Details :", (Throwable)ex);
                return null;
            }
        }
        throw new SDKException("Error invoking " + method + " " + url, (Throwable)ex);
    }

    private ApplicationApi applicationApi() {
        return new ApplicationApi(this.platform.get(), this.api);
    }
}

