/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.microservice.subscription.repository;

import com.cumulocity.microservice.subscription.repository.CredentialsSwitchingPlatform;
import com.cumulocity.microservice.subscription.repository.DefaultCredentialsSwitchingPlatform;
import com.cumulocity.microservice.subscription.repository.MicroserviceRepository;
import com.cumulocity.microservice.subscription.repository.application.ApplicationApiRepresentation;
import com.cumulocity.microservice.subscription.repository.impl.CurrentMicroserviceRepository;
import com.cumulocity.microservice.subscription.repository.impl.LegacyMicroserviceRepository;
import com.cumulocity.model.authentication.CumulocityBasicCredentials;
import com.cumulocity.model.authentication.CumulocityCredentials;
import com.google.common.base.Supplier;
import org.springframework.core.env.Environment;
import org.springframework.core.env.StandardEnvironment;

public class MicroserviceRepositoryBuilder {
    public static final String MICROSERVICE_ISOLATION_ENV_NAME = "C8Y.microservice.isolation";
    private Supplier<String> baseUrl;
    private String tenant;
    private String username;
    private String password;
    private CredentialsSwitchingPlatform connector;
    private Environment environment;
    private String applicationName;
    private String applicationKey;

    public MicroserviceRepository build() {
        StandardEnvironment notNullEnvironment;
        CumulocityBasicCredentials credentials = CumulocityBasicCredentials.builder().username(this.username).password(this.password).tenantId(this.tenant).build();
        CredentialsSwitchingPlatform nonNullConnector = this.connector != null ? this.connector : new DefaultCredentialsSwitchingPlatform(this.baseUrl).switchTo((CumulocityCredentials)credentials);
        ApplicationApiRepresentation api = ApplicationApiRepresentation.of(this.baseUrl);
        Object object = notNullEnvironment = this.environment == null ? new StandardEnvironment() : this.environment;
        if (notNullEnvironment.containsProperty(MICROSERVICE_ISOLATION_ENV_NAME)) {
            return new CurrentMicroserviceRepository(nonNullConnector, api);
        }
        return new LegacyMicroserviceRepository(this.applicationName, this.applicationKey, nonNullConnector, api);
    }

    private MicroserviceRepositoryBuilder() {
    }

    public static MicroserviceRepositoryBuilder microserviceRepositoryBuilder() {
        return new MicroserviceRepositoryBuilder();
    }

    public MicroserviceRepositoryBuilder baseUrl(Supplier<String> baseUrl) {
        this.baseUrl = baseUrl;
        return this;
    }

    public MicroserviceRepositoryBuilder tenant(String tenant) {
        this.tenant = tenant;
        return this;
    }

    public MicroserviceRepositoryBuilder username(String username) {
        this.username = username;
        return this;
    }

    public MicroserviceRepositoryBuilder applicationName(String applicationName) {
        this.applicationName = applicationName;
        return this;
    }

    public MicroserviceRepositoryBuilder applicationKey(String applicationKey) {
        this.applicationKey = applicationKey;
        return this;
    }

    public MicroserviceRepositoryBuilder password(String password) {
        this.password = password;
        return this;
    }

    public MicroserviceRepositoryBuilder connector(CredentialsSwitchingPlatform connector) {
        this.connector = connector;
        return this;
    }

    public MicroserviceRepositoryBuilder environment(Environment environment) {
        this.environment = environment;
        return this;
    }
}

