/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.microservice.subscription.rest;

import com.cumulocity.microservice.subscription.service.MicroserviceSubscriptionsService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="microservice")
public class MicroserviceController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MicroserviceController.class);
    @Autowired(required=false)
    private MicroserviceSubscriptionsService microserviceSubscriptionsService;

    @GetMapping(value={"/refreshSubscriptions"})
    public RefreshStatus refreshSubscriptions() {
        if (this.microserviceSubscriptionsService == null) {
            return RefreshStatus.DISABLED;
        }
        try {
            this.microserviceSubscriptionsService.subscribe();
            return RefreshStatus.OK;
        }
        catch (Exception ex) {
            log.error("Cannot refresh microservice subscriptions", (Throwable)ex);
            return RefreshStatus.FAILED;
        }
    }

    public static class RefreshStatus {
        private static RefreshStatus DISABLED = new RefreshStatus("DISABLED");
        private static RefreshStatus OK = new RefreshStatus("OK");
        private static RefreshStatus FAILED = new RefreshStatus("FAILED");
        private String status;

        public RefreshStatus(String status) {
            this.status = status;
        }

        public String getStatus() {
            return this.status;
        }

        public RefreshStatus setStatus(String status) {
            this.status = status;
            return this;
        }
    }
}

