/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.microservice.subscription.repository.impl;

import com.cumulocity.microservice.subscription.model.MicroserviceMetadataRepresentation;
import com.cumulocity.microservice.subscription.repository.CredentialsSwitchingPlatform;
import com.cumulocity.microservice.subscription.repository.MicroserviceRepository;
import com.cumulocity.microservice.subscription.repository.application.ApplicationApi;
import com.cumulocity.microservice.subscription.repository.application.ApplicationApiRepresentation;
import com.cumulocity.rest.representation.application.ApplicationMediaType;
import com.cumulocity.rest.representation.application.ApplicationRepresentation;
import com.cumulocity.rest.representation.application.ApplicationUserCollectionRepresentation;
import com.cumulocity.rest.representation.application.ApplicationUserRepresentation;
import com.cumulocity.sdk.client.RestOperations;
import com.cumulocity.sdk.client.SDKException;
import com.google.common.base.Preconditions;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyMicroserviceRepository
implements MicroserviceRepository {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LegacyMicroserviceRepository.class);
    private final CredentialsSwitchingPlatform platform;
    private final ApplicationApiRepresentation api;
    private final String applicationName;
    private String applicationKey;

    public LegacyMicroserviceRepository(String applicationName, String applicationKey, CredentialsSwitchingPlatform platform, ApplicationApiRepresentation api) {
        if (StringUtils.isBlank((CharSequence)applicationName)) {
            log.warn("Current application name was not provided to LegacyMicroserviceRepository. Please correct LegacyMicroserviceRepository usage in your code.");
        }
        this.applicationName = applicationName;
        this.applicationKey = applicationKey;
        this.platform = platform;
        this.api = api;
    }

    @Deprecated
    public LegacyMicroserviceRepository(CredentialsSwitchingPlatform platform, ApplicationApiRepresentation api) {
        this(null, null, platform, api);
    }

    @Override
    public ApplicationRepresentation register(MicroserviceMetadataRepresentation metadata) {
        Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)this.applicationName), (Object)"Application name must be provided at construction time to use one argument register method.");
        return this.register(this.applicationName, metadata);
    }

    @Override
    @Deprecated
    public ApplicationRepresentation register(String applicationName, MicroserviceMetadataRepresentation metadata) {
        log.debug("registering {} with {}", (Object)applicationName, (Object)metadata);
        ApplicationRepresentation application = this.getByName(applicationName);
        if (application == null) {
            return this.create(applicationName, metadata);
        }
        if (!"MICROSERVICE".equals(application.getType())) {
            throw new SDKException("Cannot register application. There is another application with name \"" + applicationName + "\"");
        }
        return this.update(application, metadata);
    }

    @Override
    public ApplicationRepresentation getCurrentApplication() {
        Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)this.applicationName), (Object)"You need to provide current application name at construction time to use method getCurrentApplication.");
        return this.getByName(this.applicationName);
    }

    @Override
    public Iterable<ApplicationUserRepresentation> getSubscriptions() {
        ApplicationRepresentation currentApplication = this.getCurrentApplication();
        Preconditions.checkState((currentApplication != null ? 1 : 0) != 0, (Object)"Cannot get subscriptions. Current application not found.");
        return this.getSubscriptions(currentApplication.getId());
    }

    @Override
    public Iterable<ApplicationUserRepresentation> getSubscriptions(String applicationId) {
        String url = this.api.getApplicationSubscriptions(applicationId);
        try {
            return (Iterable)this.rest().get(url, ApplicationMediaType.APPLICATION_USER_COLLECTION_MEDIA_TYPE, ApplicationUserCollectionRepresentation.class);
        }
        catch (Exception ex) {
            return (ApplicationUserCollectionRepresentation)this.handleException("GET", url, ex);
        }
    }

    private ApplicationRepresentation getByName(String applicationName) {
        try {
            Optional<ApplicationRepresentation> byName = this.applicationApi().getByName(applicationName);
            return byName.orElse(null);
        }
        catch (Exception ex) {
            return (ApplicationRepresentation)this.handleException("GET", this.api.getFindByNameUrl(applicationName), ex);
        }
    }

    private ApplicationRepresentation create(String applicationName, MicroserviceMetadataRepresentation representation) {
        try {
            ApplicationRepresentation application = new ApplicationRepresentation();
            application.setName(applicationName);
            application.setKey((String)(StringUtils.isNotBlank((CharSequence)this.applicationKey) ? this.applicationKey : applicationName + "-application-key"));
            application.setType("MICROSERVICE");
            application.setRequiredRoles(representation.getRequiredRoles());
            application.setRoles(representation.getRoles());
            application.setUrl(representation.getUrl());
            application.set(representation.getExtensions(), "extensions");
            return this.applicationApi().create(application);
        }
        catch (Exception ex) {
            return (ApplicationRepresentation)this.handleException("POST", this.api.getCollectionUrl(), ex);
        }
    }

    private ApplicationRepresentation update(ApplicationRepresentation source, MicroserviceMetadataRepresentation metadata) {
        try {
            ApplicationRepresentation application = new ApplicationRepresentation();
            application.setId(source.getId());
            application.setRequiredRoles(metadata.getRequiredRoles());
            application.setRoles(metadata.getRoles());
            application.setUrl(metadata.getUrl());
            application.set(metadata.getExtensions(), "extensions");
            return this.applicationApi().update(application);
        }
        catch (Exception ex) {
            return (ApplicationRepresentation)this.handleException("PUT", this.api.getByIdUrl(source.getId()), ex);
        }
    }

    private RestOperations rest() {
        return this.platform.get();
    }

    private Object handleException(String method, String url, Exception ex) {
        if (ex instanceof SDKException) {
            SDKException sdkException = (SDKException)ex;
            if (sdkException.getHttpStatus() == 403 || sdkException.getHttpStatus() == 401) {
                log.warn("User has no permission to api " + method + " " + url);
                log.debug("Details :", (Throwable)ex);
                return null;
            }
            if (sdkException.getHttpStatus() == 404) {
                log.warn("Not found " + method + " " + url + "(" + ex.getMessage() + ")");
                log.debug("Details :", (Throwable)ex);
                return null;
            }
        }
        throw new SDKException("Error invoking " + method + " " + url, (Throwable)ex);
    }

    private ApplicationApi applicationApi() {
        return new ApplicationApi(this.platform.get(), this.api);
    }
}

