/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.microservice.subscription.repository.application;

import com.cumulocity.microservice.subscription.repository.application.ApplicationApiRepresentation;
import com.cumulocity.microservice.subscription.repository.application.CurrentApplicationApi;
import com.cumulocity.rest.representation.CumulocityMediaType;
import com.cumulocity.rest.representation.ResourceRepresentation;
import com.cumulocity.rest.representation.application.ApplicationCollectionRepresentation;
import com.cumulocity.rest.representation.application.ApplicationMediaType;
import com.cumulocity.rest.representation.application.ApplicationRepresentation;
import com.cumulocity.rest.representation.application.ApplicationUserRepresentation;
import com.cumulocity.rest.representation.user.UserMediaType;
import com.cumulocity.sdk.client.RestOperations;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import jakarta.ws.rs.core.MediaType;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationApi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApplicationApi.class);
    private final RestOperations rest;
    private final ApplicationApiRepresentation microserviceApi;

    public ApplicationApi(RestOperations rest) {
        this(rest, ApplicationApiRepresentation.of((Supplier<String>)Suppliers.ofInstance((Object)"")));
    }

    public ApplicationApi(RestOperations rest, ApplicationApiRepresentation microserviceApi) {
        this.rest = rest;
        this.microserviceApi = microserviceApi;
    }

    public ApplicationCollectionRepresentation list() {
        return (ApplicationCollectionRepresentation)this.rest.get(this.microserviceApi.getCollectionUrl(), (CumulocityMediaType)ApplicationMediaType.APPLICATION_COLLECTION, ApplicationCollectionRepresentation.class);
    }

    public Optional<ApplicationRepresentation> getByName(String name) {
        ApplicationCollectionRepresentation response = (ApplicationCollectionRepresentation)this.rest.get(this.microserviceApi.getFindByNameUrl(name), (CumulocityMediaType)ApplicationMediaType.APPLICATION_COLLECTION, ApplicationCollectionRepresentation.class);
        if (response.getApplications().size() == 1) {
            return Optional.of((ApplicationRepresentation)response.getApplications().get(0));
        }
        return Optional.empty();
    }

    public ApplicationRepresentation create(ApplicationRepresentation application) {
        return (ApplicationRepresentation)this.rest.post(this.microserviceApi.getCollectionUrl(), (MediaType)ApplicationMediaType.APPLICATION, (ResourceRepresentation)application);
    }

    public ApplicationUserRepresentation getBootstrapUser(String applicationId) {
        return (ApplicationUserRepresentation)this.rest.get(this.microserviceApi.getBootstrapUserUrl(applicationId), (CumulocityMediaType)UserMediaType.USER, ApplicationUserRepresentation.class);
    }

    public ApplicationRepresentation update(ApplicationRepresentation update) {
        return (ApplicationRepresentation)this.rest.put(this.microserviceApi.getByIdUrl(update.getId()), (MediaType)ApplicationMediaType.APPLICATION, (ResourceRepresentation)update);
    }

    public CurrentApplicationApi currentApplication() {
        return new CurrentApplicationApi(this.rest, this.microserviceApi);
    }
}

