/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.microservice.subscription.model.core;

import com.cumulocity.microservice.context.credentials.Credentials;
import com.cumulocity.microservice.context.credentials.MicroserviceCredentials;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;

public class PlatformProperties {
    private String applicationName;
    private String applicationKey;
    private Supplier<String> url;
    private Supplier<String> mqttUrl;
    private Credentials microserviceBoostrapUser;
    private Credentials microserviceUser;
    private Integer subscriptionDelay;
    private Integer subscriptionInitialDelay;
    private IsolationLevel isolation;
    private boolean forceInitialHost;

    @ConstructorProperties(value={"applicationName", "applicationKey", "url", "mqttUrl", "microserviceBoostrapUser", "microserviceUser", "subscriptionDelay", "subscriptionInitialDelay", "isolation"})
    public PlatformProperties(String applicationName, String applicationKey, Supplier<String> url, Supplier<String> mqttUrl, Credentials microserviceBoostrapUser, Credentials microserviceUser, Integer subscriptionDelay, Integer subscriptionInitialDelay, IsolationLevel isolation, boolean forceInitialHost) {
        this.applicationName = applicationName;
        this.applicationKey = applicationKey;
        this.url = url;
        this.mqttUrl = mqttUrl;
        this.microserviceBoostrapUser = microserviceBoostrapUser;
        this.microserviceUser = microserviceUser;
        this.subscriptionDelay = subscriptionDelay;
        this.subscriptionInitialDelay = subscriptionInitialDelay;
        this.isolation = isolation;
        this.forceInitialHost = forceInitialHost;
    }

    public static PlatformPropertiesBuilder builder() {
        return new PlatformPropertiesBuilder();
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getApplicationKey() {
        return this.applicationKey;
    }

    public Supplier<String> getUrl() {
        return this.url;
    }

    public Supplier<String> getMqttUrl() {
        return this.mqttUrl;
    }

    public Credentials getMicroserviceBoostrapUser() {
        return this.microserviceBoostrapUser;
    }

    public Credentials getMicroserviceUser() {
        return this.microserviceUser;
    }

    public Integer getSubscriptionDelay() {
        return this.subscriptionDelay;
    }

    public Integer getSubscriptionInitialDelay() {
        return this.subscriptionInitialDelay;
    }

    public IsolationLevel getIsolation() {
        return this.isolation;
    }

    public boolean getForceInitialHost() {
        return this.forceInitialHost;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public void setApplicationKey(String applicationKey) {
        this.applicationKey = applicationKey;
        if (this.microserviceUser instanceof MicroserviceCredentials) {
            ((MicroserviceCredentials)this.microserviceUser).setAppKey(applicationKey);
        }
    }

    public void setUrl(Supplier<String> url) {
        this.url = url;
    }

    public void setMqttUrl(Supplier<String> mqttUrl) {
        this.mqttUrl = mqttUrl;
    }

    public void setMicroserviceBoostrapUser(Credentials microserviceBoostrapUser) {
        this.microserviceBoostrapUser = microserviceBoostrapUser;
    }

    public void setMicroserviceUser(Credentials microserviceUser) {
        this.microserviceUser = microserviceUser;
    }

    public void setSubscriptionDelay(Integer subscriptionDelay) {
        this.subscriptionDelay = subscriptionDelay;
    }

    public void setSubscriptionInitialDelay(Integer subscriptionInitialDelay) {
        this.subscriptionInitialDelay = subscriptionInitialDelay;
    }

    public void setIsolation(IsolationLevel isolation) {
        this.isolation = isolation;
    }

    public String toString() {
        return "PlatformProperties(applicationName=" + this.getApplicationName() + ", applicationKey=" + this.applicationKey + ", url=" + this.getUrl() + ", mqttUrl=" + this.getMqttUrl() + ", microserviceBoostrapUser=" + this.getMicroserviceBoostrapUser() + ", microserviceUser=" + this.getMicroserviceUser() + ", subscriptionDelay=" + this.getSubscriptionDelay() + ", subscriptionInitialDelay=" + this.getSubscriptionInitialDelay() + ", isolation=" + this.getIsolation() + ", forceInitialHost=" + this.getForceInitialHost() + " )";
    }

    public static enum IsolationLevel {
        PER_TENANT,
        MULTI_TENANT;

    }

    public static class PlatformPropertiesBuilder {
        private String applicationName;
        private String applicationKey;
        private Supplier<String> url;
        private Supplier<String> mqttUrl;
        private Credentials microserviceBoostrapUser;
        private Credentials microserviceUser;
        private Integer subscriptionDelay;
        private Integer subscriptionInitialDelay;
        private IsolationLevel isolation;
        private boolean forceInitialHost;

        PlatformPropertiesBuilder() {
        }

        public PlatformPropertiesBuilder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public PlatformPropertiesBuilder applicationKey(String applicationKey) {
            this.applicationKey = applicationKey;
            return this;
        }

        public PlatformPropertiesBuilder url(Supplier<String> url) {
            this.url = url;
            return this;
        }

        public PlatformPropertiesBuilder mqttUrl(Supplier<String> mqttUrl) {
            this.mqttUrl = mqttUrl;
            return this;
        }

        public PlatformPropertiesBuilder microserviceBoostrapUser(Credentials microserviceBoostrapUser) {
            this.microserviceBoostrapUser = microserviceBoostrapUser;
            return this;
        }

        public PlatformPropertiesBuilder microserviceUser(Credentials microserviceUser) {
            this.microserviceUser = microserviceUser;
            return this;
        }

        public PlatformPropertiesBuilder subscriptionDelay(Integer subscriptionDelay) {
            this.subscriptionDelay = subscriptionDelay;
            return this;
        }

        public PlatformPropertiesBuilder subscriptionInitialDelay(Integer subscriptionInitialDelay) {
            this.subscriptionInitialDelay = subscriptionInitialDelay;
            return this;
        }

        public PlatformPropertiesBuilder isolation(IsolationLevel isolation) {
            this.isolation = isolation;
            return this;
        }

        public PlatformPropertiesBuilder forceInitialHost(boolean forceInitialHost) {
            this.forceInitialHost = forceInitialHost;
            return this;
        }

        public PlatformProperties build() {
            return new PlatformProperties(this.applicationName, this.applicationKey, this.url, this.mqttUrl, this.microserviceBoostrapUser, this.microserviceUser, this.subscriptionDelay, this.subscriptionInitialDelay, this.isolation, this.forceInitialHost);
        }

        public String toString() {
            return "PlatformProperties.PlatformPropertiesBuilder(applicationName=" + this.applicationName + ", applicationKey=" + this.applicationKey + ", url=" + this.url + ", mqttUrl=" + this.mqttUrl + ", microserviceBoostrapUser=" + this.microserviceBoostrapUser + ", microserviceUser=" + this.microserviceUser + ", subscriptionDelay=" + this.subscriptionDelay + ", subscriptionInitialDelay=" + this.subscriptionInitialDelay + ", isolation=" + this.isolation + ")";
        }
    }

    public static class PlatformPropertiesProvider {
        @Generated
        private static final Logger log = LoggerFactory.getLogger(PlatformPropertiesProvider.class);
        @Value(value="${C8Y.bootstrap.register:true}")
        private boolean autoRegistration;
        @Value(value="${application.name:}")
        private String applicationName;
        @Value(value="${application.key:}")
        private String applicationKey;
        @Value(value="${C8Y.baseURL:${platform.url:http://localhost:8181}}")
        private String url;
        @Value(value="${C8Y.baseURL.mqtt:${platform.url.mqtt:tcp://localhost:1883}}")
        private String mqttUrl;
        @Value(value="${C8Y.forceInitialHost:${platform.forceInitialHost:true}}")
        private boolean forceInitialHost;
        @Value(value="${C8Y.bootstrap.tenant:${platform.bootstrap.agent.tenant:management}}")
        private String microserviceBootstrapTenant;
        @Value(value="${C8Y.bootstrap.user:${platform.bootstrap.agent.name:servicebootstrap}}")
        private String microserviceBootstrapName;
        @Value(value="${C8Y.bootstrap.password:${platform.bootstrap.agent.password:!j5iBT0GE7,a73s2;4q51h_52m&6%#}}")
        private String microserviceBootstrapPassword;
        @Value(value="${C8Y.tenant:}")
        private String microserviceTenant;
        @Value(value="${C8Y.user:}")
        private String microserviceUser;
        @Value(value="${C8Y.password:}")
        private String microservicePassword;
        @Value(value="${C8Y.bootstrap.delay:${platform.bootstrap.agent.delay:10000}}")
        private int microserviceSubscriptionDelay;
        @Value(value="${C8Y.bootstrap.initialDelay:30000}")
        private int microserviceSubscriptionInitialDelay;
        @Value(value="${C8Y.microservice.isolation:}")
        private String isolation;

        public PlatformProperties platformProperties(String defaultName) {
            String name = !StringUtils.isEmpty((Object)this.applicationName) ? this.applicationName : defaultName;
            if (StringUtils.isEmpty((Object)name)) {
                throw new IllegalStateException("Please set up application name");
            }
            IsolationLevel isolationLevel = Strings.isNullOrEmpty((String)this.isolation) ? null : IsolationLevel.valueOf(this.isolation);
            return PlatformProperties.builder().url((Supplier<String>)Suppliers.ofInstance((Object)this.url)).mqttUrl((Supplier<String>)Suppliers.ofInstance((Object)this.mqttUrl)).microserviceBoostrapUser((Credentials)MicroserviceCredentials.builder().tenant(this.microserviceBootstrapTenant).username(this.microserviceBootstrapName).password(this.microserviceBootstrapPassword).oAuthAccessToken(null).xsrfToken(null).build()).microserviceUser((Credentials)(IsolationLevel.PER_TENANT.equals((Object)isolationLevel) ? MicroserviceCredentials.builder().tenant(this.microserviceTenant).username(this.microserviceUser).password(this.microservicePassword).oAuthAccessToken(null).xsrfToken(null).appKey(this.applicationKey).build() : null)).subscriptionDelay(this.microserviceSubscriptionDelay).subscriptionInitialDelay(this.microserviceSubscriptionInitialDelay).applicationName(name).applicationKey(this.applicationKey).isolation(isolationLevel).forceInitialHost(this.forceInitialHost).build();
        }
    }
}

